/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.login;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.lobby.client.LobbyClient;
import games.strategy.engine.lobby.client.login.CreateUpdateAccountPanel;
import games.strategy.engine.lobby.client.login.LobbyServerProperties;
import games.strategy.engine.lobby.client.login.LoginPanel;
import games.strategy.engine.lobby.server.LobbyServer;
import games.strategy.net.ClientMessenger;
import games.strategy.net.CouldNotLogInException;
import games.strategy.net.IConnectionLogin;
import games.strategy.net.MacFinder;
import games.strategy.util.MD5Crypt;
import java.awt.Window;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;

public class LobbyLogin {
    private final Window m_parent;
    private final LobbyServerProperties m_serverProperties;

    public LobbyLogin(Window parent, LobbyServerProperties properties) {
        this.m_parent = parent;
        this.m_serverProperties = properties;
    }

    public LobbyClient login() {
        if (!this.m_serverProperties.isServerAvailable()) {
            JOptionPane.showMessageDialog(this.m_parent, this.m_serverProperties.getServerErrorMessage(), "Could not connect to server", 0);
            return null;
        }
        if (this.m_serverProperties.getPort() == -1) {
            if (GameRunner2.areWeOldExtraJar()) {
                JOptionPane.showMessageDialog(this.m_parent, "<html>Could not find lobby server for this version of TripleA, <br>Please make sure you are using the latest version: http://triplea.sourceforge.net/ <br /><br />This is because you are using an old engine that is kept for backwards compatibility. <br /><b>In order to load your Old savegames in the New lobby, you must First join the lobby with the latest engine, Then host a game, Then load the old savegame!</b></html>", "Could not connect to server", 0);
            } else {
                JOptionPane.showMessageDialog(this.m_parent, "<html>Could not find lobby server for this version of TripleA, <br>Please make sure you are using the latest version: http://triplea.sourceforge.net/</html>", "Could not connect to server", 0);
            }
            return null;
        }
        return this.loginToServer();
    }

    private LobbyClient loginToServer() {
        LoginPanel panel = new LoginPanel();
        LoginPanel.ReturnValue value = panel.show(this.m_parent);
        if (value == LoginPanel.ReturnValue.LOGON) {
            return this.login(panel);
        }
        if (value == LoginPanel.ReturnValue.CANCEL) {
            return null;
        }
        if (value == LoginPanel.ReturnValue.CREATE_ACCOUNT) {
            return this.createAccount();
        }
        throw new IllegalStateException("??");
    }

    private LobbyClient login(final LoginPanel panel) {
        try {
            String mac = MacFinder.GetHashedMacAddress();
            ClientMessenger messenger = new ClientMessenger(this.m_serverProperties.getHost(), this.m_serverProperties.getPort(), panel.getUserName(), mac, new IConnectionLogin(){
                private final AtomicReference<String> m_internalError = new AtomicReference();

                @Override
                public void notifyFailedLogin(String message) {
                    if (this.m_internalError.get() != null) {
                        message = this.m_internalError.get();
                    }
                    JOptionPane.showMessageDialog(LobbyLogin.this.m_parent, message, "Login Failed", 0);
                }

                @Override
                public Map<String, String> getProperties(Map<String, String> challengProperties) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    if (panel.isAnonymous()) {
                        props.put("ANONYMOUS_LOGIN", Boolean.TRUE.toString());
                    } else {
                        String salt = challengProperties.get("SALT");
                        if (salt == null) {
                            this.m_internalError.set("No account with that name exists");
                            salt = "none";
                        }
                        String hashedPassword = MD5Crypt.crypt(panel.getPassword(), salt);
                        props.put("HASHEDPWD", hashedPassword);
                    }
                    props.put("LOBBY_VERSION", LobbyServer.LOBBY_VERSION.toString());
                    return props;
                }
            });
            LoginPanel.storePrefs(panel.getUserName(), panel.isAnonymous());
            return new LobbyClient(messenger, panel.isAnonymous());
        }
        catch (CouldNotLogInException clne) {
            return this.loginToServer();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.m_parent, "Could Not Connect to Lobby : " + ioe.getMessage(), "Could not connect", 0);
            return null;
        }
    }

    private LobbyClient createAccount() {
        CreateUpdateAccountPanel createAccount = CreateUpdateAccountPanel.newCreatePanel();
        CreateUpdateAccountPanel.ReturnValue value = createAccount.show(this.m_parent);
        if (value == CreateUpdateAccountPanel.ReturnValue.OK) {
            return this.createAccount(createAccount);
        }
        return null;
    }

    private LobbyClient createAccount(final CreateUpdateAccountPanel createAccount) {
        try {
            String mac = MacFinder.GetHashedMacAddress();
            ClientMessenger messenger = new ClientMessenger(this.m_serverProperties.getHost(), this.m_serverProperties.getPort(), createAccount.getUserName(), mac, new IConnectionLogin(){

                @Override
                public void notifyFailedLogin(String message) {
                    JOptionPane.showMessageDialog(LobbyLogin.this.m_parent, message, "Login Failed", 0);
                }

                @Override
                public Map<String, String> getProperties(Map<String, String> challengProperties) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("REGISTER_USER", Boolean.TRUE.toString());
                    props.put("EMAIL", createAccount.getEmail());
                    props.put("HASHEDPWD", MD5Crypt.crypt(createAccount.getPassword()));
                    props.put("LOBBY_VERSION", LobbyServer.LOBBY_VERSION.toString());
                    return props;
                }
            });
            LoginPanel.storePrefs(createAccount.getUserName(), false);
            return new LobbyClient(messenger, false);
        }
        catch (CouldNotLogInException clne) {
            return this.createAccount();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.m_parent, ioe.getMessage(), "Account creation failed", 0);
            return null;
        }
    }
}

