/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.framework.TripleAProcessRunner;
import games.strategy.engine.framework.startup.ui.ServerOptions;
import games.strategy.engine.lobby.client.ui.LobbyGameTable;
import games.strategy.engine.lobby.client.ui.LobbyGameTableModel;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.net.Messengers;
import games.strategy.net.Node;
import games.strategy.ui.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobbyGamePanel
extends JPanel {
    private static final long serialVersionUID = -7829506356288575574L;
    private JButton m_hostGame;
    private JButton m_joinGame;
    private JButton m_bootGame;
    private LobbyGameTableModel m_gameTableModel;
    private final Messengers m_messengers;
    private JTable m_gameTable;
    private TableSorter m_tableSorter;

    public LobbyGamePanel(Messengers messengers) {
        this.m_messengers = messengers;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_hostGame = new JButton("Host Game");
        this.m_joinGame = new JButton("Join Game");
        this.m_bootGame = new JButton("Boot Game");
        this.m_gameTableModel = new LobbyGameTableModel(this.m_messengers.getMessenger(), this.m_messengers.getChannelMessenger(), this.m_messengers.getRemoteMessenger());
        this.m_tableSorter = new TableSorter(this.m_gameTableModel);
        this.m_gameTable = new LobbyGameTable(this.m_tableSorter);
        this.m_tableSorter.setTableHeader(this.m_gameTable.getTableHeader());
        this.m_gameTable.setColumnSelectionAllowed(false);
        this.m_gameTable.setRowSelectionAllowed(true);
        this.m_gameTable.setSelectionMode(0);
        int dateColumn = this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Started);
        this.m_tableSorter.setSortingStatus(dateColumn, -1);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Players)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Round)).setPreferredWidth(40);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.P)).setPreferredWidth(12);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.B)).setPreferredWidth(12);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.GV)).setPreferredWidth(32);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.EV)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Started)).setPreferredWidth(54);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Status)).setPreferredWidth(110);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Name)).setPreferredWidth(148);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Comments)).setPreferredWidth(148);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Host)).setPreferredWidth(60);
        this.m_gameTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -2807387751127250972L;
            private final SimpleDateFormat format = new SimpleDateFormat("hh:mm a");

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(this.format.format((Date)value));
                return this;
            }
        });
    }

    private void layoutComponents() {
        JScrollPane scroll = new JScrollPane(this.m_gameTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.m_hostGame);
        toolBar.add(this.m_joinGame);
        if (this.isAdmin()) {
            toolBar.add(this.m_bootGame);
        }
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "South");
    }

    public boolean isAdmin() {
        return ((IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName())).isAdmin();
    }

    private void setupListeners() {
        this.m_hostGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.hostGame();
            }
        });
        this.m_joinGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.joinGame();
            }
        });
        this.m_bootGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootGame();
            }
        });
        this.m_gameTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LobbyGamePanel.this.setWidgetActivation();
            }
        });
        this.m_gameTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LobbyGamePanel.this.joinGame();
                }
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            public void mousePressed(MouseEvent e) {
                int r = LobbyGamePanel.this.m_gameTable.rowAtPoint(e.getPoint());
                if (r >= 0 && r < LobbyGamePanel.this.m_gameTable.getRowCount()) {
                    LobbyGamePanel.this.m_gameTable.setRowSelectionInterval(r, r);
                } else {
                    LobbyGamePanel.this.m_gameTable.clearSelection();
                }
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            public void mouseReleased(MouseEvent e) {
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void mouseOnGamesList(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        JPopupMenu menu = new JPopupMenu();
        boolean hasActions = false;
        for (Action a : this.getGamesListRightClickActions(description)) {
            if (a == null) continue;
            hasActions = true;
            menu.add(a);
        }
        if (hasActions) {
            menu.show(this.m_gameTable, e.getX(), e.getY());
        }
    }

    private List<Action> getGamesListRightClickActions(GameDescription description) {
        ArrayList<Action> rVal = new ArrayList<Action>();
        rVal.add(this.getJoinGameAction());
        rVal.add(this.getHostGameAction());
        if (this.isAdmin()) {
            rVal.add(this.getHostSupportInfoAction(description));
            rVal.add(this.getBootGameAction());
        }
        return rVal;
    }

    private Action getHostSupportInfoAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        final String text = "Support Email for this Host is as follows. \n(Please copy the email address below and manually email them ONLY if something is seriously \nwrong with the host, like it needs to be restarted because it is down and not working at all.) \n\nEmail: \n" + supportEmail;
        return new AbstractAction("Show Host Support Information/Email"){
            private static final long serialVersionUID = -8291828709227364205L;

            public void actionPerformed(ActionEvent e) {
                JTextPane textPane = new JTextPane();
                textPane.setEditable(false);
                textPane.setText(text);
                JOptionPane.showMessageDialog(null, textPane, "Host Support Info", 1);
            }
        };
    }

    private Action getJoinGameAction() {
        return new AbstractAction("Join Game"){
            private static final long serialVersionUID = 1238500960279152158L;

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.joinGame();
            }
        };
    }

    private Action getHostGameAction() {
        return new AbstractAction("Host Game"){
            private static final long serialVersionUID = 2256758711590833222L;

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.hostGame();
            }
        };
    }

    private Action getBootGameAction() {
        return new AbstractAction("Boot Game"){
            private static final long serialVersionUID = 2256758711590833222L;

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootGame();
            }
        };
    }

    private void joinGame() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        TripleAProcessRunner.joinGame(description, this.m_messengers, this.getParent());
    }

    protected void hostGame() {
        ServerOptions options = new ServerOptions((Component)JOptionPane.getFrameForComponent(this), this.m_messengers.getMessenger().getLocalNode().getName(), 3300, true);
        options.setLocationRelativeTo(JOptionPane.getFrameForComponent(this));
        options.setNameEditable(false);
        options.setVisible(true);
        if (!options.getOKPressed()) {
            return;
        }
        TripleAProcessRunner.hostGame(options.getPort(), options.getName(), options.getComments(), options.getPassword(), this.m_messengers);
    }

    private void bootGame() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to disconnect the selected game?", "Remove Game From Lobby", 2);
        if (result != 0) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        Node lobbyWatcherNode = new Node(description.getHostedBy().getName() + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
        controller.boot(lobbyWatcherNode);
        JOptionPane.showMessageDialog(null, "The game you selected has been disconnected from the lobby.");
    }

    private void setWidgetActivation() {
        boolean selected = this.m_gameTable.getSelectedRow() >= 0;
        this.m_joinGame.setEnabled(selected);
    }
}

