/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.lobby.client.login.CreateUpdateAccountPanel;
import games.strategy.engine.lobby.client.ui.LobbyFrame;
import games.strategy.engine.lobby.client.ui.MacLobbyWrapper;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.IUserManager;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.engine.lobby.server.userDB.DBUser;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.net.INode;
import games.strategy.net.Node;
import games.strategy.sound.SoundOptions;
import games.strategy.sound.SoundPath;
import games.strategy.util.MD5Crypt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class LobbyMenu
extends JMenuBar {
    private static final long serialVersionUID = 4980621864542042057L;
    private final LobbyFrame m_frame;

    public LobbyMenu(LobbyFrame frame) {
        this.m_frame = frame;
        if (!GameRunner.isMac()) {
            this.createFileMenu(this);
        } else {
            MacLobbyWrapper.registerMacShutdownHandler(this.m_frame);
        }
        this.createAccountMenu(this);
        if (this.m_frame.getLobbyClient().isAdmin()) {
            this.createAdminMenu(this);
        }
        this.createSettingsMenu(this);
        this.createHelpMenu(this);
    }

    private void createAccountMenu(LobbyMenu menuBar) {
        JMenu account = new JMenu("Account");
        menuBar.add(account);
        this.addUpdateAccountMenu(account);
    }

    private void createAdminMenu(LobbyMenu menuBar) {
        JMenu powerUser = new JMenu("Admin");
        menuBar.add(powerUser);
        this.createDiagnosticsMenu(powerUser);
        this.createToolboxMenu(powerUser);
    }

    private void createDiagnosticsMenu(JMenu menuBar) {
        JMenu diagnostics = new JMenu("Diagnostics");
        menuBar.add(diagnostics);
        this.addDisplayPlayersInformationMenu(diagnostics);
    }

    private void createToolboxMenu(JMenu menuBar) {
        JMenu toolbox = new JMenu("Toolbox");
        menuBar.add(toolbox);
        this.addBanUsernameMenu(toolbox);
        this.addBanIPAddressMenu(toolbox);
        this.addBanMacAddressMenu(toolbox);
        this.addUnbanUsernameMenu(toolbox);
        this.addUnbanIPAddressMenu(toolbox);
        this.addUnbanMacAddressMenu(toolbox);
    }

    private void addDisplayPlayersInformationMenu(JMenu parentMenu) {
        JMenuItem revive = new JMenuItem("Display Players Information");
        revive.setEnabled(true);
        revive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable runner = new Runnable(){

                    public void run() {
                        IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                        final StringBuilder builder = new StringBuilder();
                        builder.append("Online Players:\r\n\r\n");
                        for (INode player : LobbyMenu.this.m_frame.GetChatMessagePanel().getChat().GetOnlinePlayers()) {
                            builder.append(controller.getInformationOn(player)).append("\r\n\r\n");
                        }
                        builder.append("Players That Have Left (Last 10):\r\n\r\n");
                        for (INode player : LobbyMenu.this.m_frame.GetChatMessagePanel().getChat().GetPlayersThatLeft_Last10()) {
                            builder.append(controller.getInformationOn(player)).append("\r\n\r\n");
                        }
                        Runnable componentCreation = new Runnable(){

                            public void run() {
                                final JDialog dialog = new JDialog((Frame)LobbyMenu.this.m_frame, "Players Information");
                                JTextArea label = new JTextArea(builder.toString());
                                label.setFont(new Font("Segoe UI", 0, 12));
                                label.setEditable(false);
                                label.setAutoscrolls(true);
                                label.setLineWrap(false);
                                label.setFocusable(true);
                                label.setWrapStyleWord(true);
                                label.setLocation(0, 0);
                                dialog.setBackground(label.getBackground());
                                dialog.setLayout(new BorderLayout());
                                JScrollPane pane = new JScrollPane();
                                pane.setHorizontalScrollBarPolicy(30);
                                pane.setVerticalScrollBarPolicy(20);
                                pane.setViewportView(label);
                                dialog.add((Component)pane, "Center");
                                JButton button = new JButton(new AbstractAction(){
                                    private static final long serialVersionUID = 823636925655070882L;

                                    public void actionPerformed(ActionEvent e) {
                                        dialog.dispose();
                                    }
                                });
                                button.setText("Close");
                                button.setMinimumSize(new Dimension(100, 30));
                                dialog.add((Component)button, "South");
                                dialog.setMinimumSize(new Dimension(500, 300));
                                dialog.setSize(new Dimension(800, 600));
                                dialog.setResizable(true);
                                dialog.setLocationRelativeTo(LobbyMenu.this.m_frame);
                                dialog.setDefaultCloseOperation(2);
                                dialog.setVisible(true);
                            }
                        };
                        SwingUtilities.invokeLater(componentCreation);
                    }
                };
                Thread thread = new Thread(runner);
                thread.start();
            }
        });
        parentMenu.add(revive);
    }

    private void addBanUsernameMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Ban Username");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(null, "Enter the username that you want to ban from the lobby.\r\n\r\nNote that this ban is effective on any username, registered or anonymous, online or offline.", "");
                if (name == null || name.length() < 1) {
                    return;
                }
                if (DBUserController.validateUserName(name) != null && JOptionPane.showConfirmDialog(LobbyMenu.this.m_frame, "The username you entered is invalid. Do you want to ban it anyhow?", "Invalid Username", 1) != 0) {
                    return;
                }
                long ticks = LobbyMenu.this.requestTimespanSupplication();
                long expire = System.currentTimeMillis() + ticks;
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banUsername(new Node(name, Inet4Address.getByName("0.0.0.0"), 0), new Date(expire));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private void addBanIPAddressMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Ban IP Address");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String ip = JOptionPane.showInputDialog(null, "Enter the IP Address that you want to ban from the lobby.\r\n\r\nIP Addresses should be entered in this format: 192.168.1.0", "");
                if (ip == null || ip.length() < 1) {
                    return;
                }
                long ticks = LobbyMenu.this.requestTimespanSupplication();
                long expire = System.currentTimeMillis() + ticks;
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banIp(new Node("None (Admin menu originated ban)", Inet4Address.getByName(ip), 0), new Date(expire));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private void addBanMacAddressMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Ban Hashed Mac Address");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String mac = JOptionPane.showInputDialog(null, "Enter the hashed Mac Address that you want to ban from the lobby.\r\n\r\nHashed Mac Addresses should be entered in this format: $1$MH$345ntXD4G3AKpAeHZdaGe3", "");
                if (mac == null || mac.length() < 1) {
                    return;
                }
                if (!(mac.length() == 28 && mac.startsWith("$1$MH$") && mac.matches("[0-9a-zA-Z$./]+") || JOptionPane.showConfirmDialog(LobbyMenu.this.m_frame, "The hashed Mac Address you entered is invalid. Do you want to ban it anyhow?", "Invalid Hashed Mac", 1) == 0)) {
                    return;
                }
                long ticks = LobbyMenu.this.requestTimespanSupplication();
                long expire = System.currentTimeMillis() + ticks;
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banIp(new Node("None (Admin menu originated ban)", Inet4Address.getByName("0.0.0.0"), 0), new Date(expire));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private void addUnbanUsernameMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Unban Username");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(null, "Enter the username that you want to unban from the lobby.", "");
                if (name == null || name.length() < 1) {
                    return;
                }
                if (DBUserController.validateUserName(name) != null && JOptionPane.showConfirmDialog(LobbyMenu.this.m_frame, "The username you entered is invalid. Do you want to ban it anyhow?", "Invalid Username", 1) != 0) {
                    return;
                }
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banUsername(new Node(name, Inet4Address.getByName("0.0.0.0"), 0), new Date(0L));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private void addUnbanIPAddressMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Unban IP Address");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String ip = JOptionPane.showInputDialog(null, "Enter the IP Address that you want to unban from the lobby.\r\n\r\nIP Addresses should be entered in this format: 192.168.1.0", "");
                if (ip == null || ip.length() < 1) {
                    return;
                }
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banIp(new Node("None (Admin menu originated unban)", Inet4Address.getByName(ip), 0), new Date(0L));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private void addUnbanMacAddressMenu(JMenu parentMenu) {
        JMenuItem item = new JMenuItem("Unban Hashed Mac Address");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String mac = JOptionPane.showInputDialog(null, "Enter the hashed Mac Address that you want to unban from the lobby.\r\n\r\nHashed Mac Addresses should be entered in this format: $1$MH$345ntXD4G3AKpAeHZdaGe3", "");
                if (mac == null || mac.length() < 1) {
                    return;
                }
                if (!(mac.length() == 28 && mac.startsWith("$1$MH$") && mac.matches("[0-9a-zA-Z$./]+") || JOptionPane.showConfirmDialog(LobbyMenu.this.m_frame, "The hashed Mac Address you entered is invalid. Do you want to ban it anyhow?", "Invalid Hashed Mac", 1) == 0)) {
                    return;
                }
                IModeratorController controller = (IModeratorController)LobbyMenu.this.m_frame.getLobbyClient().getMessengers().getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
                try {
                    controller.banIp(new Node("None (Admin menu originated unban)", Inet4Address.getByName("0.0.0.0"), 0), new Date(0L));
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
        });
        item.setEnabled(true);
        parentMenu.add(item);
    }

    private long requestTimespanSupplication() {
        ArrayList<String> timeUnits = new ArrayList<String>();
        timeUnits.add("Minute");
        timeUnits.add("Hour");
        timeUnits.add("Day");
        timeUnits.add("Week");
        timeUnits.add("Month");
        timeUnits.add("Year");
        timeUnits.add("Forever");
        int result = JOptionPane.showOptionDialog(this.m_frame, "Select the unit of measurement: ", "Select Timespan Unit", 2, 3, null, timeUnits.toArray(), timeUnits.toArray()[3]);
        if (result < 0) {
            return -1L;
        }
        String selectedTimeUnit = (String)timeUnits.toArray()[result];
        if (selectedTimeUnit.equals("Forever")) {
            return Long.MAX_VALUE;
        }
        String stringr = JOptionPane.showInputDialog(this.m_frame, "Now please enter the length of time: (In " + selectedTimeUnit + "s) ", 1);
        if (stringr == null) {
            return -1L;
        }
        long result2 = Long.parseLong(stringr);
        if (result2 < 0L) {
            return -1L;
        }
        long ticks = 0L;
        if (selectedTimeUnit.equals("Minute")) {
            ticks = result2 * 1000L * 60L;
        } else if (selectedTimeUnit.equals("Hour")) {
            ticks = result2 * 1000L * 60L * 60L;
        } else if (selectedTimeUnit.equals("Day")) {
            ticks = result2 * 1000L * 60L * 60L * 24L;
        } else if (selectedTimeUnit.equals("Week")) {
            ticks = result2 * 1000L * 60L * 60L * 24L * 7L;
        } else if (selectedTimeUnit.equals("Month")) {
            ticks = result2 * 1000L * 60L * 60L * 24L * 30L;
        } else if (selectedTimeUnit.equals("Year")) {
            ticks = result2 * 1000L * 60L * 60L * 24L * 365L;
        }
        return ticks;
    }

    private void createSettingsMenu(LobbyMenu menuBar) {
        JMenu settings = new JMenu("Settings");
        menuBar.add(settings);
        SoundOptions.addGlobalSoundSwitchMenu(settings);
        SoundOptions.addToMenu(settings, SoundPath.SoundType.TRIPLEA);
        this.addChatTimeMenu(settings);
    }

    private void createHelpMenu(LobbyMenu menuBar) {
        JMenu help = new JMenu("Help");
        menuBar.add(help);
        this.addHelpMenu(help);
    }

    private void addHelpMenu(JMenu parentMenu) {
        JMenuItem hostingLink = new JMenuItem("How to Host...");
        JMenuItem mapLink = new JMenuItem("Install Maps...");
        JMenuItem bugReport = new JMenuItem("Bug Report...");
        JMenuItem lobbyRules = new JMenuItem("Lobby Rules...");
        JMenuItem warClub = new JMenuItem("War Club & Ladder...");
        JMenuItem devForum = new JMenuItem("Developer Forum...");
        JMenuItem donateLink = new JMenuItem("Donate...");
        JMenuItem guidesLink = new JMenuItem("Guides...");
        hostingLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4085700.html");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        mapLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4074312.html");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        bugReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/tracker/?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        lobbyRules.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://www.tripleawarclub.org/modules/newbb/viewtopic.php?topic_id=100&forum=1");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        warClub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://www.tripleawarclub.org/");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        devForum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Forum");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        donateLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        guidesLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Guides");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        parentMenu.add(hostingLink);
        parentMenu.add(mapLink);
        parentMenu.add(bugReport);
        parentMenu.add(lobbyRules);
        parentMenu.add(warClub);
        parentMenu.add(devForum);
        parentMenu.add(donateLink);
        parentMenu.add(guidesLink);
    }

    private void addChatTimeMenu(JMenu parentMenu) {
        final JCheckBoxMenuItem chatTimeBox = new JCheckBoxMenuItem("Show Chat Times");
        chatTimeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyMenu.this.m_frame.setShowChatTime(chatTimeBox.isSelected());
            }
        });
        chatTimeBox.setSelected(true);
        parentMenu.add(chatTimeBox);
    }

    private void addUpdateAccountMenu(JMenu account) {
        JMenuItem update = new JMenuItem("Update Account...");
        update.setEnabled(!this.m_frame.getLobbyClient().isAnonymousLogin());
        update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyMenu.this.updateAccountDetails();
            }
        });
        account.add(update);
    }

    private void updateAccountDetails() {
        IUserManager manager = (IUserManager)this.m_frame.getLobbyClient().getRemoteMessenger().getRemote(IUserManager.USER_MANAGER);
        DBUser user = manager.getUserInfo(this.m_frame.getLobbyClient().getMessenger().getLocalNode().getName());
        if (user == null) {
            JOptionPane.showMessageDialog(this, "No user info found", "Error", 0);
            return;
        }
        CreateUpdateAccountPanel panel = CreateUpdateAccountPanel.newUpdatePanel(user);
        CreateUpdateAccountPanel.ReturnValue rVal = panel.show(this.m_frame);
        if (rVal == CreateUpdateAccountPanel.ReturnValue.CANCEL) {
            return;
        }
        String error = manager.updateUser(panel.getUserName(), panel.getEmail(), MD5Crypt.crypt(panel.getPassword()));
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
        }
    }

    private void createFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.addExitMenu(fileMenu);
    }

    private void addExitMenu(JMenu parentMenu) {
        boolean isMac = GameRunner.isMac();
        if (!isMac) {
            JMenuItem menuFileExit = new JMenuItem(new AbstractAction("Exit"){
                private static final long serialVersionUID = 7173511775817785866L;

                public void actionPerformed(ActionEvent e) {
                    LobbyMenu.this.m_frame.shutdown();
                }
            });
            parentMenu.add(menuFileExit);
        }
    }
}

