/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import games.strategy.util.Tuple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BannedUsernameController {
    private static final Logger s_logger = Logger.getLogger(BannedUsernameController.class.getName());

    public void addBannedUsername(String username) {
        this.addBannedUsername(username, null);
    }

    public void addBannedUsername(String username, Date banTill) {
        if (this.isUsernameBanned(username).getFirst().booleanValue()) {
            this.removeBannedUsername(username);
        }
        Timestamp banTillTs = null;
        if (banTill != null) {
            banTillTs = new Timestamp(banTill.getTime());
        }
        s_logger.fine("Banning username:" + username);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into banned_usernames (username, ban_till) values (?, ?)");
            ps.setString(1, username);
            ps.setTimestamp(2, banTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate banned username:" + username + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting banned username:" + username, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeBannedUsername(String username) {
        s_logger.fine("Removing banned username:" + username);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from banned_usernames where username = ?");
            ps.setString(1, username);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting banned username:" + username, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public Tuple<Boolean, Timestamp> isUsernameBanned(String username) {
        boolean found = false;
        boolean expired = false;
        Timestamp banTill = null;
        String sql = "select username, ban_till from banned_usernames where username = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select username, ban_till from banned_usernames where username = ?");
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            found = rs.next();
            if (found && (banTill = rs.getTimestamp(2)) != null && banTill.getTime() < System.currentTimeMillis()) {
                s_logger.fine("Ban expired for:" + username);
                expired = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing banned username existence:" + username + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeBannedUsername(username);
            return new Tuple<Boolean, Timestamp>(false, banTill);
        }
        return new Tuple<Boolean, Timestamp>(found, banTill);
    }
}

