/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.framework.GameRunner2;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Database {
    private static final Logger s_logger = Logger.getLogger(Database.class.getName());
    private static final Object s_dbSetupLock = new Object();
    private static boolean s_isDbSetup = false;
    private static boolean s_areDBTablesCreated = false;

    private static File getCurrentDataBaseDir() {
        File dbRootDir = Database.getDBRoot();
        File dbDir = new File(dbRootDir, "current");
        if (!dbDir.exists() && !dbDir.mkdirs()) {
            throw new IllegalStateException("Could not create derby dir");
        }
        return dbDir;
    }

    private static File getDBRoot() {
        File root = System.getProperties().containsKey("triplea.server.root.dir") ? new File(System.getProperties().getProperty("triplea.server.root.dir")) : GameRunner2.getRootFolder();
        if (!root.exists()) {
            throw new IllegalStateException("Root dir does not exist");
        }
        File dbRootDir = new File(root, "derby_db");
        return dbRootDir;
    }

    public static Connection getConnection() {
        Database.ensureDbIsSetup();
        Connection conn = null;
        Properties props = Database.getDbProps();
        String url = "jdbc:derby:ta_users;create=true";
        try {
            conn = DriverManager.getConnection("jdbc:derby:ta_users;create=true", props);
        }
        catch (SQLException e) {
            s_logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalStateException("Could not create db connection");
        }
        Database.ensureDbTablesAreCreated(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureDbTablesAreCreated(Connection conn) {
        Object object = s_dbSetupLock;
        synchronized (object) {
            try {
                Statement s;
                if (s_areDBTablesCreated) {
                    return;
                }
                ResultSet rs = conn.getMetaData().getTables(null, null, null, null);
                ArrayList<String> existing = new ArrayList<String>();
                while (rs.next()) {
                    existing.add(rs.getString("TABLE_NAME").toUpperCase());
                }
                rs.close();
                if (!existing.contains("TA_USERS")) {
                    s = conn.createStatement();
                    s.execute("create table ta_users(userName varchar(40) NOT NULL PRIMARY KEY, password varchar(40) NOT NULL, email varchar(40) NOT NULL, joined timestamp NOT NULL, lastLogin timestamp NOT NULL, admin integer NOT NULL )");
                    s.close();
                }
                if (!existing.contains("BANNED_USERNAMES")) {
                    s = conn.createStatement();
                    s.execute("create table banned_usernames(username varchar(40) NOT NULL PRIMARY KEY, ban_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("BANNED_IPS")) {
                    s = conn.createStatement();
                    s.execute("create table banned_ips(ip varchar(40) NOT NULL PRIMARY KEY, ban_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("BANNED_MACS")) {
                    s = conn.createStatement();
                    s.execute("create table banned_macs(mac varchar(40) NOT NULL PRIMARY KEY, ban_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("MUTED_USERNAMES")) {
                    s = conn.createStatement();
                    s.execute("create table muted_usernames(username varchar(40) NOT NULL PRIMARY KEY, mute_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("MUTED_IPS")) {
                    s = conn.createStatement();
                    s.execute("create table muted_ips(ip varchar(40) NOT NULL PRIMARY KEY, mute_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("MUTED_MACS")) {
                    s = conn.createStatement();
                    s.execute("create table muted_macs(mac varchar(40) NOT NULL PRIMARY KEY, mute_till timestamp  )");
                    s.close();
                }
                if (!existing.contains("BAD_WORDS")) {
                    s = conn.createStatement();
                    s.execute("create table bad_words(word varchar(40) NOT NULL PRIMARY KEY )");
                    s.close();
                }
                s_areDBTablesCreated = true;
            }
            catch (SQLException sqle) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                s_logger.log(Level.SEVERE, sqle.getMessage(), sqle);
                throw new IllegalStateException("Could not create tables");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureDbIsSetup() {
        Object object = s_dbSetupLock;
        synchronized (object) {
            if (s_isDbSetup) {
                return;
            }
            System.getProperties().setProperty("derby.system.home", Database.getCurrentDataBaseDir().getAbsolutePath());
            try {
                String driver = "org.apache.derby.jdbc.EmbeddedDriver";
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, e.getMessage(), e);
                throw new Error("Could not load db driver");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    Database.shutDownDB();
                }
            }));
            s_isDbSetup = true;
        }
        Thread backupThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(604800000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Database.backup();
                }
            }
        }, "TripleA Database Backup Thread");
        backupThread.setDaemon(true);
        backupThread.start();
    }

    public static void restoreFromBackup(File backupDir) throws SQLException {
        String url = "jdbc:derby:ta_users;restoreFrom=" + backupDir.getAbsolutePath();
        Properties props = Database.getDbProps();
        Connection con = DriverManager.getConnection(url, props);
        con.close();
    }

    private static Properties getDbProps() {
        Properties props = new Properties();
        props.put("user", "user1");
        props.put("password", "user1");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup() {
        String backupDirName = "backup_at_" + new SimpleDateFormat("yyyy_MM_dd__kk_mm_ss").format(new Date());
        File backupRootDir = Database.getBackupDir();
        File backupDir = new File(backupRootDir, backupDirName);
        if (!backupDir.mkdirs()) {
            s_logger.severe("Could not create backup dir" + backupDirName);
            return;
        }
        s_logger.log(Level.INFO, "Backing up database to " + backupDir.getAbsolutePath());
        Connection con = Database.getConnection();
        try {
            String sqlstmt = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)";
            CallableStatement cs = con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            cs.setString(1, backupDir.getAbsolutePath());
            cs.execute();
            cs.close();
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "Could not back up database", e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        s_logger.log(Level.INFO, "Done backing up database");
    }

    public static File getBackupDir() {
        return new File(Database.getDBRoot(), "backups");
    }

    private static void shutDownDB() {
        block2: {
            try {
                DriverManager.getConnection("jdbc:derby:ta_users;shutdown=true");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 45000) break block2;
                s_logger.log(Level.WARNING, se.getMessage(), se);
            }
        }
        s_logger.info("Databse shut down");
    }

    public static void main(String[] args) {
        Database.ensureDbIsSetup();
        JFileChooser chooser = new JFileChooser(Database.getBackupDir());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        int rVal = chooser.showOpenDialog(null);
        if (rVal == 0) {
            File f = chooser.getSelectedFile();
            if (!f.exists() && f.isDirectory()) {
                throw new IllegalStateException("Does not exist, or not a directory");
            }
            try {
                Database.restoreFromBackup(chooser.getSelectedFile());
            }
            catch (SQLException sqle) {
                JOptionPane.showMessageDialog(null, sqle.getMessage());
                sqle.printStackTrace();
            }
        }
    }
}

