/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutedMacController {
    private static final Logger s_logger = Logger.getLogger(MutedMacController.class.getName());

    public void addMutedMac(String mac) {
        this.addMutedMac(mac, null);
    }

    public void addMutedMac(String mac, Date muteTill) {
        if (this.isMacMuted(mac)) {
            this.removeMutedMac(mac);
        }
        Timestamp muteTillTs = null;
        if (muteTill != null) {
            muteTillTs = new Timestamp(muteTill.getTime());
        }
        s_logger.fine("Muting mac:" + mac);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into muted_macs (mac, mute_till) values (?, ?)");
            ps.setString(1, mac);
            ps.setTimestamp(2, muteTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate muted mac:" + mac + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting muted mac:" + mac, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeMutedMac(String mac) {
        s_logger.fine("Removing muted mac:" + mac);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from muted_macs where mac = ?");
            ps.setString(1, mac);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting muted mac:" + mac, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public boolean isMacMuted(String mac) {
        long muteTill = this.getMacUnmuteTime(mac);
        return muteTill > System.currentTimeMillis();
    }

    public long getMacUnmuteTime(String mac) {
        long result = -1L;
        boolean expired = false;
        String sql = "select mac, mute_till from muted_macs where mac = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select mac, mute_till from muted_macs where mac = ?");
            ps.setString(1, mac);
            ResultSet rs = ps.executeQuery();
            boolean found = rs.next();
            if (found) {
                Timestamp muteTill = rs.getTimestamp(2);
                result = muteTill.getTime();
                if (result < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for:" + mac);
                    expired = true;
                }
            } else {
                result = -1L;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing muted mac existence:" + mac + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeMutedMac(mac);
            result = -1L;
        }
        return result;
    }

    public List<String> getMacsThatAreStillMuted(List<String> macs) {
        ArrayList<String> results = new ArrayList<String>();
        String sql = "select mac, mute_till from muted_macs where mac = ?";
        Connection con = Database.getConnection();
        try {
            for (String mac : macs) {
                Timestamp muteTill;
                boolean found = false;
                boolean expired = false;
                PreparedStatement ps = con.prepareStatement("select mac, mute_till from muted_macs where mac = ?");
                ps.setString(1, mac);
                ResultSet rs = ps.executeQuery();
                found = rs.next();
                if (found && (muteTill = rs.getTimestamp(2)) != null && muteTill.getTime() < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for: " + mac);
                    expired = true;
                }
                rs.close();
                ps.close();
                if (!found || expired) continue;
                results.add(mac);
            }
        }
        catch (SQLException sqle) {
            s_logger.info("Error testing whether macs were muted: " + macs);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        return results;
    }
}

