/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutedUsernameController {
    private static final Logger s_logger = Logger.getLogger(MutedUsernameController.class.getName());

    public void addMutedUsername(String username) {
        this.addMutedUsername(username, null);
    }

    public void addMutedUsername(String username, Date muteTill) {
        if (this.isUsernameMuted(username)) {
            this.removeMutedUsername(username);
        }
        Timestamp muteTillTs = null;
        if (muteTill != null) {
            muteTillTs = new Timestamp(muteTill.getTime());
        }
        s_logger.fine("Muting username:" + username);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into muted_usernames (username, mute_till) values (?, ?)");
            ps.setString(1, username);
            ps.setTimestamp(2, muteTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate muted username:" + username + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting muted username:" + username, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeMutedUsername(String username) {
        s_logger.fine("Removing muted username:" + username);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from muted_usernames where username = ?");
            ps.setString(1, username);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting muted username:" + username, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public boolean isUsernameMuted(String username) {
        long muteTill = this.getUsernameUnmuteTime(username);
        return muteTill > System.currentTimeMillis();
    }

    public long getUsernameUnmuteTime(String username) {
        long result = -1L;
        boolean expired = false;
        String sql = "select username, mute_till from muted_usernames where username = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select username, mute_till from muted_usernames where username = ?");
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            boolean found = rs.next();
            if (found) {
                Timestamp muteTill = rs.getTimestamp(2);
                result = muteTill.getTime();
                if (result < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for:" + username);
                    expired = true;
                }
            } else {
                result = -1L;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing muted username existence:" + username + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeMutedUsername(username);
            result = -1L;
        }
        return result;
    }

    public List<String> getUsernamesThatAreStillMuted(List<String> usernames) {
        ArrayList<String> results = new ArrayList<String>();
        String sql = "select username, mute_till from muted_usernames where username = ?";
        Connection con = Database.getConnection();
        try {
            for (String username : usernames) {
                Timestamp muteTill;
                boolean found = false;
                boolean expired = false;
                PreparedStatement ps = con.prepareStatement("select username, mute_till from muted_usernames where username = ?");
                ps.setString(1, username);
                ResultSet rs = ps.executeQuery();
                found = rs.next();
                if (found && (muteTill = rs.getTimestamp(2)) != null && muteTill.getTime() < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for: " + username);
                    expired = true;
                }
                rs.close();
                ps.close();
                if (!found || expired) continue;
                results.add(username);
            }
        }
        catch (SQLException sqle) {
            s_logger.info("Error testing whether usernames were muted: " + usernames);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        return results;
    }
}

