/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.ILoginValidator;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Node;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyMessenger
implements IServerMessenger {
    private final CopyOnWriteArrayList<IConnectionChangeListener> m_connectionChangeListeners = new CopyOnWriteArrayList();
    private final INode m_node;

    public DummyMessenger() {
        try {
            this.m_node = new Node("dummy", InetAddress.getLocalHost(), 0);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public void send(Serializable msg, INode to) {
    }

    @Override
    public void broadcast(Serializable msg) {
    }

    @Override
    public void addMessageListener(IMessageListener listener) {
    }

    @Override
    public void removeMessageListener(IMessageListener listener) {
    }

    @Override
    public void addErrorListener(IMessengerErrorListener listener) {
    }

    @Override
    public void removeErrorListener(IMessengerErrorListener listener) {
    }

    @Override
    public INode getLocalNode() {
        return this.m_node;
    }

    @Override
    public Set<INode> getNodes() {
        return new HashSet<INode>();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void addConnectionChangeListener(IConnectionChangeListener listener) {
        this.m_connectionChangeListeners.add(listener);
    }

    @Override
    public void removeConnectionChangeListener(IConnectionChangeListener listener) {
        this.m_connectionChangeListeners.remove(listener);
    }

    public void flush() {
    }

    @Override
    public void setAcceptNewConnections(boolean accept) {
    }

    public void waitForAllMessagsToBeProcessed() {
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public boolean isAcceptNewConnections() {
        return false;
    }

    @Override
    public void removeConnection(INode node) {
        for (IConnectionChangeListener listener : this.m_connectionChangeListeners) {
            listener.connectionRemoved(node);
        }
    }

    @Override
    public INode getServerNode() {
        return this.m_node;
    }

    @Override
    public void setLoginValidator(ILoginValidator loginValidator) {
    }

    @Override
    public ILoginValidator getLoginValidator() {
        return null;
    }

    @Override
    public InetSocketAddress getRemoteServerSocketAddress() {
        return this.m_node.getSocketAddress();
    }

    @Override
    public void NotifyIPMiniBanningOfPlayer(String ip) {
    }

    @Override
    public void NotifyMacMiniBanningOfPlayer(String mac) {
    }

    @Override
    public void NotifyUsernameMiniBanningOfPlayer(String username) {
    }

    @Override
    public String GetPlayerMac(String name) {
        return "DummyMacAddress";
    }

    @Override
    public void NotifyUsernameMutingOfPlayer(String username, Date muteExpires) {
    }

    @Override
    public void NotifyIPMutingOfPlayer(String ip, Date muteExpires) {
    }

    @Override
    public void NotifyMacMutingOfPlayer(String mac, Date muteExpires) {
    }

    @Override
    public boolean IsUsernameMiniBanned(String username) {
        return false;
    }

    @Override
    public boolean IsIpMiniBanned(String ip) {
        return false;
    }

    @Override
    public boolean IsMacMiniBanned(String mac) {
        return false;
    }

    public boolean isShutDown() {
        return false;
    }
}

