/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.net.GUID;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

abstract class Invoke
implements Externalizable {
    private static final long serialVersionUID = -5453883962199970896L;
    public GUID methodCallID;
    public boolean needReturnValues;
    public RemoteMethodCall call;

    public Invoke() {
    }

    public String toString() {
        return "invoke on:" + this.call.getRemoteName() + " method name:" + this.call.getMethodName() + " method call id:" + this.methodCallID;
    }

    public Invoke(GUID methodCallID, boolean needReturnValues, RemoteMethodCall call) {
        if (needReturnValues && methodCallID == null) {
            throw new IllegalArgumentException("Cant have no id and need return values");
        }
        if (!needReturnValues && methodCallID != null) {
            throw new IllegalArgumentException("Cant have id and not need return values");
        }
        this.methodCallID = methodCallID;
        this.needReturnValues = needReturnValues;
        this.call = call;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean bl = this.needReturnValues = in.read() == 1;
        if (this.needReturnValues) {
            this.methodCallID = (GUID)in.readObject();
        }
        this.call = new RemoteMethodCall();
        this.call.readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.needReturnValues ? 1 : 0);
        if (this.needReturnValues) {
            out.writeObject(this.methodCallID);
        }
        this.call.writeExternal(out);
    }
}

