/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.pbem;

import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import games.strategy.triplea.ui.history.HistoryLog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ForumPosterComponent
extends JPanel {
    private static final long serialVersionUID = 4754052934098190357L;
    protected GameData m_data;
    protected IPlayerBridge m_bridge;
    protected PBEMMessagePoster m_poster;
    protected MainGameFrame m_frame;
    protected HistoryLog m_historyLog;
    protected JButton m_postButton;
    protected JCheckBox m_includeTerritoryCheckbox;
    protected JCheckBox m_includeTerritoryAllPlayersCheckbox;
    protected JCheckBox m_includeProductionCheckbox;
    protected JCheckBox m_showDetailsCheckbox;
    protected JCheckBox m_showDiceStatisticsCheckbox;
    protected JCheckBox m_includeSavegameCheckBox;
    protected JCheckBox m_repostTurnSummaryCheckBox;
    protected Action m_viewAction;
    protected Action m_postAction;
    protected Action m_repostAction;
    protected Action m_includeTerritoryAction;
    protected Action m_includeTerritoryAllPlayersAction;
    protected Action m_includeProductionAction;
    protected Action m_showDetailsAction;
    protected Action m_showDiceStatisticsAction;
    protected Action m_doneAction;
    protected String m_title;
    protected IAbstractForumPosterDelegate m_forumPosterDelegate;

    public ForumPosterComponent(GameData data, Action doneAction, String title) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 0));
        this.m_data = data;
        this.m_title = title;
        this.m_viewAction = new AbstractAction("View " + this.m_title){
            private static final long serialVersionUID = -2619980789206699839L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.m_historyLog.setVisible(true);
            }
        };
        this.m_postAction = new AbstractAction("Post " + this.m_title){
            private static final long serialVersionUID = 8317441736305744524L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.m_postButton.setEnabled(false);
                ForumPosterComponent.this.updateHistoryLog();
                PBEMMessagePoster.postTurn(ForumPosterComponent.this.m_title, ForumPosterComponent.this.m_historyLog, ForumPosterComponent.this.m_includeSavegameCheckBox.isSelected(), ForumPosterComponent.this.m_poster, ForumPosterComponent.this.m_forumPosterDelegate, ForumPosterComponent.this.m_frame, ForumPosterComponent.this.m_postButton);
                ForumPosterComponent.this.m_repostTurnSummaryCheckBox.setSelected(false);
            }
        };
        this.m_includeTerritoryAction = new AbstractAction("Include territory summary"){
            private static final long serialVersionUID = 207279881318712095L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.updateHistoryLog();
            }
        };
        this.m_includeTerritoryAllPlayersAction = new AbstractAction("Include full territory summary"){
            private static final long serialVersionUID = 207279881318712095L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.updateHistoryLog();
            }
        };
        this.m_includeProductionAction = new AbstractAction("Include production summary"){
            private static final long serialVersionUID = 2298448099326090293L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.updateHistoryLog();
            }
        };
        this.m_showDetailsAction = new AbstractAction("Show dice/battle details"){
            private static final long serialVersionUID = -4248518090232071926L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.updateHistoryLog();
            }
        };
        this.m_showDiceStatisticsAction = new AbstractAction("Include overall dice statistics"){
            private static final long serialVersionUID = 1431745626173286692L;

            public void actionPerformed(ActionEvent event) {
                ForumPosterComponent.this.updateHistoryLog();
            }
        };
        this.m_repostAction = new AbstractAction("Repost " + this.m_title){
            private static final long serialVersionUID = -67455254243579500L;

            public void actionPerformed(ActionEvent event) {
                if (ForumPosterComponent.this.m_repostTurnSummaryCheckBox.isSelected()) {
                    ForumPosterComponent.this.m_postButton.setEnabled(true);
                } else if (ForumPosterComponent.this.m_forumPosterDelegate != null) {
                    ForumPosterComponent.this.m_postButton.setEnabled(!ForumPosterComponent.this.m_forumPosterDelegate.getHasPostedTurnSummary());
                }
            }
        };
        this.m_doneAction = doneAction;
        this.m_includeTerritoryCheckbox = new JCheckBox(this.m_includeTerritoryAction);
        this.m_includeTerritoryAllPlayersCheckbox = new JCheckBox(this.m_includeTerritoryAllPlayersAction);
        this.m_includeProductionCheckbox = new JCheckBox(this.m_includeProductionAction);
        this.m_showDetailsCheckbox = new JCheckBox(this.m_showDetailsAction);
        this.m_showDiceStatisticsCheckbox = new JCheckBox(this.m_showDiceStatisticsAction);
        this.m_includeSavegameCheckBox = new JCheckBox("Include SaveGame");
        this.m_repostTurnSummaryCheckBox = new JCheckBox(this.m_repostAction);
    }

    public ForumPosterComponent layoutComponents(PBEMMessagePoster poster, IAbstractForumPosterDelegate forumPosterDelegate, IPlayerBridge bridge, MainGameFrame frame, boolean hasPosted, boolean allowIncludeTerritorySummary, boolean allowIncludeTerritoryAllPlayersSummary, boolean allowIncludeProductionSummary, boolean allowDiceBattleDetails, boolean allowDiceStatistics) {
        this.m_forumPosterDelegate = forumPosterDelegate;
        this.m_frame = frame;
        this.m_bridge = bridge;
        this.m_poster = poster;
        this.m_historyLog = new HistoryLog();
        this.updateHistoryLog();
        this.removeAll();
        if (allowIncludeTerritorySummary) {
            this.add(this.m_includeTerritoryCheckbox);
        }
        if (allowIncludeTerritoryAllPlayersSummary) {
            this.add(this.m_includeTerritoryAllPlayersCheckbox);
        }
        if (allowIncludeProductionSummary) {
            this.add(this.m_includeProductionCheckbox);
        }
        if (allowDiceBattleDetails) {
            this.add(this.m_showDetailsCheckbox);
        }
        if (allowDiceStatistics) {
            this.add(this.m_showDiceStatisticsCheckbox);
        }
        this.m_includeSavegameCheckBox.setSelected(this.m_poster.getEmailSender() != null || this.m_poster.getForumPoster() != null && this.m_poster.getForumPoster().getIncludeSaveGame());
        this.add(this.m_includeSavegameCheckBox);
        this.m_repostTurnSummaryCheckBox.setSelected(!hasPosted);
        this.add(this.m_repostTurnSummaryCheckBox);
        this.add(new JButton(this.m_viewAction));
        this.m_postButton = new JButton(this.m_postAction);
        this.m_postButton.setEnabled(!hasPosted);
        this.add(this.m_postButton);
        this.add(new JButton(this.m_doneAction));
        this.validate();
        return this;
    }

    private void updateHistoryLog() {
        HashSet<PlayerID> allowedIDs;
        String allowedPlayers = this.m_bridge.getStepProperties().getProperty("turnSummaryPlayers");
        if (allowedPlayers != null) {
            allowedIDs = new HashSet<PlayerID>();
            for (String p : allowedPlayers.split(":")) {
                PlayerID id = this.m_data.getPlayerList().getPlayerID(p);
                if (id == null) {
                    System.err.println("gamePlay sequence step: " + this.m_bridge.getStepName() + " stepProperty: " + "turnSummaryPlayers" + " player: " + p + " DOES NOT EXIST");
                    continue;
                }
                allowedIDs.add(id);
            }
        } else {
            allowedIDs = null;
        }
        this.m_historyLog.clear();
        this.m_historyLog.printFullTurn(this.m_data, this.m_showDetailsCheckbox.isSelected(), allowedIDs);
        if (this.m_includeTerritoryAllPlayersCheckbox.isSelected()) {
            for (PlayerID player : this.m_data.getPlayerList().getPlayers()) {
                ArrayList<PlayerID> players = new ArrayList<PlayerID>();
                players.add(player);
                this.m_historyLog.printTerritorySummary(this.m_data, players);
            }
        } else if (this.m_includeTerritoryCheckbox.isSelected()) {
            this.m_historyLog.printTerritorySummary(this.m_data, allowedIDs);
        }
        if (this.m_includeProductionCheckbox.isSelected()) {
            this.m_historyLog.printProductionSummary(this.m_data);
        }
        if (this.m_showDiceStatisticsCheckbox.isSelected()) {
            this.m_historyLog.printDiceStatistics(this.m_data, (IRandomStats)this.m_frame.getGame().getRemoteMessenger().getRemote(IRandomStats.RANDOM_STATS_REMOTE_NAME));
        }
        this.m_historyLog.requestFocus();
    }
}

