/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.pbem;

import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.IWebPoster;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.ui.ProgressWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PBEMMessagePoster
implements Serializable {
    public static final String FORUM_POSTER_PROP_NAME = "games.strategy.engine.pbem.IForumPoster";
    public static final String EMAIL_SENDER_PROP_NAME = "games.strategy.engine.pbem.IEmailSender";
    public static final String WEB_POSTER_PROP_NAME = "games.strategy.engine.pbem.IWebPoster";
    private static final long serialVersionUID = 2256265436928530566L;
    private final IForumPoster m_forumPoster;
    private final IEmailSender m_emailSender;
    private final IWebPoster m_webSitePoster;
    private transient File m_saveGameFile = null;
    private transient String m_turnSummary = null;
    private transient String m_saveGameRef = null;
    private transient String m_turnSummaryRef = null;
    private transient String m_emailSendStatus;
    private transient String m_webPostStatus;
    private transient PlayerID m_currentPlayer;
    private final transient GameData m_gameData;
    private transient int m_roundNumber;
    private transient String m_gameNameAndInfo;

    public PBEMMessagePoster(GameData gameData, PlayerID currentPlayer, int roundNumber, String title) {
        this.m_gameData = gameData;
        this.m_currentPlayer = currentPlayer;
        this.m_roundNumber = roundNumber;
        this.m_forumPoster = (IForumPoster)gameData.getProperties().get(FORUM_POSTER_PROP_NAME);
        this.m_emailSender = (IEmailSender)gameData.getProperties().get(EMAIL_SENDER_PROP_NAME);
        this.m_webSitePoster = (IWebPoster)gameData.getProperties().get(WEB_POSTER_PROP_NAME);
        this.m_gameNameAndInfo = "TripleA " + title + " for game: " + gameData.getGameName() + ", version: " + gameData.getGameVersion();
    }

    public boolean hasMessengers() {
        return this.m_forumPoster != null || this.m_emailSender != null || this.m_webSitePoster != null;
    }

    public static boolean GameDataHasPlayByEmailOrForumMessengers(GameData gameData) {
        IForumPoster forumPoster = (IForumPoster)gameData.getProperties().get(FORUM_POSTER_PROP_NAME);
        IEmailSender emailSender = (IEmailSender)gameData.getProperties().get(EMAIL_SENDER_PROP_NAME);
        IWebPoster webPoster = (IWebPoster)gameData.getProperties().get(WEB_POSTER_PROP_NAME);
        return forumPoster != null || emailSender != null || webPoster != null;
    }

    public IForumPoster getForumPoster() {
        return this.m_forumPoster;
    }

    public IWebPoster getWebPoster() {
        return this.m_webSitePoster;
    }

    public void setTurnSummary(String turnSummary) {
        this.m_turnSummary = turnSummary;
    }

    public void setSaveGame(File saveGameFile) throws FileNotFoundException {
        this.m_saveGameFile = saveGameFile;
    }

    public String getTurnSummaryRef() {
        return this.m_turnSummaryRef;
    }

    public String getSaveGameRef() {
        return this.m_saveGameRef;
    }

    public boolean post(IDelegateHistoryWriter historyWriter, String title, boolean includeSaveGame) {
        boolean forumSuccess = true;
        StringBuilder saveGameSb = new StringBuilder().append("triplea_");
        if (this.m_forumPoster != null) {
            saveGameSb.append(this.m_forumPoster.getTopicId()).append("_");
        }
        saveGameSb.append(this.m_currentPlayer.getName().substring(0, Math.min(3, this.m_currentPlayer.getName().length() - 1))).append(this.m_roundNumber).append(".tsvg");
        String saveGameName = saveGameSb.toString();
        if (this.m_forumPoster != null) {
            if (includeSaveGame) {
                this.m_forumPoster.addSaveGame(this.m_saveGameFile, saveGameName);
            }
            try {
                forumSuccess = this.m_forumPoster.postTurnSummary(this.m_gameNameAndInfo + "\n\n" + this.m_turnSummary, "TripleA " + title + ": " + this.m_currentPlayer.getName() + " round " + this.m_roundNumber);
                this.m_turnSummaryRef = this.m_forumPoster.getTurnSummaryRef();
                if (this.m_turnSummaryRef != null && historyWriter != null) {
                    historyWriter.startEvent("Turn Summary: " + this.m_turnSummaryRef);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean emailSuccess = true;
        if (this.m_emailSender != null) {
            StringBuilder subjectPostFix = new StringBuilder(this.m_currentPlayer.getName());
            subjectPostFix.append(" - ").append("round ").append(this.m_roundNumber);
            try {
                this.m_emailSender.sendEmail(subjectPostFix.toString(), this.convertToHtml(this.m_gameNameAndInfo + "\n\n" + this.m_turnSummary), this.m_saveGameFile, saveGameName);
                this.m_emailSendStatus = "Success, sent to " + this.m_emailSender.getToAddress();
            }
            catch (IOException e) {
                emailSuccess = false;
                this.m_emailSendStatus = "Failed! Error " + e.getMessage();
                e.printStackTrace();
            }
        }
        boolean webSiteSuccess = true;
        if (this.m_webSitePoster != null) {
            this.m_webSitePoster.addSaveGame(this.m_saveGameFile, saveGameName);
            try {
                webSiteSuccess = this.m_webSitePoster.postTurnSummary(this.m_gameData, this.m_turnSummary, this.m_currentPlayer.getName(), this.m_roundNumber);
                this.m_webPostStatus = webSiteSuccess ? "Success! Sent State of Game " + this.m_webSitePoster.getGameName() + " to " + this.m_webSitePoster.getHost() + "\n" + this.m_webSitePoster.getServerMessage() : "Failed! " + this.m_webSitePoster.getServerMessage();
            }
            catch (Exception e) {
                webSiteSuccess = false;
                this.m_webPostStatus = "Failed! Error: " + e.getMessage();
                e.printStackTrace();
            }
        }
        if (historyWriter != null) {
            StringBuilder sb = new StringBuilder("Post Turn Summary");
            if (this.m_forumPoster != null) {
                sb.append(" to ").append(this.m_forumPoster.getDisplayName()).append(" success = ").append(String.valueOf(forumSuccess));
            }
            if (this.m_emailSender != null) {
                if (this.m_forumPoster != null) {
                    sb.append(" and to ");
                } else {
                    sb.append(" to ");
                }
                sb.append(this.m_emailSender.getToAddress()).append(" success = ").append(String.valueOf(emailSuccess));
            }
            historyWriter.startEvent(sb.toString());
        }
        return forumSuccess && emailSuccess && webSiteSuccess;
    }

    private String convertToHtml(String string) {
        return "<pre><br/>" + string.replaceAll("\n", "<br/>") + "<br/></pre>";
    }

    public IEmailSender getEmailSender() {
        return this.m_emailSender;
    }

    public String getEmailSendStatus() {
        return this.m_emailSendStatus;
    }

    public String getWebPostStatus() {
        return this.m_webPostStatus;
    }

    public boolean alsoPostMoveSummary() {
        if (this.m_forumPoster != null) {
            return this.m_forumPoster.getAlsoPostAfterCombatMove();
        }
        if (this.m_emailSender != null) {
            return this.m_emailSender.getAlsoPostAfterCombatMove();
        }
        return false;
    }

    public static void postTurn(final String title, final HistoryLog historyLog, final boolean includeSaveGame, final PBEMMessagePoster posterPBEM, final IAbstractForumPosterDelegate postingDelegate, final MainGameFrame mainGameFrame, final JComponent postButton) {
        int choice;
        IWebPoster webPoster;
        IEmailSender emailSender;
        String message = "";
        IForumPoster turnSummaryMsgr = posterPBEM.getForumPoster();
        StringBuilder sb = new StringBuilder();
        if (turnSummaryMsgr != null) {
            sb.append(message).append("Post " + title + " ");
            if (includeSaveGame) {
                sb.append("and save game ");
            }
            sb.append("to ").append(turnSummaryMsgr.getDisplayName()).append("?\n");
        }
        if ((emailSender = posterPBEM.getEmailSender()) != null) {
            sb.append("Send email to ").append(emailSender.getToAddress()).append("?\n");
        }
        if ((webPoster = posterPBEM.getWebPoster()) != null) {
            sb.append("Send game state of '" + webPoster.getGameName() + "' to " + webPoster.getHost() + "?\n");
        }
        if ((choice = JOptionPane.showConfirmDialog(mainGameFrame, message = sb.toString(), "Post " + title + "?", 2, -1, null)) != 0) {
            return;
        }
        postButton.setEnabled(false);
        final ProgressWindow progressWindow = new ProgressWindow(mainGameFrame, "Posting " + title + "...");
        progressWindow.setVisible(true);
        Runnable t = new Runnable(){

            public void run() {
                boolean postOk = true;
                File saveGameFile = null;
                postingDelegate.setHasPostedTurnSummary(true);
                try {
                    saveGameFile = File.createTempFile("triplea", ".tsvg");
                    if (saveGameFile != null) {
                        mainGameFrame.getGame().saveGame(saveGameFile);
                        posterPBEM.setSaveGame(saveGameFile);
                    }
                }
                catch (Exception e) {
                    postOk = false;
                    e.printStackTrace();
                }
                posterPBEM.setTurnSummary(historyLog.toString());
                try {
                    if (!postingDelegate.postTurnSummary(posterPBEM, title, includeSaveGame)) {
                        postOk = false;
                    }
                }
                catch (Exception e) {
                    postOk = false;
                    e.printStackTrace();
                }
                postingDelegate.setHasPostedTurnSummary(postOk);
                StringBuilder sb = new StringBuilder();
                if (posterPBEM.getForumPoster() != null) {
                    String saveGameRef = posterPBEM.getSaveGameRef();
                    String turnSummaryRef = posterPBEM.getTurnSummaryRef();
                    if (saveGameRef != null) {
                        sb.append("\nSave Game : ").append(saveGameRef);
                    }
                    if (turnSummaryRef != null) {
                        sb.append("\nSummary Text: ").append(turnSummaryRef);
                    }
                }
                if (posterPBEM.getEmailSender() != null) {
                    sb.append("\nEmails: ").append(posterPBEM.getEmailSendStatus());
                }
                if (posterPBEM.getWebPoster() != null) {
                    sb.append("\nWeb Site Post: ").append(posterPBEM.getWebPostStatus());
                }
                historyLog.getWriter().println(sb.toString());
                if (historyLog.isVisible()) {
                    historyLog.setVisible(true);
                }
                try {
                    if (saveGameFile != null && !saveGameFile.delete()) {
                        System.out.println("INFO TripleA PBEM/PBF poster couldn't delete temporary savegame: " + saveGameFile.getCanonicalPath());
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                progressWindow.setVisible(false);
                progressWindow.removeAll();
                progressWindow.dispose();
                final boolean finalPostOk = postOk;
                final String finalMessage = sb.toString();
                Runnable runnable = new Runnable(){

                    public void run() {
                        postButton.setEnabled(!finalPostOk);
                        if (finalPostOk) {
                            JOptionPane.showMessageDialog(mainGameFrame, finalMessage, title + " Posted", 1);
                        } else {
                            JOptionPane.showMessageDialog(mainGameFrame, finalMessage, title + " Posted", 0);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        new Thread(t).start();
    }
}

