/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.IRemoteRandom;
import games.strategy.engine.random.PlainRandomSource;
import games.strategy.engine.vault.Vault;
import games.strategy.engine.vault.VaultID;

public class CryptoRandomSource
implements IRandomSource {
    private final IRandomSource m_plainRandom = new PlainRandomSource();
    private final PlayerID m_remotePlayer;
    private final IGame m_game;

    public static byte[] intsToBytes(int[] ints) {
        byte[] rVal = new byte[ints.length * 4];
        for (int i = 0; i < ints.length; ++i) {
            rVal[4 * i] = (byte)(0xFF & ints[i]);
            rVal[4 * i + 1] = (byte)(0xFF & ints[i] >> 8);
            rVal[4 * i + 2] = (byte)(0xFF & ints[i] >> 16);
            rVal[4 * i + 3] = (byte)(0xFF & ints[i] >> 24);
        }
        return rVal;
    }

    static int byteToIntUnsigned(byte val) {
        return val & 0xFF;
    }

    public static int[] bytesToInts(byte[] bytes) {
        int[] rVal = new int[bytes.length / 4];
        for (int i = 0; i < rVal.length; ++i) {
            rVal[i] = CryptoRandomSource.byteToIntUnsigned(bytes[4 * i]) + (CryptoRandomSource.byteToIntUnsigned(bytes[4 * i + 1]) << 8) + (CryptoRandomSource.byteToIntUnsigned(bytes[4 * i + 2]) << 16) + (CryptoRandomSource.byteToIntUnsigned(bytes[4 * i + 3]) << 24);
        }
        return rVal;
    }

    public static int[] xor(int[] val1, int[] val2, int max) {
        if (val1.length != val2.length) {
            throw new IllegalArgumentException("Arrays not of same length");
        }
        int[] rVal = new int[val1.length];
        for (int i = 0; i < val1.length; ++i) {
            rVal[i] = (val1[i] + val2[i]) % max;
        }
        return rVal;
    }

    public CryptoRandomSource(PlayerID remotePlayer, IGame game) {
        this.m_remotePlayer = remotePlayer;
        this.m_game = game;
    }

    public int getRandom(int max, String annotation) {
        return this.getRandom(max, 1, annotation)[0];
    }

    public int[] getRandom(int max, int count, String annotation) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count:" + count);
        }
        Vault vault = this.m_game.getVault();
        int[] localRandom = this.m_plainRandom.getRandom(max, count, annotation);
        VaultID localID = vault.lock(CryptoRandomSource.intsToBytes(localRandom));
        IRemoteRandom remote = (IRemoteRandom)this.m_game.getRemoteMessenger().getRemote(ServerGame.getRemoteRandomName(this.m_remotePlayer));
        int[] remoteNumbers = remote.generate(max, count, annotation, localID);
        vault.unlock(localID);
        remote.verifyNumbers();
        return CryptoRandomSource.xor(localRandom, remoteNumbers, max);
    }
}

