/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.random.IRandomSource;
import java.util.StringTokenizer;

public class ScriptedRandomSource
implements IRandomSource {
    public static final int PAUSE = -2;
    public static final int ERROR = -3;
    private static final String SCRIPTED_RANDOM_PROPERTY = "triplea.scriptedRandom";
    private final int[] m_numbers;
    private int m_currentIndex = 0;
    private int m_rolled;

    public static boolean useScriptedRandom() {
        return System.getProperty(SCRIPTED_RANDOM_PROPERTY) != null && System.getProperty(SCRIPTED_RANDOM_PROPERTY).trim().length() > 0;
    }

    public ScriptedRandomSource() {
        String property = System.getProperty(SCRIPTED_RANDOM_PROPERTY, "1,2,3");
        int length = property.split(",").length;
        StringTokenizer tokenizer = new StringTokenizer(property, ",");
        this.m_numbers = new int[length];
        for (int i = 0; i < this.m_numbers.length; ++i) {
            String token = tokenizer.nextToken();
            this.m_numbers[i] = token.equals("e") ? -3 : (token.equals("p") ? -2 : Integer.parseInt(token) - 1);
        }
    }

    public ScriptedRandomSource(int[] numbers) {
        this.m_numbers = numbers;
    }

    public ScriptedRandomSource(Integer ... numbers) {
        this.m_numbers = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.m_numbers[i] = numbers[i];
        }
    }

    public int getRandom(int max, String annotation) {
        return this.getRandom(max, 1, null)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRandom(int max, int count, String annotation) {
        if (count <= 0) {
            throw new IllegalStateException("count must be > o, annotation:" + annotation);
        }
        this.m_rolled += count;
        int[] rVal = new int[count];
        for (int i = 0; i < count; ++i) {
            if (this.m_numbers[this.m_currentIndex] == -2) {
                try {
                    Object o;
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.m_numbers[this.m_currentIndex] == -3) {
                throw new IllegalStateException("Random number generator generating scripted error");
            }
            rVal[i] = this.m_numbers[this.m_currentIndex];
            ++this.m_currentIndex;
            if (this.m_currentIndex < this.m_numbers.length) continue;
            this.m_currentIndex = 0;
        }
        return rVal;
    }

    public int getTotalRolled() {
        return this.m_rolled;
    }
}

