/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.checkers;

import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.checkers.player.RandomAI;
import games.strategy.grid.checkers.ui.CheckersMapPanel;
import games.strategy.grid.checkers.ui.CheckersMenu;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkers
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = 1697055013624548205L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> iplayers = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GridGamePlayer player = new GridGamePlayer(name, type);
                iplayers.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                RandomAI ai = new RandomAI(name, type);
                iplayers.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return iplayers;
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return CheckersMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return GridMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return CheckersMenu.class;
    }
}

