/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.checkers.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.grid.checkers.delegate.EndTurnExtendedDelegateState;
import games.strategy.grid.checkers.delegate.PlayDelegate;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumDelegate;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;

public class EndTurnDelegate
extends AbstractPlayByEmailOrForumDelegate {
    public void start() {
        super.start();
        if (EndTurnDelegate.isDraw(this.getData())) {
            this.signalGameOver("Game Is A Draw!");
        } else {
            PlayerID winner = this.checkForWinner();
            if (winner != null) {
                this.signalGameOver(winner.getName() + " wins!");
            }
        }
    }

    public void end() {
        super.end();
    }

    public Serializable saveState() {
        EndTurnExtendedDelegateState state = new EndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    public void loadState(Serializable state) {
        EndTurnExtendedDelegateState s = (EndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    private void signalGameOver(String status) {
        this.m_bridge.getHistoryWriter().startEvent(status);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }

    private PlayerID checkForWinner() {
        if (EndTurnDelegate.doWeWin(this.m_player, this.getData())) {
            return this.m_player;
        }
        return null;
    }

    public static boolean doWeWin(PlayerID player, GameData data) {
        if (player == null) {
            throw new IllegalArgumentException("Checking for winner can not have null player");
        }
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (player.equals(enemy) || PlayDelegate.canNotMakeMoves(enemy, data)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDraw(GameData data) {
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            if (PlayDelegate.canNotMakeMoves(player, data)) continue;
            return false;
        }
        return true;
    }
}

