/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.checkers.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.checkers.delegate.CheckersPlayExtendedDelegateState;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AutoSave(beforeStepStart=false, afterStepEnd=true)
public class PlayDelegate
extends AbstractDelegate
implements IGridPlayDelegate {
    public static String ALLOW_JUMPING_OVER_YOUR_OWN_PIECES = "Allow Jumping Over Your Own Pieces";
    public static String ALLOW_UNCROWNED_PIECES_TO_CAPTURE_BACKWARDS = "Allow Uncrowned Pieces To Capture Backwards";
    public static boolean ALLOW_JUMPING_SAME_PIECE_TWICE_IF_OWNED = false;
    public static final Match<PlayerID> PlayerBeginsAtLowestRank = new Match<PlayerID>(){

        @Override
        public boolean match(PlayerID player) {
            return player != null && player.getName().equalsIgnoreCase("Black");
        }
    };
    public static final Match<Unit> UnitIsPawn = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("pawn");
        }
    };
    public static final Match<Unit> UnitIsKing = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("king");
        }
    };
    public static final Match<Unit> UnitIsUnit = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null;
        }
    };

    public static boolean getPropertyAllowJumpingOverYourOwnPieces(GameData data) {
        return data.getProperties().get(ALLOW_JUMPING_OVER_YOUR_OWN_PIECES, false);
    }

    public static boolean getPropertyAllowUncrownedPiecesToCaptureBackwards(GameData data) {
        return data.getProperties().get(ALLOW_UNCROWNED_PIECES_TO_CAPTURE_BACKWARDS, false);
    }

    @Override
    public void start() {
        super.start();
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        CheckersPlayExtendedDelegateState state = new CheckersPlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        CheckersPlayExtendedDelegateState s = (CheckersPlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public String play(IGridPlayData play) {
        for (Territory t : play.getAllSteps()) {
            if (t.getUnits().getUnitCount() <= 1) continue;
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        String error = PlayDelegate.isValidPlayOverall(play, this.m_player, this.getData());
        if (error != null) {
            return error;
        }
        Collection<Territory> captured = PlayDelegate.checkForCaptures(play, this.m_player, this.getData());
        this.performPlay(play, captured, this.m_player);
        for (Territory t : play.getAllSteps()) {
            if (t.getUnits().getUnitCount() <= 1) continue;
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        return null;
    }

    public static String isValidPlay(IGridPlayData play, PlayerID player, GameData data, boolean uncrownedCanCaptureBackwards, boolean allowJumpingOwnPieces) {
        String basic = PlayDelegate.isValidMoveBasic(play, player, data);
        if (basic != null) {
            return basic;
        }
        String pieceBasic = PlayDelegate.isValidPieceMoveBasic(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces);
        if (pieceBasic != null) {
            return pieceBasic;
        }
        String formedLoop = PlayDelegate.isValidMoveNoLoops(play, player, data);
        if (formedLoop != null) {
            return formedLoop;
        }
        return null;
    }

    public static Collection<Territory> checkForCaptures(IGridPlayData play, PlayerID player, GameData data) {
        HashSet<Territory> captured = new HashSet<Territory>();
        int lastY = play.getStart().getY();
        int lastX = play.getStart().getX();
        int numSteps = play.getAllStepsExceptStart().size();
        if (numSteps == 1) {
            int diffX = Math.abs(lastX - play.getEnd().getX());
            int diffY = Math.abs(lastY - play.getEnd().getY());
            if (diffX == 1 && diffY == 1) {
                return captured;
            }
        }
        GameMap map = data.getMap();
        for (Territory t : play.getAllStepsExceptStart()) {
            Territory jumped;
            if (lastY < t.getY()) {
                if (lastX < t.getX()) {
                    jumped = map.getTerritoryFromCoordinates(false, lastX + 1, lastY + 1);
                    if (jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        captured.add(jumped);
                    }
                } else {
                    jumped = map.getTerritoryFromCoordinates(false, lastX - 1, lastY + 1);
                    if (jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        captured.add(jumped);
                    }
                }
            } else if (lastX < t.getX()) {
                jumped = map.getTerritoryFromCoordinates(false, lastX + 1, lastY - 1);
                if (jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                    captured.add(jumped);
                }
            } else {
                jumped = map.getTerritoryFromCoordinates(false, lastX - 1, lastY - 1);
                if (jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                    captured.add(jumped);
                }
            }
            lastY = t.getY();
            lastX = t.getX();
        }
        return captured;
    }

    private void performPlay(IGridPlayData play, Collection<Territory> captured, PlayerID player) {
        ArrayList<Unit> promotionUnits;
        Collection<Unit> units = play.getStart().getUnits().getUnits();
        if (PlayDelegate.isValidPawnPromotion(play, this.m_player, this.getData())) {
            promotionUnits = new ArrayList<Unit>();
            promotionUnits.add(this.getData().getUnitTypeList().getUnitType("king").create(player));
        } else {
            promotionUnits = null;
        }
        this.m_bridge.getHistoryWriter().startEvent(play.toString(), units);
        Change removeUnit = ChangeFactory.removeUnits(play.getStart(), units);
        Change addUnit = ChangeFactory.addUnits(play.getEnd(), promotionUnits == null ? units : promotionUnits);
        CompositeChange change = new CompositeChange();
        change.add(removeUnit);
        change.add(addUnit);
        HashSet<Unit> capturedUnitsTotal = new HashSet<Unit>();
        for (Territory at : captured) {
            Collection<Unit> capturedUnits;
            if (at == null || (capturedUnits = at.getUnits().getUnits()).isEmpty()) continue;
            Change capture = ChangeFactory.removeUnits(at, capturedUnits);
            change.add(capture);
            capturedUnitsTotal.addAll(capturedUnits);
        }
        if (!capturedUnitsTotal.isEmpty()) {
            this.m_bridge.getHistoryWriter().addChildToEvent(player.getName() + " captures units: " + MyFormatter.unitsToText(capturedUnitsTotal), capturedUnitsTotal);
        }
        HashSet<Territory> refresh = new HashSet<Territory>(play.getAllSteps());
        refresh.addAll(captured);
        this.m_bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.refreshTerritories(refresh);
        display.showGridPlayDataMove(play);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridPlayDelegate.class;
    }

    public static Match<Territory> TerritoryHasUnitsOwnedBy(PlayerID player) {
        final Match<Unit> unitOwnedBy = PlayDelegate.UnitIsOwnedBy(player);
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(unitOwnedBy);
            }
        };
    }

    public static Match<Unit> UnitIsOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return unit.getOwner().equals(player);
            }
        };
    }

    public static String isValidMoveBasic(IGridPlayData play, PlayerID player, GameData data) {
        if (play.getStart() == null || play.getEnd() == null) {
            return "Can Not Move Off Board";
        }
        int even = (play.getStart().getX() + play.getStart().getY()) % 2;
        for (Territory t : play.getAllStepsExceptStart()) {
            if ((t.getX() + t.getY()) % 2 == even) continue;
            return "Must Stay On Diagonal Tiles";
        }
        Collection<Unit> units = play.getStart().getUnits().getUnits();
        if (units == null || units.isEmpty()) {
            return "No Piece Selected";
        }
        if (play.getStart().equals(play.getEnd())) {
            return "Must Move Piece To New Position";
        }
        Unit unit = units.iterator().next();
        if (!PlayDelegate.UnitIsOwnedBy(player).match(unit)) {
            return "You Do Not Own This Piece";
        }
        for (Territory t : play.getAllStepsExceptStart()) {
            if (t.getUnits().getUnitCount() <= 0) continue;
            return "A Piece Is In That Position";
        }
        return null;
    }

    public static String isValidPieceMoveBasic(IGridPlayData play, PlayerID player, GameData data, boolean uncrownedCanCaptureBackwards, boolean allowJumpingOwnPieces) {
        Collection<Unit> units = play.getStart().getUnits().getUnits();
        Unit unit = units.iterator().next();
        if (UnitIsPawn.match(unit)) {
            return PlayDelegate.isValidPawnMove(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces);
        }
        if (UnitIsKing.match(unit)) {
            return PlayDelegate.isValidKingMove(play, player, data, allowJumpingOwnPieces);
        }
        return "?? Unit";
    }

    public static boolean canNotMakeMoves(PlayerID player, GameData data) {
        Territory tWithUnits = null;
        for (Territory t : data.getMap().getTerritories()) {
            if (t.getUnits().getUnitCount() <= 0) continue;
            tWithUnits = t;
            break;
        }
        Set<Territory> allTerritories = PlayDelegate.getAllTerritoriesOnMapWhichCanHaveUnits(tWithUnits, data);
        List<Territory> myTerritories = Match.getMatches(allTerritories, PlayDelegate.TerritoryHasUnitsOwnedBy(player));
        for (Territory t : myTerritories) {
            if (PlayDelegate.getAllValidMovesFromHere(t, player, data).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static String isValidPlayOverall(IGridPlayData play, PlayerID player, GameData data) {
        String validNormal = PlayDelegate.isValidPlay(play, player, data, PlayDelegate.getPropertyAllowUncrownedPiecesToCaptureBackwards(data), PlayDelegate.getPropertyAllowJumpingOverYourOwnPieces(data));
        if (validNormal != null) {
            return validNormal;
        }
        if (PlayDelegate.getAllValidMoves(player, data).contains(play)) {
            return null;
        }
        return "Must Capture Pieces Or Finish Sequence";
    }

    public static List<GridPlayData> getAllValidMoves(PlayerID player, GameData data) {
        Territory tWithUnits = null;
        for (Territory t : data.getMap().getTerritories()) {
            if (t.getUnits().getUnitCount() <= 0) continue;
            tWithUnits = t;
            break;
        }
        Set<Territory> allTerritories = PlayDelegate.getAllTerritoriesOnMapWhichCanHaveUnits(tWithUnits, data);
        List<Territory> myTerritories = Match.getMatches(allTerritories, PlayDelegate.TerritoryHasUnitsOwnedBy(player));
        ArrayList<GridPlayData> validMoves = new ArrayList<GridPlayData>();
        for (Territory t : myTerritories) {
            validMoves.addAll(PlayDelegate.getAllValidMovesFromHere(t, player, data));
        }
        List<GridPlayData> captureMoves = Match.getMatches(validMoves, PlayDelegate.GridPlayDataCaptures(data));
        if (captureMoves.isEmpty()) {
            return validMoves;
        }
        return PlayDelegate.getPlaysWithShortVersionsRemoved(captureMoves, player, data);
    }

    public static Match<GridPlayData> GridPlayDataCaptures(final GameData data) {
        return new Match<GridPlayData>(){

            @Override
            public boolean match(GridPlayData play) {
                return play != null && !PlayDelegate.checkForCaptures(play, play.getPlayerID(), data).isEmpty();
            }
        };
    }

    public static Set<Territory> getAllTerritoriesOnMapWhichCanHaveUnits(Territory start, GameData data) {
        HashSet<Territory> allTerritories = new HashSet<Territory>();
        int even = (start.getX() + start.getY()) % 2;
        for (Territory t : data.getMap().getTerritories()) {
            if ((t.getX() + t.getY()) % 2 != even) continue;
            allTerritories.add(t);
        }
        return allTerritories;
    }

    public static Set<GridPlayData> getAllValidMovesFromHere(Territory start, PlayerID player, GameData data) {
        PIECES piece;
        List<Unit> units = start.getUnits().getMatches(PlayDelegate.UnitIsOwnedBy(player));
        if (units.isEmpty()) {
            return new HashSet<GridPlayData>();
        }
        Unit unit = (Unit)units.iterator().next();
        if (UnitIsPawn.match(unit)) {
            piece = PIECES.PAWN;
        } else if (UnitIsKing.match(unit)) {
            piece = PIECES.KING;
        } else {
            return new HashSet<GridPlayData>();
        }
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        HashSet<GridPlayData> validMoves = new HashSet<GridPlayData>();
        return PlayDelegate.getAllValidMovesFromHere(validMoves, new HashSet<GridPlayData>(), start, start, new ArrayList<Territory>(), piece, startsAtLowRank, player, data, true, PlayDelegate.getPropertyAllowUncrownedPiecesToCaptureBackwards(data), PlayDelegate.getPropertyAllowJumpingOverYourOwnPieces(data));
    }

    public static Set<GridPlayData> getAllValidMovesFromHere(Set<GridPlayData> validMovesSoFar, Set<GridPlayData> triedMovesSoFar, Territory originalStart, Territory thisStart, List<Territory> middleStepsSoFar, PIECES unit, boolean startsAtLowRank, PlayerID player, GameData data, boolean checkInitialMove, boolean uncrownedCanCaptureBackwards, boolean allowJumpingOwnPieces) {
        GameMap map = data.getMap();
        if (unit == PIECES.PAWN) {
            Territory right;
            ArrayList<Territory> newMiddleSteps;
            boolean valid;
            GridPlayData play;
            int newY;
            if (checkInitialMove) {
                Territory right2;
                GridPlayData play2;
                newY = thisStart.getY() + (startsAtLowRank ? 1 : -1);
                Territory left = map.getTerritoryFromCoordinates(thisStart.getX() - 1, newY);
                if (left != null && PlayDelegate.isValidPlay(play2 = new GridPlayData(thisStart, left, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play2);
                }
                if ((right2 = map.getTerritoryFromCoordinates(thisStart.getX() + 1, newY)) != null && PlayDelegate.isValidPlay(play2 = new GridPlayData(thisStart, right2, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play2);
                }
            }
            newY = thisStart.getY() + (startsAtLowRank ? 2 : -2);
            int otherY = thisStart.getY() + (startsAtLowRank ? -2 : 2);
            Territory left = map.getTerritoryFromCoordinates(thisStart.getX() - 2, newY);
            if (left != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, left, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(left);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, left, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
            if ((right = map.getTerritoryFromCoordinates(thisStart.getX() + 2, newY)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, right, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(right);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, right, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
            if (uncrownedCanCaptureBackwards) {
                left = map.getTerritoryFromCoordinates(thisStart.getX() - 2, otherY);
                if (left != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, left, player))) {
                    boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                    if (valid) {
                        validMovesSoFar.add(play);
                        newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                        newMiddleSteps.add(left);
                        triedMovesSoFar.add(play);
                        validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, left, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                    }
                }
                if ((right = map.getTerritoryFromCoordinates(thisStart.getX() + 2, otherY)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, right, player))) {
                    boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                    if (valid) {
                        validMovesSoFar.add(play);
                        newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                        newMiddleSteps.add(right);
                        triedMovesSoFar.add(play);
                        validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, right, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                    }
                }
            }
        } else if (unit == PIECES.KING) {
            ArrayList<Territory> newMiddleSteps;
            boolean valid;
            Territory rightDown;
            Territory leftDown;
            Territory rightUp;
            GridPlayData play;
            Territory leftUp;
            if (checkInitialMove) {
                leftUp = map.getTerritoryFromCoordinates(thisStart.getX() - 1, thisStart.getY() - 1);
                if (leftUp != null && PlayDelegate.isValidPlay(play = new GridPlayData(thisStart, leftUp, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play);
                }
                if ((rightUp = map.getTerritoryFromCoordinates(thisStart.getX() + 1, thisStart.getY() - 1)) != null && PlayDelegate.isValidPlay(play = new GridPlayData(thisStart, rightUp, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play);
                }
                if ((leftDown = map.getTerritoryFromCoordinates(thisStart.getX() - 1, thisStart.getY() + 1)) != null && PlayDelegate.isValidPlay(play = new GridPlayData(thisStart, leftDown, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play);
                }
                if ((rightDown = map.getTerritoryFromCoordinates(thisStart.getX() + 1, thisStart.getY() + 1)) != null && PlayDelegate.isValidPlay(play = new GridPlayData(thisStart, rightDown, player), player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null) {
                    validMovesSoFar.add(play);
                }
            }
            if ((leftUp = map.getTerritoryFromCoordinates(thisStart.getX() - 2, thisStart.getY() - 2)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, leftUp, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(leftUp);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, leftUp, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
            if ((rightUp = map.getTerritoryFromCoordinates(thisStart.getX() + 2, thisStart.getY() - 2)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, rightUp, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(rightUp);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, rightUp, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
            if ((leftDown = map.getTerritoryFromCoordinates(thisStart.getX() - 2, thisStart.getY() + 2)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, leftDown, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(leftDown);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, leftDown, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
            if ((rightDown = map.getTerritoryFromCoordinates(thisStart.getX() + 2, thisStart.getY() + 2)) != null && !triedMovesSoFar.contains(play = new GridPlayData(originalStart, middleStepsSoFar, rightDown, player))) {
                boolean bl = valid = PlayDelegate.isValidPlay(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces) == null;
                if (valid) {
                    validMovesSoFar.add(play);
                    newMiddleSteps = new ArrayList<Territory>(middleStepsSoFar);
                    newMiddleSteps.add(rightDown);
                    triedMovesSoFar.add(play);
                    validMovesSoFar.addAll(PlayDelegate.getAllValidMovesFromHere(validMovesSoFar, triedMovesSoFar, originalStart, rightDown, newMiddleSteps, unit, startsAtLowRank, player, data, false, uncrownedCanCaptureBackwards, allowJumpingOwnPieces));
                }
            }
        }
        return validMovesSoFar;
    }

    public static String isValidPawnMove(IGridPlayData play, PlayerID player, GameData data, boolean uncrownedCanCaptureBackwards, boolean allowJumpingOwnPieces) {
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        int lastY = play.getStart().getY();
        int lastX = play.getStart().getX();
        int numSteps = play.getAllStepsExceptStart().size();
        if (numSteps == 1) {
            int diffX = Math.abs(lastX - play.getEnd().getX());
            int diffY = Math.abs(lastY - play.getEnd().getY());
            if (diffX == 1 && diffY == 1) {
                if (startsAtLowRank ? lastY > play.getEnd().getY() : lastY < play.getEnd().getY()) {
                    return "Pawns Must Move Forward Diagonally";
                }
                return null;
            }
        }
        return PlayDelegate.isValidCaptureMove(play, player, data, uncrownedCanCaptureBackwards, allowJumpingOwnPieces);
    }

    public static boolean isValidPawnPromotion(IGridPlayData play, PlayerID player, GameData data) {
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        if (!play.getStart().getUnits().someMatch(UnitIsPawn)) {
            return false;
        }
        if (startsAtLowRank && play.getEnd().getY() == data.getMap().getYDimension() - 1) {
            return true;
        }
        return !startsAtLowRank && play.getEnd().getY() == 0;
    }

    public static String isValidKingMove(IGridPlayData play, PlayerID player, GameData data, boolean allowJumpingOwnPieces) {
        int lastY = play.getStart().getY();
        int lastX = play.getStart().getX();
        int numSteps = play.getAllStepsExceptStart().size();
        if (numSteps == 1) {
            int diffX = Math.abs(lastX - play.getEnd().getX());
            int diffY = Math.abs(lastY - play.getEnd().getY());
            if (diffX == 1 && diffY == 1) {
                return null;
            }
        }
        return PlayDelegate.isValidCaptureMove(play, player, data, true, allowJumpingOwnPieces);
    }

    public static String isValidCaptureMove(IGridPlayData play, PlayerID player, GameData data, boolean canCaptureBackwards, boolean allowJumpingOwnPieces) {
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        int lastY = play.getStart().getY();
        int lastX = play.getStart().getX();
        HashSet<Territory> capturedAlready = new HashSet<Territory>();
        GameMap map = data.getMap();
        for (Territory t : play.getAllStepsExceptStart()) {
            Territory jumped;
            int diffY;
            int diffX;
            if (lastY == t.getY()) {
                return "Must Move Forward Or Backward Diagonally";
            }
            if (lastY < t.getY()) {
                if (!startsAtLowRank && !canCaptureBackwards) {
                    return "Must Capture Moving Forward";
                }
                if (lastX == t.getX()) {
                    return "Must Jump Over Pieces To Get There Or Must Move Right Or Left";
                }
                diffX = Math.abs(lastX - t.getX());
                diffY = Math.abs(lastY - t.getY());
                if (diffX != 2 || diffY != 2) {
                    return "Must Either Move A Single Space, Or Jump Over Pieces";
                }
                if (lastX < t.getX()) {
                    jumped = map.getTerritoryFromCoordinates(false, lastX + 1, lastY + 1);
                    if (jumped.getUnits().getMatches(allowJumpingOwnPieces ? UnitIsUnit : PlayDelegate.UnitIsOwnedBy(player).invert()).isEmpty()) {
                        return "Must Jump Over A Piece";
                    }
                    if (capturedAlready.contains(jumped)) {
                        return "Can Not Form Loops";
                    }
                    if (!ALLOW_JUMPING_SAME_PIECE_TWICE_IF_OWNED || jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        capturedAlready.add(jumped);
                    }
                } else {
                    jumped = map.getTerritoryFromCoordinates(false, lastX - 1, lastY + 1);
                    if (jumped.getUnits().getMatches(allowJumpingOwnPieces ? UnitIsUnit : PlayDelegate.UnitIsOwnedBy(player).invert()).isEmpty()) {
                        return "Must Jump Over A Piece";
                    }
                    if (capturedAlready.contains(jumped)) {
                        return "Can Not Form Loops";
                    }
                    if (!ALLOW_JUMPING_SAME_PIECE_TWICE_IF_OWNED || jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        capturedAlready.add(jumped);
                    }
                }
            } else {
                if (startsAtLowRank && !canCaptureBackwards) {
                    return "Must Capture Moving Forward";
                }
                if (lastX == t.getX()) {
                    return "Must Jump Over Pieces To Get There Or Must Move Right Or Left";
                }
                diffX = Math.abs(lastX - t.getX());
                diffY = Math.abs(lastY - t.getY());
                if (diffX != 2 || diffY != 2) {
                    return "Must Either Move A Single Space, Or Jump Over Pieces";
                }
                if (lastX < t.getX()) {
                    jumped = map.getTerritoryFromCoordinates(false, lastX + 1, lastY - 1);
                    if (jumped.getUnits().getMatches(allowJumpingOwnPieces ? UnitIsUnit : PlayDelegate.UnitIsOwnedBy(player).invert()).isEmpty()) {
                        return "Must Jump Over A Piece";
                    }
                    if (capturedAlready.contains(jumped)) {
                        return "Can Not Form Loops";
                    }
                    if (!ALLOW_JUMPING_SAME_PIECE_TWICE_IF_OWNED || jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        capturedAlready.add(jumped);
                    }
                } else {
                    jumped = map.getTerritoryFromCoordinates(false, lastX - 1, lastY - 1);
                    if (jumped.getUnits().getMatches(allowJumpingOwnPieces ? UnitIsUnit : PlayDelegate.UnitIsOwnedBy(player).invert()).isEmpty()) {
                        return "Must Jump Over A Piece";
                    }
                    if (capturedAlready.contains(jumped)) {
                        return "Can Not Form Loops";
                    }
                    if (!ALLOW_JUMPING_SAME_PIECE_TWICE_IF_OWNED || jumped.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert())) {
                        capturedAlready.add(jumped);
                    }
                }
            }
            lastY = t.getY();
            lastX = t.getX();
        }
        return null;
    }

    public static String isValidMoveNoLoops(IGridPlayData play, PlayerID player, GameData data) {
        List<Territory> territories = play.getAllSteps();
        int size = territories.size();
        if (size <= 2) {
            return null;
        }
        ArrayList<Tuple<Territory, Territory>> directions = new ArrayList<Tuple<Territory, Territory>>();
        for (int i = 0; i < size - 1; ++i) {
            directions.add(new Tuple<Territory, Territory>(territories.get(i), territories.get(i + 1)));
        }
        Iterator iter = directions.iterator();
        while (iter.hasNext()) {
            Tuple d1 = (Tuple)iter.next();
            for (int i = 1; i < directions.size(); ++i) {
                Tuple d2 = (Tuple)directions.get(i);
                if (!d1.equals(d2)) continue;
                return "No Loops Allowed";
            }
            iter.remove();
        }
        return null;
    }

    public static List<GridPlayData> getPlaysWithShortVersionsRemoved(List<GridPlayData> plays, PlayerID player, GameData data) {
        ArrayList<GridPlayData> validLongPlays = new ArrayList<GridPlayData>();
        ArrayList<GridPlayData> allPlays = new ArrayList<GridPlayData>(plays);
        Collections.sort(allPlays, GridPlayData.SmallestToLargestPlays);
        Iterator iter = allPlays.iterator();
        while (iter.hasNext()) {
            GridPlayData play = (GridPlayData)iter.next();
            boolean isNotContained = true;
            for (IGridPlayData iGridPlayData : allPlays) {
                if (!iGridPlayData.isBiggerThanAndContains(play)) continue;
                isNotContained = false;
                break;
            }
            if (isNotContained) {
                validLongPlays.add(play);
            }
            iter.remove();
        }
        return validLongPlays;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PIECES {
        PAWN,
        KING;

    }
}

