/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.checkers.player;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.grid.checkers.delegate.PlayDelegate;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomAI
extends GridAbstractAI {
    public RandomAI(String name, String type) {
        super(name, type);
    }

    @Override
    protected void play() {
        String error;
        this.pause();
        GameData data = this.getGameData();
        PlayerID me = this.getPlayerID();
        ArrayList<Tuple<GridPlayData, Collection<Territory>>> validMoves = new ArrayList<Tuple<GridPlayData, Collection<Territory>>>();
        List<GridPlayData> valid = PlayDelegate.getAllValidMoves(me, data);
        for (GridPlayData v : valid) {
            Collection<Territory> captures = PlayDelegate.checkForCaptures(v, me, data);
            validMoves.add(new Tuple<GridPlayData, Collection<Territory>>(v, captures));
        }
        Collections.shuffle(validMoves);
        Collections.sort(validMoves, RandomAI.getBestCaptureComparator(me, data));
        IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        Iterator iter = validMoves.iterator();
        while ((error = playDel.play((IGridPlayData)((Tuple)iter.next()).getFirst())) != null && iter.hasNext()) {
        }
    }

    static Comparator<Tuple<GridPlayData, Collection<Territory>>> getBestCaptureComparator(PlayerID player, GameData data) {
        return new Comparator<Tuple<GridPlayData, Collection<Territory>>>(){

            @Override
            public int compare(Tuple<GridPlayData, Collection<Territory>> t1, Tuple<GridPlayData, Collection<Territory>> t2) {
                int points2;
                if (t1 == null && t2 == null || t1 == t2) {
                    return 0;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return 0;
                }
                HashSet<Unit> units1 = new HashSet<Unit>();
                for (Territory t : t1.getSecond()) {
                    units1.addAll(t.getUnits().getUnits());
                }
                HashSet<Unit> units2 = new HashSet<Unit>();
                for (Territory t : t2.getSecond()) {
                    units2.addAll(t.getUnits().getUnits());
                }
                int points1 = RandomAI.getPointsForUnits(units1);
                if (points1 == (points2 = RandomAI.getPointsForUnits(units2))) {
                    return 0;
                }
                if (points1 > points2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static int getPointsForUnits(Collection<Unit> capturedUnits) {
        int points = 0;
        for (Unit u : capturedUnits) {
            if (PlayDelegate.UnitIsPawn.match(u)) {
                points += 5;
                continue;
            }
            if (!PlayDelegate.UnitIsKing.match(u)) continue;
            points += 9;
        }
        return points;
    }
}

