/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.checkers.ui;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.checkers.delegate.PlayDelegate;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.ui.ImageScrollModel;
import games.strategy.util.Tuple;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckersMapPanel
extends GridMapPanel {
    private static final long serialVersionUID = 1086068265270157799L;
    protected List<Territory> m_middleClickedTerritories = null;

    public CheckersMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(data, mapData, parentGridGameFrame, imageScrollModel);
    }

    @Override
    protected String isValidPlay(IGridPlayData play) {
        return PlayDelegate.isValidPlayOverall(play, this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
    }

    @Override
    protected Collection<Territory> getCapturesForPlay(IGridPlayData play) {
        return PlayDelegate.checkForCaptures(play, this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
    }

    @Override
    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> getValidMovesList(Territory clickedOn, PlayerID player) {
        if (clickedOn == null) {
            return null;
        }
        HashSet<GridPlayData> validMovesList = new HashSet<GridPlayData>();
        HashSet<Territory> capturesForValidMoves = new HashSet<Territory>();
        for (GridPlayData play : PlayDelegate.getAllValidMovesFromHere(clickedOn, player, this.m_gameData)) {
            if (PlayDelegate.isValidPlayOverall(play, player, this.m_gameData) != null) continue;
            validMovesList.add(play);
            capturesForValidMoves.addAll(this.getCapturesForPlay(play));
        }
        return new Tuple<Collection<IGridPlayData>, Collection<Territory>>(validMovesList, capturesForValidMoves);
    }

    @Override
    protected void paintComponentMiddleLayer(Graphics2D g2d, int topLeftX, int topLeftY) {
        Polygon p;
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
        Color tileOdd = new Color(209, 139, 71);
        Color tileEven = new Color(255, 206, 158);
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            p = entry.getValue();
            Territory at = entry.getKey();
            Color backgroundColor = (at.getX() + at.getY()) % 2 == 0 ? tileEven : tileOdd;
            g2d.setColor(backgroundColor);
            g2d.fillPolygon(p);
            g2d.setColor(Color.black);
            Image image = (Image)this.m_images.get(at);
            if (image != null) {
                Rectangle square = p.getBounds();
                if (at.equals(this.m_clickedAt)) {
                    g2d.drawImage(image, square.x - this.m_mapData.getSquareWidth() / 5, square.y - this.m_mapData.getSquareHeight() / 5, square.width + 2 * this.m_mapData.getSquareWidth() / 5, square.height + 2 * this.m_mapData.getSquareHeight() / 5, null, null);
                } else {
                    g2d.drawImage(image, square.x, square.y, square.width, square.height, null, null);
                }
            }
            g2d.drawPolygon(p);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        if (this.m_middleClickedTerritories != null) {
            for (Territory t : this.m_middleClickedTerritories) {
                p = this.m_mapData.getPolygon(t);
                Rectangle rect = p.getBounds();
                g2d.drawImage(this.m_mouseShadowImage, rect.x, rect.y, rect.width, rect.height, null, null);
            }
        }
        if (this.m_releasedAt != null) {
            Polygon p2 = this.m_mapData.getPolygon(this.m_releasedAt);
            Rectangle rect = p2.getBounds();
            g2d.drawImage(this.m_mouseShadowImage, rect.x, rect.y, rect.width, rect.height, null, null);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Territory at = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        if (at != null) {
            if (this.m_clickedAt == null) {
                this.m_clickedAt = at;
            } else if (this.m_releasedAt == null) {
                this.m_releasedAt = at;
            } else if (!at.equals(this.m_releasedAt)) {
                if (this.m_middleClickedTerritories == null) {
                    this.m_middleClickedTerritories = new ArrayList<Territory>();
                }
                this.m_middleClickedTerritories.add(this.m_releasedAt);
                this.m_releasedAt = at;
            }
            if (this.m_validMovesList == null) {
                this.setMouseShadowUnits(this.m_clickedAt.getUnits().getUnits());
                this.m_validMovesList = this.getValidMovesList(this.m_clickedAt, this.m_parentGridGameFrame.getActivePlayer());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Territory at = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        if (at != null) {
            this.notifyTerritorySelected(at, new MouseDetails(e, e.getX(), e.getY()));
            if (!at.equals(this.m_clickedAt) && !at.equals(this.m_releasedAt)) {
                this.mousePressed(e);
            }
        }
        if (!(BaseEditDelegate.getEditMode(this.m_gameData) || e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.getButton() != 1 || this.m_clickedAt == null || this.m_releasedAt == null)) {
            this.setMouseShadowUnits(null);
            this.m_validMovesList = null;
            if (this.m_waiting != null) {
                this.m_waiting.countDown();
            }
        }
    }

    @Override
    public IGridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null || this.m_releasedAt == null) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            this.m_middleClickedTerritories = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        if (this.m_clickedAt == this.m_releasedAt) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            this.m_middleClickedTerritories = null;
            return null;
        }
        GridPlayData play = new GridPlayData(this.m_clickedAt, this.m_middleClickedTerritories, this.m_releasedAt, player);
        this.m_clickedAt = null;
        this.m_releasedAt = null;
        this.m_middleClickedTerritories = null;
        String error = this.isValidPlay(play);
        if (error == null) {
            return play;
        }
        this.m_parentGridGameFrame.notifyError(error);
        return null;
    }
}

