/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess;

import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.chess.ChessUnitFactory;
import games.strategy.grid.chess.player.HeuristicAI;
import games.strategy.grid.chess.ui.ChessMapPanel;
import games.strategy.grid.chess.ui.ChessMenu;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chess
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = 6963459871530489560L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String HEURISTIC_COMPUTER_PLAYER_TYPE = "Mostly Random AI";
    public static final String AI_SEARCH_DEPTH_PROPERTY = "AI Search Depth";

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, HEURISTIC_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> iplayers = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GridGamePlayer player = new GridGamePlayer(name, type);
                iplayers.add(player);
                continue;
            }
            if (type.equals(HEURISTIC_COMPUTER_PLAYER_TYPE)) {
                HeuristicAI ai = new HeuristicAI(name, type);
                iplayers.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return iplayers;
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return ChessMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return GridMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return ChessMenu.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new ChessUnitFactory();
    }
}

