/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.chess.attachments.PlayerAttachment;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationDelegate
extends AbstractDelegate {
    @Override
    public void start() {
        super.start();
        CompositeChange initializingBoard = new CompositeChange();
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            PlayerAttachment pattachment = PlayerAttachment.get(player);
            if (pattachment != null) continue;
            pattachment = new PlayerAttachment("playerAttachment", player, this.getData());
            initializingBoard.add(ChangeFactory.addAttachmentChange(pattachment, player, "playerAttachment"));
        }
        if (!initializingBoard.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Initializing board");
            this.m_bridge.addChange(initializingBoard);
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        return null;
    }

    @Override
    public void loadState(Serializable state) {
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

