/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess.player;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.grid.chess.delegate.EndTurnDelegate;
import games.strategy.grid.chess.delegate.PlayDelegate;
import games.strategy.grid.chess.player.HeuristicAI;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.util.Quadruple;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaBeta
extends HeuristicAI {
    public AlphaBeta(String name, String type) {
        super(name, type);
    }

    @Override
    protected void play() {
        this.pause();
        PlayerID me = this.getPlayerID();
        GameData data = this.getGameData();
        IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        Collection<PlayerID> enemies = data.getPlayerList().getPlayers();
        enemies.remove(me);
        PlayerID enemy = enemies.iterator().next();
        int searchDepth = AlphaBeta.getAISearchDepthProperty(data);
        List<Triple<Territory, Territory, Long>> movesWithPoints = AlphaBeta.getPointsForBoardSituationStartBranches(me, enemy, data, searchDepth);
        if (movesWithPoints.isEmpty()) {
            System.err.println("No available moves for " + me.getName());
            return;
        }
        Collections.sort(movesWithPoints, AlphaBeta.getBestPointsComparatorLong());
        Triple<Territory, Territory, Long> ourMove = movesWithPoints.iterator().next();
        AlphaBeta.doMove((Territory)ourMove.getFirst(), (Territory)ourMove.getSecond(), data, playDel, me);
    }

    static List<Triple<Territory, Territory, Long>> getPointsForBoardSituationStartBranches(PlayerID theAI, PlayerID enemy, GameData data, final int branchesLeftToDo) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList movesWithPointsReferences = new ArrayList();
        List<Triple<Territory, Territory, Collection<Territory>>> available = AlphaBeta.getAllAvailableMoves(theAI, data, true);
        for (Triple<Territory, Territory, Collection<Territory>> move1 : available) {
            final Quadruple<Territory, Territory, PlayerID, GameData> quadruple = PlayDelegate.copyGameDataAndAttemptMove((Territory)move1.getFirst(), (Territory)move1.getSecond(), theAI, data);
            final PlayerID theAITemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(theAI, quadruple.getForth());
            final PlayerID currentEnemyTemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(enemy, quadruple.getForth());
            final AtomicReference reference = new AtomicReference();
            movesWithPointsReferences.add(new Triple(move1.getFirst(), move1.getSecond(), reference));
            Thread startBranches = new Thread(new Runnable(){

                public void run() {
                    Tuple<Long, Integer> pointsForThisMove = AlphaBeta.getPointsForBoardSituationBranch(theAITemp, currentEnemyTemp, theAITemp, (GameData)quadruple.getForth(), branchesLeftToDo - 1);
                    reference.set(pointsForThisMove);
                }
            });
            threads.add(startBranches);
            startBranches.start();
        }
        for (Thread th : threads) {
            try {
                th.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        ArrayList<Triple<Territory, Territory, Long>> movesWithPoints = new ArrayList<Triple<Territory, Territory, Long>>();
        for (Triple triple : movesWithPointsReferences) {
            movesWithPoints.add(new Triple(triple.getFirst(), triple.getSecond(), (Long)((Tuple)((AtomicReference)triple.getThird()).get()).getFirst() / (long)((Integer)((Tuple)((AtomicReference)triple.getThird()).get()).getSecond()).intValue()));
        }
        return movesWithPoints;
    }

    static Tuple<Long, Integer> getPointsForBoardSituationBranch(PlayerID theAI, PlayerID currentPlayer, PlayerID currentEnemy, GameData data, int branchesLeftToDo) {
        if (branchesLeftToDo > 0) {
            List<Triple<Territory, Territory, Collection<Territory>>> available = AlphaBeta.getAllAvailableMoves(currentPlayer, data, true);
            if (available.isEmpty()) {
                return AlphaBeta.getPointsForBoardSituationBranch(theAI, currentPlayer, currentEnemy, data, -1);
            }
            Tuple<Long, Integer> totalPointsForThisBoardSituation = new Tuple<Long, Integer>(0L, 0);
            for (Triple<Territory, Territory, Collection<Territory>> move1 : available) {
                Quadruple<Territory, Territory, PlayerID, GameData> temp = PlayDelegate.copyGameDataAndAttemptMove((Territory)move1.getFirst(), (Territory)move1.getSecond(), currentPlayer, data);
                PlayerID theAITemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(theAI, temp.getForth());
                PlayerID currentPlayerTemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(currentPlayer, temp.getForth());
                PlayerID currentEnemyTemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(currentEnemy, temp.getForth());
                Tuple<Long, Integer> totalForThisMove = AlphaBeta.getPointsForBoardSituationBranch(theAITemp, currentEnemyTemp, currentPlayerTemp, temp.getForth(), branchesLeftToDo - 1);
                totalPointsForThisBoardSituation = new Tuple<Long, Integer>(totalPointsForThisBoardSituation.getFirst() + totalForThisMove.getFirst(), totalPointsForThisBoardSituation.getSecond() + totalForThisMove.getSecond());
            }
            return totalPointsForThisBoardSituation;
        }
        if (EndTurnDelegate.doWeWin(theAI, data, 1)) {
            return new Tuple<Long, Integer>(400L + AlphaBeta.getPointsForBoardPieces(theAI, data), 1);
        }
        return new Tuple<Long, Integer>(AlphaBeta.getPointsForBoardSituationTotal(theAI, data), 1);
    }

    static long getPointsForBoardSituationTotal(PlayerID theAI, GameData data) {
        long points = 0L;
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (enemy.equals(theAI)) continue;
            boolean enemyInCheck = PlayDelegate.areWeInCheck(enemy, data, 1);
            points += (long)(enemyInCheck ? 5 : 0);
        }
        Collection<Tuple<Territory, List<Tuple<Territory, Territory>>>> capturedPieces = PlayDelegate.whichOfOurPiecesCanBeCaptured(theAI, data);
        for (Tuple<Territory, List<Tuple<Territory, Territory>>> t : capturedPieces) {
            points = (long)((double)points - (double)AlphaBeta.getPointsForUnits(t.getFirst().getUnits().getUnits()) * 0.8);
        }
        return points += AlphaBeta.getPointsForBoardPieces(theAI, data);
    }

    static long getPointsForBoardPieces(PlayerID theAI, GameData data) {
        long points = 0L;
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> unitsOwnedByUs = t.getUnits().getMatches(PlayDelegate.UnitIsOwnedBy(theAI));
            List<Unit> unitsNotOwnedByUs = t.getUnits().getMatches(PlayDelegate.UnitIsOwnedBy(theAI).invert());
            points += (long)AlphaBeta.getPointsForUnits(unitsOwnedByUs);
            points -= (long)AlphaBeta.getPointsForUnits(unitsNotOwnedByUs);
        }
        return points;
    }

    static Comparator<Triple<Territory, Territory, Long>> getBestPointsComparatorLong() {
        return new Comparator<Triple<Territory, Territory, Long>>(){

            @Override
            public int compare(Triple<Territory, Territory, Long> t1, Triple<Territory, Territory, Long> t2) {
                if (t1 == null && t2 == null || t1 == t2) {
                    return 0;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return 0;
                }
                if (t1.getThird().longValue() == t2.getThird().longValue()) {
                    return 0;
                }
                if (t1.getThird() > t2.getThird()) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static void printMovesSet(List<Triple<Territory, Territory, Long>> movesWithPoints) {
        System.out.println("\n\rMoves Available:");
        for (Triple<Territory, Territory, Long> move1 : movesWithPoints) {
            System.out.println(((Territory)move1.getFirst()).getX() + "," + ((Territory)move1.getFirst()).getY() + " -> " + ((Territory)move1.getSecond()).getX() + "," + ((Territory)move1.getSecond()).getY() + "  == " + move1.getThird());
        }
    }

    public static int getAISearchDepthProperty(GameData data) {
        return data.getProperties().get("AI Search Depth", 3);
    }
}

