/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.engine.message.IRemote;
import java.io.Serializable;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationDelegate
extends AbstractDelegate {
    @Override
    public void start() {
        super.start();
        GameData data = this.getData();
        GameMap map = data.getMap();
        int newWidth = data.getProperties().get("Width", map.getXDimension());
        int newHeight = data.getProperties().get("Height", map.getYDimension());
        if (newWidth != map.getXDimension() || newHeight != map.getYDimension()) {
            this.m_bridge.getHistoryWriter().startEvent("Changing Map Dimensions");
            Territory t1 = map.getTerritories().iterator().next();
            String name = t1.getName().substring(0, t1.getName().indexOf("_"));
            this.m_bridge.addChange(ChangeFactory.addGridGameMapChange(map, "square", name, newWidth, newHeight, new HashSet<String>(), "implicit", "implicit", "explicit"));
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        return null;
    }

    @Override
    public void loadState(Serializable state) {
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

