/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.player;

import games.strategy.grid.go.delegate.remote.IGoEndTurnDelegate;
import games.strategy.grid.go.delegate.remote.IGoPlayDelegate;
import games.strategy.grid.go.ui.GoMapPanel;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.IGridPlayData;
import java.util.concurrent.CountDownLatch;

public class GoPlayer
extends GridGamePlayer {
    public GoPlayer(String name, String type) {
        super(name, type);
    }

    protected void play() {
        IGoPlayDelegate playDel;
        try {
            playDel = (IGoPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        }
        catch (ClassCastException e) {
            String errorContext = "PlayerBridge step name: " + this.getPlayerBridge().getStepName() + ", Remote class name: " + this.getPlayerBridge().getRemoteDelegate().getClass();
            System.err.println(errorContext);
            e.printStackTrace();
            throw new IllegalStateException(errorContext, e);
        }
        ((GridGameFrame)this.m_ui).changeActivePlayer(this.getPlayerID());
        GoMapPanel mapPanel = (GoMapPanel)((GridGameFrame)this.m_ui).getMainPanel();
        mapPanel.changePhase(GoMapPanel.GO_DELEGATE_PHASE.PLAY);
        IGridPlayData play = null;
        while (play == null) {
            play = ((GridGameFrame)this.m_ui).waitForPlay(this.getPlayerID(), this.getPlayerBridge());
            if (play == null) {
                return;
            }
            String error = playDel.play(play);
            if (error != null) {
                ((GridGameFrame)this.m_ui).notifyError(error);
                play = null;
                continue;
            }
            ((GridGameFrame)this.m_ui).notifyError("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTurn() {
        IGoEndTurnDelegate endTurnDel;
        try {
            endTurnDel = (IGoEndTurnDelegate)this.getPlayerBridge().getRemoteDelegate();
        }
        catch (ClassCastException e) {
            String errorContext = "PlayerBridge step name: " + this.getPlayerBridge().getStepName() + ", Remote class name: " + this.getPlayerBridge().getRemoteDelegate().getClass();
            System.err.println(errorContext);
            e.printStackTrace();
            throw new IllegalStateException(errorContext, e);
        }
        ((GridGameFrame)this.m_ui).changeActivePlayer(this.getPlayerID());
        GoMapPanel mapPanel = (GoMapPanel)((GridGameFrame)this.m_ui).getMainPanel();
        mapPanel.changePhase(GoMapPanel.GO_DELEGATE_PHASE.ENDGAME);
        IGridEndTurnData endTurnData = null;
        while (endTurnData == null) {
            endTurnData = ((GridGameFrame)this.m_ui).waitForEndTurn(this.getPlayerID(), this.getPlayerBridge());
            if (endTurnData == null) {
                return;
            }
            String error = endTurnDel.territoryAdjustment(endTurnData);
            if (error != null) {
                ((GridGameFrame)this.m_ui).notifyError(error);
                endTurnData = null;
                continue;
            }
            ((GridGameFrame)this.m_ui).notifyError("");
        }
        IGridEndTurnData forumPoster = null;
        CountDownLatch waiting = null;
        try {
            while (forumPoster == null) {
                if (mapPanel == null) {
                    return;
                }
                mapPanel.removeShutdownLatch(waiting);
                waiting = new CountDownLatch(1);
                mapPanel.addShutdownLatch(waiting);
                forumPoster = mapPanel.waitForEndTurnForumPoster(this.getPlayerID(), this.getPlayerBridge(), waiting);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            mapPanel.removeShutdownLatch(waiting);
        }
    }
}

