/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.kingstable.attachments.PlayerAttachment;
import games.strategy.grid.kingstable.delegate.KingsTableInitializationExtendedDelegateState;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationDelegate
extends AbstractDelegate {
    @Override
    public void start() {
        super.start();
        PlayerID attacker = null;
        PlayerID defender = null;
        GameData data = this.getData();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            PlayerAttachment pa = (PlayerAttachment)player.getAttachment("playerAttachment");
            if (pa == null) {
                attacker = player;
                continue;
            }
            if (pa.getNeedsKing()) {
                defender = player;
                continue;
            }
            attacker = player;
        }
        if (attacker == null) {
            throw new RuntimeException("Invalid game setup - no attacker is specified. Reconfigure the game xml file so that one player has a playerAttachment with needsKing set to false.");
        }
        if (defender == null) {
            throw new RuntimeException("Invalid game setup - no defender is specified. Reconfigure the game xml file so that one player has a playerAttachment with needsKing set to true.");
        }
        for (Territory t : data.getMap().getTerritories()) {
            if (t.getUnits().isEmpty()) continue;
            if (t.getUnits().size() <= 1) {
                for (PlayerID owner : t.getUnits().getPlayersWithUnits()) {
                    t.setOwner(owner);
                }
                continue;
            }
            throw new RuntimeException("Territory " + t + " contains more than one unit.");
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        KingsTableInitializationExtendedDelegateState state = new KingsTableInitializationExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        KingsTableInitializationExtendedDelegateState s = (KingsTableInitializationExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

