/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.grid.kingstable.attachments.TerritoryAttachment;
import java.util.Collection;

class Matches {
    private final boolean kingCanParticipateInCaptures;
    private final boolean cornerSquaresCanBeUsedToCapturePawns;
    private final boolean centerSquareCanBeUsedToCapturePawns;
    private final boolean cornerSquaresCanBeUsedToCaptureTheKing;
    private final boolean centerSquareCanBeUsedToCaptureTheKing;
    private final boolean edgeOfBoardCanBeUsedToCaptureTheKing;
    private final boolean kingCanBeCapturedLikeAPawn;

    Matches(GameData gameData) {
        GameProperties properties = gameData.getProperties();
        this.kingCanParticipateInCaptures = properties.get("King can participate in captures", true);
        this.cornerSquaresCanBeUsedToCapturePawns = properties.get("Corner squares can be used to capture pawns", true);
        this.centerSquareCanBeUsedToCapturePawns = properties.get("Center square can be used to capture pawns", false);
        this.cornerSquaresCanBeUsedToCaptureTheKing = properties.get("Corner squares can be used to capture the king", false);
        this.centerSquareCanBeUsedToCaptureTheKing = properties.get("Center square can be used to capture the king", true);
        this.edgeOfBoardCanBeUsedToCaptureTheKing = properties.get("Edge of board can be used to capture the king", false);
        this.kingCanBeCapturedLikeAPawn = properties.get("King can be captured like a pawn", false);
    }

    public boolean kingCanBeCapturedLikeAPawn() {
        return this.kingCanBeCapturedLikeAPawn;
    }

    public boolean kingInSquare(Territory t) {
        if (t == null) {
            return false;
        }
        Collection<Unit> units = t.getUnits().getUnits();
        if (units.isEmpty()) {
            return false;
        }
        Unit unit = (Unit)units.toArray()[0];
        return unit.getType().getName().equals("king");
    }

    public boolean isKingsExit(Territory t) {
        TerritoryAttachment ta = (TerritoryAttachment)t.getAttachment("territoryAttachment");
        if (ta == null) {
            return false;
        }
        return ta.getKingsExit();
    }

    public boolean isKingsSquare(Territory t) {
        TerritoryAttachment ta = (TerritoryAttachment)t.getAttachment("territoryAttachment");
        if (ta == null) {
            return false;
        }
        return ta.getKingsSquare();
    }

    public boolean eligibleParticipantInPawnCapture(PlayerID currentPlayer, Territory territory) {
        if (territory == null) {
            return false;
        }
        if (territory.getOwner().equals(currentPlayer)) {
            if (territory.getUnits().isEmpty()) {
                return false;
            }
            return this.kingCanParticipateInCaptures || !this.kingInSquare(territory);
        }
        if (this.cornerSquaresCanBeUsedToCapturePawns && this.isKingsExit(territory)) {
            return true;
        }
        return this.centerSquareCanBeUsedToCapturePawns && this.isKingsSquare(territory);
    }

    public boolean eligibleParticipantInKingCapture(PlayerID currentPlayer, Territory territory) {
        if (territory == null) {
            return this.edgeOfBoardCanBeUsedToCaptureTheKing;
        }
        if (territory.getOwner().equals(currentPlayer)) {
            return territory.getUnits().size() > 0;
        }
        if (this.cornerSquaresCanBeUsedToCaptureTheKing && this.isKingsExit(territory)) {
            return true;
        }
        return this.centerSquareCanBeUsedToCaptureTheKing && this.isKingsSquare(territory);
    }

    public boolean eligibleParticipantsInKingCapture(PlayerID currentPlayer, Territory ... territories) {
        if (territories == null || territories.length == 0) {
            return false;
        }
        for (Territory territory : territories) {
            if (this.eligibleParticipantInKingCapture(currentPlayer, territory)) continue;
            return false;
        }
        return true;
    }

    public boolean eligibleForCapture(Territory territory, PlayerID currentPlayer) {
        return territory != null && !territory.getUnits().isEmpty() && !territory.getOwner().equals(currentPlayer);
    }
}

