/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.kingstable.delegate.KingsTablePlayExtendedDelegateState;
import games.strategy.grid.kingstable.delegate.Matches;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AutoSave(beforeStepStart=false, afterStepEnd=true)
public class PlayDelegate
extends AbstractDelegate
implements IGridPlayDelegate {
    private Matches matches = null;

    @Override
    public void start() {
        super.start();
        if (this.matches == null) {
            this.matches = new Matches(this.getData());
        }
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        KingsTablePlayExtendedDelegateState state = new KingsTablePlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        KingsTablePlayExtendedDelegateState s = (KingsTablePlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public String play(IGridPlayData play) {
        Territory end;
        Territory start = play.getStart();
        String error = PlayDelegate.isValidPlay(start, end = play.getEnd(), this.m_player, this.getData());
        if (error != null) {
            return error;
        }
        Collection<Territory> captured = PlayDelegate.checkForCaptures(end, this.m_player, this.getData());
        this.performPlay(start, end, captured, this.m_player);
        return null;
    }

    public static Collection<Territory> checkForCaptures(Territory end, PlayerID player, GameData data) {
        Matches matches = new Matches(data);
        HashSet<Territory> captured = new HashSet<Territory>(4);
        if (end != null) {
            Territory below;
            Territory above;
            Territory right;
            Territory left;
            int endX = end.getX();
            int endY = end.getY();
            GameMap map = data.getMap();
            Territory possibleCapture = map.getTerritoryFromCoordinates(endX, endY - 1);
            if (matches.eligibleForCapture(possibleCapture, player)) {
                Territory above2 = map.getTerritoryFromCoordinates(endX, endY - 2);
                if (matches.kingInSquare(possibleCapture)) {
                    left = map.getTerritoryFromCoordinates(endX - 1, endY - 1);
                    if (matches.eligibleParticipantsInKingCapture(player, above2, left, right = map.getTerritoryFromCoordinates(endX + 1, endY - 1))) {
                        captured.add(possibleCapture);
                    } else if (matches.kingCanBeCapturedLikeAPawn() && matches.eligibleParticipantInPawnCapture(player, above2)) {
                        captured.add(possibleCapture);
                    }
                } else if (matches.eligibleParticipantInPawnCapture(player, above2)) {
                    captured.add(possibleCapture);
                }
            }
            if (matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX, endY + 1), player)) {
                Territory below2 = map.getTerritoryFromCoordinates(endX, endY + 2);
                if (matches.kingInSquare(possibleCapture)) {
                    left = map.getTerritoryFromCoordinates(endX - 1, endY + 1);
                    if (matches.eligibleParticipantsInKingCapture(player, below2, left, right = map.getTerritoryFromCoordinates(endX + 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (matches.kingCanBeCapturedLikeAPawn() && matches.eligibleParticipantInPawnCapture(player, below2)) {
                        captured.add(possibleCapture);
                    }
                } else if (matches.eligibleParticipantInPawnCapture(player, below2)) {
                    captured.add(possibleCapture);
                }
            }
            if (matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX - 1, endY), player)) {
                Territory left2 = map.getTerritoryFromCoordinates(endX - 2, endY);
                if (matches.kingInSquare(possibleCapture)) {
                    above = map.getTerritoryFromCoordinates(endX - 1, endY - 1);
                    if (matches.eligibleParticipantsInKingCapture(player, left2, above, below = map.getTerritoryFromCoordinates(endX - 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (matches.kingCanBeCapturedLikeAPawn() && matches.eligibleParticipantInPawnCapture(player, left2)) {
                        captured.add(possibleCapture);
                    }
                } else if (matches.eligibleParticipantInPawnCapture(player, left2)) {
                    captured.add(possibleCapture);
                }
            }
            if (matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX + 1, endY), player)) {
                Territory right2 = map.getTerritoryFromCoordinates(endX + 2, endY);
                if (matches.kingInSquare(possibleCapture)) {
                    above = map.getTerritoryFromCoordinates(endX + 1, endY - 1);
                    if (matches.eligibleParticipantsInKingCapture(player, right2, above, below = map.getTerritoryFromCoordinates(endX + 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (matches.kingCanBeCapturedLikeAPawn() && matches.eligibleParticipantInPawnCapture(player, right2)) {
                        captured.add(possibleCapture);
                    }
                } else if (matches.eligibleParticipantInPawnCapture(player, right2)) {
                    captured.add(possibleCapture);
                }
            }
        }
        return captured;
    }

    public static String isValidPlay(Territory start, Territory end, PlayerID player, GameData data) {
        Matches matches;
        int unitCount = start.getUnits().getUnitCount(player);
        if (unitCount < 1) {
            return player.getName() + " doesn't have a piece in the selected starting square.";
        }
        if (unitCount > 1) {
            return "The selected starting square contains more than one piece - that shouldn't be possible.";
        }
        if (!end.getUnits().isEmpty()) {
            return "The selected destination square is not empty";
        }
        int startX = start.getX();
        int endX = end.getX();
        int startY = start.getY();
        int endY = end.getY();
        GameMap map = data.getMap();
        if (startX == endX) {
            int y2;
            int y1;
            if (startY < endY) {
                y1 = startY + 1;
                y2 = endY - 1;
            } else {
                y1 = endY + 1;
                y2 = startY - 1;
            }
            int y = y1;
            while (y <= y2) {
                Territory at;
                if ((at = map.getTerritoryFromCoordinates(startX, y++)).getUnits().size() <= 0) continue;
                return "Pieces can only move through empty spaces.";
            }
        } else if (startY == endY) {
            int x2;
            int x1;
            if (startX < endX) {
                x1 = startX + 1;
                x2 = endX - 1;
            } else {
                x1 = endX + 1;
                x2 = startX - 1;
            }
            int x = x1;
            while (x <= x2) {
                Territory at;
                if ((at = map.getTerritoryFromCoordinates(x++, startY)).getUnits().size() <= 0) continue;
                return "Intervening square (" + x + "," + startY + ") is not empty.";
            }
        } else {
            return "Pieces can only move in a straight line.";
        }
        if (!(matches = new Matches(data)).kingInSquare(start) && matches.isKingsSquare(end)) {
            return "Only the king can go there";
        }
        return null;
    }

    private void performPlay(Territory start, Territory end, Collection<Territory> captured, PlayerID player) {
        Collection<Unit> units = start.getUnits().getUnits();
        String transcriptText = player.getName() + " moved from " + start.getName() + " to " + end.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, units);
        Change removeUnit = ChangeFactory.removeUnits(start, units);
        Change removeStartOwner = ChangeFactory.changeOwner(start, PlayerID.NULL_PLAYERID);
        Change addUnit = ChangeFactory.addUnits(end, units);
        Change addEndOwner = ChangeFactory.changeOwner(end, player);
        CompositeChange change = new CompositeChange();
        change.add(removeUnit);
        change.add(removeStartOwner);
        change.add(addUnit);
        change.add(addEndOwner);
        for (Territory at : captured) {
            if (at == null) continue;
            Collection<Unit> capturedUnits = at.getUnits().getUnits();
            Change capture = ChangeFactory.removeUnits(at, capturedUnits);
            change.add(capture);
            Change removeOwner = ChangeFactory.changeOwner(at, PlayerID.NULL_PLAYERID);
            change.add(removeOwner);
        }
        this.m_bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        HashSet<Territory> refresh = new HashSet<Territory>();
        refresh.add(start);
        refresh.add(end);
        refresh.addAll(captured);
        display.refreshTerritories(refresh);
        display.showGridPlayDataMove(new GridPlayData(start, end, player));
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridPlayDelegate.class;
    }
}

