/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.player;

import games.strategy.common.player.ai.AIAlgorithm;
import games.strategy.common.player.ai.GameState;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.kingstable.attachments.PlayerAttachment;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridPlayData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BetterAI
extends GridAbstractAI {
    private int m_xDimension;
    private int m_yDimension;
    private boolean m_kingPlayer;
    private PlayerID m_opponent;
    private final Algorithm algorithm;
    private int cutoffDepth = 2;
    public static int counter = 0;

    public BetterAI(String name, String type, Algorithm algorithm) {
        super(name, type);
        this.algorithm = algorithm;
    }

    public void initialize(IPlayerBridge bridge, PlayerID id) {
        super.initialize(bridge, id);
        this.m_xDimension = this.getGameData().getMap().getXDimension();
        this.m_yDimension = this.getGameData().getMap().getYDimension();
        PlayerAttachment pa = (PlayerAttachment)id.getAttachment("playerAttachment");
        if (pa != null) {
            if (pa.getNeedsKing()) {
                this.m_kingPlayer = true;
            }
            this.cutoffDepth = pa.getAlphaBetaSearchDepth();
        } else {
            this.m_kingPlayer = false;
        }
        this.m_opponent = null;
        for (PlayerID p : this.getGameData().getPlayerList().getPlayers()) {
            if (p.equals(id) || p.equals(PlayerID.NULL_PLAYERID)) continue;
            this.m_opponent = p;
            break;
        }
    }

    protected void play() {
        State initial_state = this.getInitialState();
        try {
            Move move = this.algorithm.equals((Object)Algorithm.ALPHABETA) ? AIAlgorithm.alphaBetaSearch(initial_state) : AIAlgorithm.minimaxSearch(initial_state);
            IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
            PlayerID me = this.getPlayerID();
            Territory start = this.getGameData().getMap().getTerritoryFromCoordinates(move.getStart().getFirst(), move.getStart().getSecond());
            Territory end = this.getGameData().getMap().getTerritoryFromCoordinates(move.getEnd().getFirst(), move.getEnd().getSecond());
            GridPlayData play = new GridPlayData(start, end, me);
            playDel.play(play);
        }
        catch (OutOfMemoryError e) {
            System.out.println("Ran out of memory while searching for next move: " + counter + " moves examined.");
            System.exit(-1);
        }
    }

    private State getInitialState() {
        return new State(this.getGameData().getMap().getTerritories());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<First, Second> {
        private final First m_first;
        private final Second m_second;

        Pair(First first, Second second) {
            this.m_first = first;
            this.m_second = second;
        }

        First getFirst() {
            return this.m_first;
        }

        Second getSecond() {
            return this.m_second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Move {
        private final Pair<Integer, Integer> m_start;
        private final Pair<Integer, Integer> m_end;

        public Move(Pair<Integer, Integer> start, Pair<Integer, Integer> end) {
            this.m_start = start;
            this.m_end = end;
        }

        public Pair<Integer, Integer> getStart() {
            return this.m_start;
        }

        public Pair<Integer, Integer> getEnd() {
            return this.m_end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class State
    extends GameState<Move> {
        private final HashMap<Integer, PlayerID> squareOwner;
        private int m_kingX = -1;
        private int m_kingY = -1;
        private final int m_depth;
        private final Move m_move;
        private final PlayerID m_playerPerformingMove;
        private final PlayerID m_otherPlayer;

        public State(Collection<Territory> territories) {
            this.m_depth = 0;
            this.m_move = null;
            this.m_playerPerformingMove = BetterAI.this.m_opponent;
            this.m_otherPlayer = BetterAI.this.getPlayerID();
            this.squareOwner = new HashMap(BetterAI.this.m_xDimension * BetterAI.this.m_yDimension);
            for (Territory t : territories) {
                Unit unit;
                this.squareOwner.put(t.getX() * BetterAI.this.m_xDimension + t.getY(), t.getOwner());
                if (t.getUnits().isEmpty() || !(unit = (Unit)t.getUnits().getUnits().toArray()[0]).getType().getName().equals("king")) continue;
                this.m_kingX = t.getX();
                this.m_kingY = t.getY();
            }
        }

        public State getSuccessor(Move move) {
            return new State(move, this);
        }

        @Override
        public Move getMove() {
            return this.m_move;
        }

        private State(Move move, State parentState) {
            this.m_move = move;
            this.m_depth = parentState.m_depth + 1;
            ++counter;
            int startX = move.getStart().getFirst();
            int startY = move.getStart().getSecond();
            int endX = move.getEnd().getFirst();
            int endY = move.getEnd().getSecond();
            if (startX == parentState.m_kingX && startY == parentState.m_kingY) {
                this.m_kingX = endX;
                this.m_kingY = endY;
            } else {
                this.m_kingX = parentState.m_kingX;
                this.m_kingY = parentState.m_kingY;
            }
            if (parentState.m_depth % 2 == 0) {
                this.m_playerPerformingMove = BetterAI.this.getPlayerID();
                this.m_otherPlayer = BetterAI.this.m_opponent;
            } else {
                this.m_playerPerformingMove = BetterAI.this.m_opponent;
                this.m_otherPlayer = BetterAI.this.getPlayerID();
            }
            this.squareOwner = new HashMap(parentState.squareOwner.size());
            for (Map.Entry<Integer, PlayerID> s : parentState.squareOwner.entrySet()) {
                this.squareOwner.put(s.getKey(), s.getValue());
            }
            this.squareOwner.put(move.getStart().getFirst() * BetterAI.this.m_xDimension + move.getStart().getSecond(), PlayerID.NULL_PLAYERID);
            this.squareOwner.put(move.getEnd().getFirst() * BetterAI.this.m_xDimension + move.getEnd().getSecond(), this.m_playerPerformingMove);
            this.checkForCaptures(move.getEnd().getFirst(), move.getEnd().getSecond());
        }

        private void checkForCaptures(int endX, int endY) {
            for (Map.Entry<Integer, PlayerID> s : this.squareOwner.entrySet()) {
                PlayerID left;
                PlayerID below;
                PlayerID above;
                int squareX = s.getKey() / BetterAI.this.m_xDimension;
                int squareY = s.getKey() % BetterAI.this.m_xDimension;
                PlayerID s_owner = s.getValue();
                if (!s_owner.equals(this.m_otherPlayer)) continue;
                if (squareX == endX) {
                    PlayerID below2;
                    PlayerID right;
                    PlayerID left2;
                    if (squareY == endY + 1) {
                        PlayerID above2 = this.get(endX, endY + 2);
                        if (above2 != null && above2.equals(this.m_playerPerformingMove)) {
                            if (squareX == this.m_kingX && squareY == this.m_kingY) {
                                left2 = this.get(endX - 1, endY + 1);
                                right = this.get(endX + 1, endY + 1);
                                if (left2 != null && right != null && left2.equals(this.m_playerPerformingMove) && right.equals(this.m_playerPerformingMove)) {
                                    this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                                    this.m_kingX = -1;
                                    this.m_kingY = -1;
                                }
                            } else {
                                this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                            }
                        }
                    } else if (squareY == endY - 1 && (below2 = this.get(endX, endY - 2)) != null && below2.equals(this.m_playerPerformingMove)) {
                        if (squareX == this.m_kingX && squareY == this.m_kingY) {
                            System.out.println("Possible king capture with king at (" + squareX + "," + squareY + ")");
                            left2 = this.get(endX - 1, endY - 1);
                            right = this.get(endX + 1, endY - 1);
                            if (left2 != null && right != null && left2.equals(this.m_playerPerformingMove) && right.equals(this.m_playerPerformingMove)) {
                                this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                                this.m_kingX = -1;
                                this.m_kingY = -1;
                            }
                        } else {
                            this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                        }
                    }
                }
                if (endY != squareY) continue;
                if (squareX == endX + 1) {
                    PlayerID right = this.get(endX + 2, endY);
                    if (right == null || !right.equals(this.m_playerPerformingMove)) continue;
                    if (squareX == this.m_kingX && squareY == this.m_kingY) {
                        System.out.println("Possible king capture with king at (" + squareX + "," + squareY + ")");
                        above = this.get(endX + 1, endY - 1);
                        below = this.get(endX + 1, endY + 1);
                        if (above == null || below == null || !above.equals(this.m_playerPerformingMove) || !below.equals(this.m_playerPerformingMove)) continue;
                        this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                        this.m_kingX = -1;
                        this.m_kingY = -1;
                        continue;
                    }
                    this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                    continue;
                }
                if (squareX != endX - 1 || (left = this.get(endX - 2, endY)) == null || !left.equals(this.m_playerPerformingMove)) continue;
                if (squareX == this.m_kingX && squareY == this.m_kingY) {
                    System.out.println("Possible king capture with king at (" + squareX + "," + squareY + ")");
                    above = this.get(endX - 1, endY - 1);
                    below = this.get(endX - 1, endY + 1);
                    if (above == null || below == null || !above.equals(this.m_playerPerformingMove) || !below.equals(this.m_playerPerformingMove)) continue;
                    this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
                    this.m_kingX = -1;
                    this.m_kingY = -1;
                    continue;
                }
                this.squareOwner.put(squareX * BetterAI.this.m_xDimension + squareY, PlayerID.NULL_PLAYERID);
            }
        }

        private boolean isKingsSquare(int x, int y) {
            if (x == 5 && y == 5) {
                return true;
            }
            return x == 0 && (y == 0 || y == BetterAI.this.m_yDimension - 1) || x == BetterAI.this.m_xDimension - 1 && (y == 0 || y == BetterAI.this.m_yDimension - 1);
        }

        @Override
        public Collection<GameState<Move>> successors() {
            PlayerID successorPlayer = this.m_otherPlayer;
            ArrayList<GameState<Move>> successors = new ArrayList<GameState<Move>>();
            int countCurrentPlayerPieces = 0;
            for (Map.Entry<Integer, PlayerID> start : this.squareOwner.entrySet()) {
                int y;
                Move move;
                PlayerID destination;
                int x;
                PlayerID s_owner = start.getValue();
                if (!successorPlayer.equals(s_owner)) continue;
                ++countCurrentPlayerPieces;
                int startX = start.getKey() / BetterAI.this.m_xDimension;
                int startY = start.getKey() % BetterAI.this.m_xDimension;
                boolean kingIsMoving = startX == this.m_kingX && startY == this.m_kingY;
                for (x = startX - 1; x >= 0 && (destination = this.get(x, startY)).equals(PlayerID.NULL_PLAYERID); --x) {
                    if (!kingIsMoving && this.isKingsSquare(x, startY)) continue;
                    move = new Move(new Pair<Integer, Integer>(startX, startY), new Pair<Integer, Integer>(x, startY));
                    successors.add(new State(move, this));
                }
                for (x = startX + 1; x < BetterAI.this.m_xDimension && (destination = this.get(x, startY)).equals(PlayerID.NULL_PLAYERID); ++x) {
                    if (!kingIsMoving && this.isKingsSquare(x, startY)) continue;
                    move = new Move(new Pair<Integer, Integer>(startX, startY), new Pair<Integer, Integer>(x, startY));
                    successors.add(new State(move, this));
                }
                for (y = startY - 1; y >= 0 && (destination = this.get(startX, y)).equals(PlayerID.NULL_PLAYERID); --y) {
                    if (!kingIsMoving && this.isKingsSquare(startX, y)) continue;
                    move = new Move(new Pair<Integer, Integer>(startX, startY), new Pair<Integer, Integer>(startX, y));
                    successors.add(new State(move, this));
                }
                for (y = startY + 1; y < BetterAI.this.m_yDimension && (destination = this.get(startX, y)).equals(PlayerID.NULL_PLAYERID); ++y) {
                    if (!kingIsMoving && this.isKingsSquare(startX, y)) continue;
                    move = new Move(new Pair<Integer, Integer>(startX, startY), new Pair<Integer, Integer>(startX, y));
                    successors.add(new State(move, this));
                }
            }
            return successors;
        }

        public PlayerID get(int x, int y) {
            return this.squareOwner.get(BetterAI.this.m_xDimension * x + y);
        }

        @Override
        public float getUtility() {
            if (this.m_kingX == -1 || this.m_kingY == -1) {
                if (BetterAI.this.m_kingPlayer) {
                    return -2.1474836E9f;
                }
                return 2.1474836E9f;
            }
            if (this.m_kingX == 0 && (this.m_kingY == 0 || this.m_kingY == BetterAI.this.m_yDimension - 1) || this.m_kingX == BetterAI.this.m_xDimension - 1 && (this.m_kingY == 0 || this.m_kingY == BetterAI.this.m_yDimension - 1)) {
                if (BetterAI.this.m_kingPlayer) {
                    return 2.1474836E9f;
                }
                return -2.1474836E9f;
            }
            float numPieces = 0.0f;
            float numOpponentPieces = 0.0f;
            for (PlayerID p : this.squareOwner.values()) {
                if (p.equals(PlayerID.NULL_PLAYERID)) continue;
                if (p.equals(BetterAI.this.getPlayerID())) {
                    numPieces = (float)((double)numPieces + 1.0);
                    continue;
                }
                numOpponentPieces = (float)((double)numOpponentPieces + 1.0);
            }
            if (numPieces == 0.0f) {
                return -2.1474836E9f;
            }
            if (numOpponentPieces == 0.0f) {
                return 2.1474836E9f;
            }
            return numPieces / numOpponentPieces;
        }

        @Override
        public boolean gameIsOver() {
            return this.m_kingX == -1 || this.m_kingY == -1 || this.m_kingX == 0 && (this.m_kingY == 0 || this.m_kingY == BetterAI.this.m_yDimension - 1) || this.m_kingX == BetterAI.this.m_xDimension - 1 && (this.m_kingY == 0 || this.m_kingY == BetterAI.this.m_yDimension - 1);
        }

        @Override
        public boolean cutoffTest() {
            if (this.gameIsOver()) {
                return true;
            }
            return this.m_depth >= BetterAI.this.cutoffDepth;
        }

        public Iterator<PlayerID> iterator() {
            return this.squareOwner.values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        MINIMAX,
        ALPHABETA;

    }
}

