/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.grid.kingstable.attachments.TerritoryAttachment;
import games.strategy.grid.kingstable.delegate.PlayDelegate;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.ui.ImageScrollModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KingsTableMapPanel
extends GridMapPanel {
    private static final long serialVersionUID = 9111624780451084800L;

    public KingsTableMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(data, mapData, parentGridGameFrame, imageScrollModel);
    }

    @Override
    protected String isValidPlay(IGridPlayData play) {
        return PlayDelegate.isValidPlay(play.getStart(), play.getEnd(), this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
    }

    @Override
    protected Collection<Territory> getCapturesForPlay(IGridPlayData play) {
        return PlayDelegate.checkForCaptures(play.getEnd(), this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
    }

    @Override
    protected void paintComponentMiddleLayer(Graphics2D g2d, int topLeftX, int topLeftY) {
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
        g2d.setColor(Color.white);
        g2d.fillRect(this.m_mapData.getBevelWidth(), this.m_mapData.getBevelHeight(), this.m_model.getMaxWidth() - this.m_mapData.getBevelWidth() * 2, this.m_model.getMaxHeight() - this.m_mapData.getBevelHeight() * 2);
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            Color backgroundColor = Color.WHITE;
            TerritoryAttachment ta = (TerritoryAttachment)at.getAttachment("territoryAttachment");
            if (ta != null) {
                if (ta.getKingsExit()) {
                    backgroundColor = new Color(225, 225, 255);
                } else if (ta.getKingsSquare()) {
                    backgroundColor = new Color(235, 235, 235);
                }
                g2d.setColor(backgroundColor);
                g2d.fillPolygon(p);
            }
            g2d.setColor(Color.black);
            Image image = (Image)this.m_images.get(at);
            if (image != null) {
                Rectangle square = p.getBounds();
                if (at.equals(this.m_clickedAt)) {
                    g2d.drawImage(image, square.x - this.m_mapData.getSquareWidth() / 5, square.y - this.m_mapData.getSquareHeight() / 5, square.width + 2 * this.m_mapData.getSquareWidth() / 5, square.height + 2 * this.m_mapData.getSquareHeight() / 5, null, null);
                } else {
                    g2d.drawImage(image, square.x, square.y, square.width, square.height, null, null);
                }
            }
            g2d.drawPolygon(p);
        }
    }
}

