/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.player;

import games.strategy.common.player.AbstractHumanPlayer;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.grid.delegate.remote.IGridEditDelegate;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.IGridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.IGridPlayData;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridGamePlayer
extends AbstractHumanPlayer<GridGameFrame>
implements IGridGamePlayer {
    private final AbstractAction m_editModeAction = new AbstractAction(){
        private static final long serialVersionUID = -6514835498581811786L;

        public void actionPerformed(ActionEvent ae) {
            boolean editMode = ((ButtonModel)ae.getSource()).isSelected();
            try {
                IGridEditDelegate editDelegate = (IGridEditDelegate)GridGamePlayer.this.getPlayerBridge().getRemotePersistentDelegate("edit");
                editDelegate.setEditMode(editMode);
            }
            catch (Exception e) {
                e.printStackTrace();
                ((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().setSelected(!((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().isSelected());
            }
        }
    };

    public GridGamePlayer(String name, String type) {
        super(name, type);
    }

    @Override
    public void start(String stepName) {
        if (this.m_ui != null && ((GridGameFrame)this.m_ui).isGameOver()) {
            return;
        }
        super.start(stepName);
        this.enableEditModeMenu();
        boolean badStep = false;
        if (stepName.endsWith("Play")) {
            this.play();
        } else if (stepName.endsWith("EndTurn")) {
            this.endTurn();
        } else {
            badStep = true;
        }
        this.disableEditModeMenu();
        if (badStep) {
            throw new IllegalArgumentException("Unrecognized step stepName:" + stepName);
        }
    }

    protected void play() {
        IGridPlayDelegate playDel;
        ((GridGameFrame)this.m_ui).changeActivePlayer(this.getPlayerID());
        try {
            playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        }
        catch (ClassCastException e) {
            String errorContext = "PlayerBridge step name: " + this.getPlayerBridge().getStepName() + ", Remote class name: " + this.getPlayerBridge().getRemoteDelegate().getClass();
            System.err.println(errorContext);
            e.printStackTrace();
            throw new IllegalStateException(errorContext, e);
        }
        IGridPlayData play = null;
        while (play == null) {
            play = ((GridGameFrame)this.m_ui).waitForPlay(this.getPlayerID(), this.getPlayerBridge());
            if (play == null) {
                return;
            }
            String error = playDel.play(play);
            if (error != null) {
                ((GridGameFrame)this.m_ui).notifyError(error);
                play = null;
                continue;
            }
            ((GridGameFrame)this.m_ui).notifyError("");
        }
    }

    protected void endTurn() {
        ((GridGameFrame)this.m_ui).changeActivePlayer(this.getPlayerID());
        ((GridGameFrame)this.m_ui).waitForEndTurn(this.getPlayerID(), this.getPlayerBridge());
    }

    @Override
    public UnitType selectUnit(Unit startUnit, Collection<UnitType> options, Territory territory, PlayerID player, GameData data, String message) {
        return ((GridGameFrame)this.m_ui).selectUnit(startUnit, options, territory, player, data, message);
    }

    private void enableEditModeMenu() {
        try {
            ((GridGameFrame)this.m_ui).setEditDelegate((IGridEditDelegate)this.getPlayerBridge().getRemotePersistentDelegate("edit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().addActionListener(GridGamePlayer.this.m_editModeAction);
                ((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().setEnabled(true);
            }
        });
    }

    private void disableEditModeMenu() {
        ((GridGameFrame)this.m_ui).setEditDelegate(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().setEnabled(false);
                ((GridGameFrame)GridGamePlayer.this.m_ui).getEditModeButtonModel().removeActionListener(GridGamePlayer.this.m_editModeAction);
            }
        });
    }
}

