/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.common.ui.BasicGameMenuBar;
import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.chat.PlayerChatRenderer;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.HistorySynchronizer;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.grid.delegate.remote.IGridEditDelegate;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridHistoryDetailsPanel;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.UnitCellRenderer;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.triplea.ui.history.HistoryPanel;
import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.Util;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridGameFrame
extends MainGameFrame {
    private static final long serialVersionUID = -8888229639450608930L;
    protected GameData m_data;
    protected IGame m_game;
    protected final GridMapData m_mapData;
    protected GridMapPanel m_mapPanel;
    protected GridGameMenu<GridGameFrame> m_menuBar;
    protected JLabel m_status;
    protected JLabel m_error;
    protected boolean m_gameOver = false;
    protected CountDownLatch m_waiting = null;
    protected PlayerID m_currentPlayer = PlayerID.NULL_PLAYERID;
    protected IGridEditDelegate m_editDelegate;
    private final ButtonModel m_editModeButtonModel;
    protected JPanel m_gameMainPanel = new JPanel();
    protected JPanel m_gameSouthPanel;
    protected JPanel m_rightHandSidePanel = new JPanel();
    protected JPanel m_mapAndChatPanel;
    protected ChatPanel m_chatPanel;
    protected JSplitPane m_chatSplit;
    protected JSplitPane m_gameCenterPanel;
    protected HistoryPanel m_historyPanel;
    protected boolean m_inHistory = false;
    protected boolean m_inGame = true;
    protected HistorySynchronizer m_historySyncher;
    protected JPanel m_historyComponent = new JPanel();
    protected final AbstractAction m_showHistoryAction = new AbstractAction("Show history"){
        private static final long serialVersionUID = -7099175363241411428L;

        public void actionPerformed(ActionEvent e) {
            GridGameFrame.this.showHistory();
            GridGameFrame.this.m_showGameAction.setEnabled(true);
            this.setEnabled(false);
            GridGameFrame.this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        }
    };
    protected final AbstractAction m_showGameAction = new AbstractAction("Show current game"){
        private static final long serialVersionUID = 7470409812651698208L;
        {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GridGameFrame.this.showGame();
            GridGameFrame.this.m_showHistoryAction.setEnabled(true);
            this.setEnabled(false);
            GridGameFrame.this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        }
    };
    protected final AbstractAction m_saveScreenshotAction = new AbstractAction("Export Screenshot..."){
        private static final long serialVersionUID = -5908032486008953815L;

        public void actionPerformed(ActionEvent e) {
            HistoryNode curNode = null;
            curNode = GridGameFrame.this.m_historyPanel == null ? GridGameFrame.this.m_data.getHistory().getLastNode() : GridGameFrame.this.m_historyPanel.getCurrentNode();
            GridGameFrame.this.saveScreenshot(curNode, GridGameFrame.this.m_data);
        }
    };
    final KeyListener m_arrowKeyActionListener = new KeyListener(){
        final int diffPixel = 50;

        public void keyPressed(KeyEvent e) {
            int x = GridGameFrame.this.m_mapPanel.getXOffset();
            int y = GridGameFrame.this.m_mapPanel.getYOffset();
            int keyCode = e.getKeyCode();
            if (keyCode == 39 || keyCode == 68) {
                GridGameFrame.this.m_mapPanel.setTopLeft(x + 50, y);
            } else if (keyCode == 37 || keyCode == 65) {
                GridGameFrame.this.m_mapPanel.setTopLeft(x - 50, y);
            } else if (keyCode == 40 || keyCode == 83) {
                GridGameFrame.this.m_mapPanel.setTopLeft(x, y + 50);
            } else if (keyCode == 38 || keyCode == 87) {
                GridGameFrame.this.m_mapPanel.setTopLeft(x, y - 50);
            }
            if (keyCode == 78) {
                GridGameFrame.this.minimizeRightSidePanel();
            }
            if (keyCode == 77) {
                GridGameFrame.this.maximizeRightSidePanel();
            }
            GridGameFrame.this.m_mapPanel.doKeyListenerEvents(e);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    GameDataChangeListener m_dataChangeListener = new GameDataChangeListener(){

        public void gameDataChanged(Change change) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (GridGameFrame.this.getEditMode()) {
                            GridGameFrame.this.showEditMode();
                        } else {
                            GridGameFrame.this.hideEditMode();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public GridGameFrame(IGame game, LocalPlayers players, Class<? extends GridMapPanel> gridMapPanelClass, Class<? extends GridMapData> gridMapDataClass, Class<? extends GridGameMenu<GridGameFrame>> menuBarClass, int squareWidth, int squareHeight, int bevelSize) {
        super("TripleA - " + game.getData().getGameName(), players);
        this.m_game = game;
        this.m_data = game.getData();
        int x_dim = this.m_data.getMap().getXDimension();
        int y_dim = this.m_data.getMap().getYDimension();
        try {
            GridMapData gridMapData;
            Constructor<? extends GridMapData> mapDataConstructor = gridMapDataClass.getConstructor(GameMap.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.m_mapData = gridMapData = mapDataConstructor.newInstance(this.m_data.getMap(), x_dim, y_dim, squareWidth, squareHeight, bevelSize, bevelSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not initalize map data for: " + gridMapDataClass);
        }
        ImageScrollModel model = new ImageScrollModel();
        model.setScrollX(false);
        model.setScrollY(false);
        model.setMaxBounds(this.m_mapData.getMapDimensions().width, this.m_mapData.getMapDimensions().height);
        try {
            GridMapPanel gridMapPanel;
            Constructor<? extends GridMapPanel> mapPanelConstructor = gridMapPanelClass.getConstructor(GameData.class, GridMapData.class, GridGameFrame.class, ImageScrollModel.class);
            this.m_mapPanel = gridMapPanel = mapPanelConstructor.newInstance(this.m_data, this.m_mapData, this, model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not initalize map panel for: " + gridMapPanelClass);
        }
        this.addKeyListener(this.m_arrowKeyActionListener);
        this.m_mapPanel.addKeyListener(this.m_arrowKeyActionListener);
        this.m_status = new JLabel("Some Text To Set A Reasonable preferred Size");
        this.m_status.setAlignmentX(0.5f);
        this.m_status.setPreferredSize(this.m_status.getPreferredSize());
        this.m_status.setText(" ");
        this.m_error = new JLabel("Some Text To Set A Reasonable preferred Size");
        this.m_error.setAlignmentX(0.5f);
        this.m_error.setPreferredSize(this.m_error.getPreferredSize());
        this.m_error.setText(" ");
        this.m_editModeButtonModel = new JToggleButton.ToggleButtonModel();
        this.m_editModeButtonModel.setEnabled(false);
        this.m_mapAndChatPanel = new JPanel();
        this.m_mapAndChatPanel.setLayout(new BorderLayout());
        this.m_chatSplit = new JSplitPane();
        this.m_chatSplit.setOrientation(0);
        this.m_chatSplit.setOneTouchExpandable(true);
        this.m_chatSplit.setDividerSize(8);
        this.m_chatSplit.setResizeWeight(0.95);
        if (MainFrame.getInstance() != null && MainFrame.getInstance().getChat() != null) {
            this.m_chatPanel = new ChatPanel(MainFrame.getInstance().getChat());
            this.m_chatPanel.setPlayerRenderer(new PlayerChatRenderer(this.m_game, null));
            Dimension chatPrefSize = new Dimension((int)this.m_chatPanel.getPreferredSize().getWidth(), 95);
            this.m_chatPanel.setPreferredSize(chatPrefSize);
            this.m_chatSplit.setTopComponent(this.m_mapPanel);
            this.m_chatSplit.setBottomComponent(this.m_chatPanel);
            this.m_mapAndChatPanel.add((Component)this.m_chatSplit, "Center");
        } else {
            this.m_mapAndChatPanel.add((Component)this.m_mapPanel, "Center");
        }
        this.m_gameMainPanel.setLayout(new BorderLayout());
        this.m_gameMainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.m_gameSouthPanel = new JPanel();
        this.m_gameSouthPanel.setLayout(new BoxLayout(this.m_gameSouthPanel, 1));
        this.m_gameSouthPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.m_gameSouthPanel.add(this.m_status);
        this.m_gameSouthPanel.add(this.m_error);
        this.m_gameMainPanel.add((Component)this.m_gameSouthPanel, "South");
        this.m_rightHandSidePanel.setLayout(new BorderLayout());
        Dimension rightSidePanel = new Dimension(200, 200);
        this.m_rightHandSidePanel.setPreferredSize(rightSidePanel);
        this.m_gameCenterPanel = new JSplitPane(1, this.m_mapAndChatPanel, this.m_rightHandSidePanel);
        this.m_gameCenterPanel.setOneTouchExpandable(true);
        this.m_gameCenterPanel.setDividerSize(8);
        this.m_gameCenterPanel.setResizeWeight(1.0);
        this.m_gameMainPanel.add((Component)this.m_gameCenterPanel, "Center");
        this.m_gameCenterPanel.resetToPreferredSizes();
        this.setGlassPane(new JComponent(){
            private static final long serialVersionUID = 9077566112856052017L;

            protected void paintComponent(Graphics g) {
                g.setFont(new Font("Ariel", 1, 50));
                g.setColor(Color.GRAY);
                g.drawString("Edit Mode", 200, 200);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_gameMainPanel, "Center");
        try {
            Constructor<? extends GridGameMenu<GridGameFrame>> menuConstructor = menuBarClass.getConstructor(GridGameFrame.class);
            this.m_menuBar = menuConstructor.newInstance(this);
            this.setJMenuBar(this.m_menuBar);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not initalize Menu Bar for: " + menuBarClass);
        }
        this.setTitle(this.m_game.getData().getGameName());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GridGameFrame.this.leaveGame();
            }
        });
        this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        this.m_data.addDataChangeListener(this.m_dataChangeListener);
        this.pack();
    }

    public void minimizeRightSidePanel() {
        BasicSplitPaneUI ui = (BasicSplitPaneUI)this.m_gameCenterPanel.getUI();
        BasicSplitPaneDivider divider = ui.getDivider();
        JButton max = (JButton)divider.getComponent(1);
        max.doClick();
    }

    public void maximizeRightSidePanel() {
        this.m_gameCenterPanel.resetToPreferredSizes();
    }

    public static void renderUnits(Container container, GridBagConstraints mainConstraints, Collection<Unit> units, GridMapPanel mapPanel, GameData data) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (Unit u : units) {
            JLabel label = new JLabel(new ImageIcon(mapPanel.getUnitImageFactory().getImage(u.getType(), u.getOwner(), data)));
            label.setToolTipText(u.getType().getName());
            panel.add(label);
        }
        container.add((Component)panel, mainConstraints);
    }

    public static void renderObject(Container container, GridBagConstraints mainConstraints, Object renderObject, GridMapPanel mapPanel, GameData data) {
        Object obj;
        Collection objects;
        Iterator objIter;
        if (renderObject == null) {
            return;
        }
        if (renderObject instanceof Collection && (objIter = (objects = (Collection)renderObject).iterator()).hasNext() && (obj = objIter.next()) instanceof Unit) {
            Collection units = (Collection)renderObject;
            GridGameFrame.renderUnits(container, mainConstraints, units, mapPanel, data);
        }
    }

    public void updateRightSidePanel(String message, Object renderObject) {
        JPanel rightSide = new JPanel();
        JTextArea title = new JTextArea();
        JScrollPane scroll = new JScrollPane(title);
        rightSide.setLayout(new GridBagLayout());
        title.setWrapStyleWord(true);
        title.setBackground(this.getBackground());
        title.setLineWrap(true);
        title.setBorder(null);
        title.setEditable(false);
        scroll.setBorder(null);
        Insets insets = new Insets(5, 0, 0, 0);
        title.setText(message);
        rightSide.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 1, insets, 0, 0));
        GridBagConstraints mainConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.9, 11, 1, insets, 0, 0);
        GridGameFrame.renderObject(rightSide, mainConstraints, renderObject, this.m_mapPanel, this.m_data);
        rightSide.add(Box.createGlue());
        this.updateRightSidePanel(rightSide);
    }

    public void updateRightSidePanel(Component component) {
        this.m_rightHandSidePanel.removeAll();
        this.m_rightHandSidePanel.add(component, "Center");
        this.m_rightHandSidePanel.validate();
    }

    Action getShowGameAction() {
        return this.m_showGameAction;
    }

    Action getShowHistoryAction() {
        return this.m_showHistoryAction;
    }

    Action getSaveScreenshotAction() {
        return this.m_saveScreenshotAction;
    }

    public void showGame() {
        this.m_inGame = true;
        if (this.m_inHistory) {
            this.m_inHistory = false;
            if (this.m_historySyncher != null) {
                this.m_historySyncher.deactivate();
                this.m_historySyncher = null;
            }
            this.m_historyPanel.goToEnd();
            this.m_historyPanel = null;
            this.m_mapPanel.getData().removeDataChangeListener(this.m_dataChangeListener);
            this.m_mapPanel.setGameData(this.m_data);
            this.m_data.addDataChangeListener(this.m_dataChangeListener);
        }
        this.m_gameMainPanel.removeAll();
        this.m_gameMainPanel.setLayout(new BorderLayout());
        this.m_gameMainPanel.add((Component)this.m_gameCenterPanel, "Center");
        this.m_gameMainPanel.add((Component)this.m_gameSouthPanel, "South");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_gameMainPanel, "Center");
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showHistory() {
        GameData clonedGameData;
        this.m_inHistory = true;
        this.m_inGame = false;
        this.m_data.acquireReadLock();
        try {
            clonedGameData = GameDataUtils.cloneGameData(this.m_data);
            if (clonedGameData == null) {
                return;
            }
            this.m_data.removeDataChangeListener(this.m_dataChangeListener);
            clonedGameData.testLocksOnRead();
            if (this.m_historySyncher != null) {
                throw new IllegalStateException("Two history synchers?");
            }
            this.m_historySyncher = new HistorySynchronizer(clonedGameData, this.m_game);
            clonedGameData.addDataChangeListener(this.m_dataChangeListener);
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_mapPanel.setGameData(clonedGameData);
        GridHistoryDetailsPanel historyDetailPanel = new GridHistoryDetailsPanel(clonedGameData, this.m_mapPanel);
        this.m_rightHandSidePanel.removeAll();
        this.m_rightHandSidePanel.add(historyDetailPanel);
        this.m_historyComponent.removeAll();
        this.m_historyComponent.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.m_historyComponent.setLayout(new BorderLayout());
        JPopupMenu popup = new JPopupMenu();
        popup.add(new AbstractAction("Show Summary Log"){
            private static final long serialVersionUID = -6730966512179268157L;

            public void actionPerformed(ActionEvent ae) {
                HistoryLog historyLog = new HistoryLog();
                historyLog.printRemainingTurn(GridGameFrame.this.m_historyPanel.getCurrentPopupNode(), false, GridGameFrame.this.m_data.getDiceSides(), null);
                for (PlayerID player : GridGameFrame.this.m_data.getPlayerList().getPlayers()) {
                    ArrayList<PlayerID> players = new ArrayList<PlayerID>();
                    players.add(player);
                    historyLog.printTerritorySummary(clonedGameData, players);
                }
                GridGameFrame.this.m_historyPanel.clearCurrentPopupNode();
                historyLog.setVisible(true);
            }
        });
        popup.add(new AbstractAction("Save Screenshot"){
            private static final long serialVersionUID = 1222760138263428443L;

            public void actionPerformed(ActionEvent ae) {
                GridGameFrame.this.saveScreenshot(GridGameFrame.this.m_historyPanel.getCurrentPopupNode(), clonedGameData);
                GridGameFrame.this.m_historyPanel.clearCurrentPopupNode();
            }
        });
        popup.add(new AbstractAction("Save Game at this point (BETA)"){
            private static final long serialVersionUID = 1430512376199927896L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                block17: {
                    GridGameFrame.this.m_data.acquireReadLock();
                    try {
                        File f = BasicGameMenuBar.getSaveGameLocationDialog(GridGameFrame.this);
                        if (f == null) break block17;
                        FileOutputStream fout = null;
                        try {
                            fout = new FileOutputStream(f);
                            GameData datacopy = GameDataUtils.cloneGameData(GridGameFrame.this.m_data, true);
                            datacopy.getHistory().gotoNode(GridGameFrame.this.m_historyPanel.getCurrentPopupNode());
                            datacopy.getHistory().removeAllHistoryAfterNode(GridGameFrame.this.m_historyPanel.getCurrentPopupNode());
                            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)datacopy.getHistory().getRoot()).preorderEnumeration();
                            enumeration.nextElement();
                            int round = 0;
                            String stepDisplayName = datacopy.getSequence().getStep(0).getDisplayName();
                            PlayerID currentPlayer = datacopy.getSequence().getStep(0).getPlayerID();
                            while (enumeration.hasMoreElements()) {
                                HistoryNode node = (HistoryNode)enumeration.nextElement();
                                if (node instanceof Round) {
                                    round = ((Round)node).getRoundNo();
                                    currentPlayer = null;
                                    stepDisplayName = node.getTitle();
                                    continue;
                                }
                                if (!(node instanceof Step)) continue;
                                currentPlayer = ((Step)node).getPlayerID();
                                stepDisplayName = node.getTitle();
                            }
                            datacopy.getSequence().setRoundAndStep(round, stepDisplayName, currentPlayer);
                            new GameDataManager().saveGame(fout, datacopy);
                            JOptionPane.showMessageDialog(GridGameFrame.this, "Game Saved", "Game Saved", 1);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    finally {
                        GridGameFrame.this.m_data.releaseReadLock();
                    }
                }
                GridGameFrame.this.m_historyPanel.clearCurrentPopupNode();
            }
        });
        JSplitPane split = new JSplitPane();
        split.setOneTouchExpandable(true);
        split.setDividerSize(8);
        this.m_historyPanel = new HistoryPanel(clonedGameData, historyDetailPanel, popup, null);
        split.setLeftComponent(this.m_historyPanel);
        split.setRightComponent(this.m_gameCenterPanel);
        split.setDividerLocation(150);
        this.m_historyComponent.add((Component)split, "Center");
        this.m_historyComponent.add((Component)this.m_gameSouthPanel, "South");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_historyComponent, "Center");
        this.validate();
    }

    public void saveScreenshot(final HistoryNode node, final GameData data) {
        FileFilter pngFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".png");
            }

            public String getDescription() {
                return "Saved Screenshots, *.png";
            }
        };
        SaveGameFileChooser fileChooser = new SaveGameFileChooser();
        fileChooser.setFileFilter(pngFilter);
        int rVal = fileChooser.showSaveDialog(this);
        if (rVal == 0) {
            int choice;
            File f = fileChooser.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(f.getParent(), f.getName() + ".png");
            }
            if (f.exists() && (choice = JOptionPane.showConfirmDialog(this, "A file by that name already exists. Do you wish to over write it?", "Over-write?", 0, 2)) != 0) {
                return;
            }
            final File file = f;
            Runnable t = new Runnable(){

                public void run() {
                    if (GridGameFrame.this.saveScreenshot(node, data, file)) {
                        JOptionPane.showMessageDialog(GridGameFrame.this, "Screenshot Saved", "Screenshot Saved", 1);
                    }
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(t);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                t.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveScreenshot(HistoryNode node, GameData data, File file) {
        TreeNode[] pathFromRoot;
        boolean retval = true;
        int round = 0;
        for (TreeNode pathNode : pathFromRoot = node.getPath()) {
            HistoryNode curNode = (HistoryNode)pathNode;
            if (curNode instanceof Round) {
                round = ((Round)curNode).getRoundNo();
            }
            if (!(curNode instanceof Step)) continue;
        }
        double scale = 1.0;
        BufferedImage mapImage = Util.createImage((int)(1.0 * (double)this.m_mapPanel.getImageWidth()), (int)(1.0 * (double)this.m_mapPanel.getImageHeight()), false);
        Graphics2D mapGraphics = mapImage.createGraphics();
        try {
            data.acquireReadLock();
            try {
                int xOffset = this.m_mapPanel.getXOffset();
                int yOffset = this.m_mapPanel.getYOffset();
                this.m_mapPanel.setTopLeft(0, 0);
                this.m_mapPanel.print(mapGraphics);
                this.m_mapPanel.setTopLeft(xOffset, yOffset);
            }
            finally {
                data.releaseReadLock();
            }
            Color title_color = Color.BLACK;
            int title_x = (int)((double)this.m_mapData.getBevelWidth() * 1.0);
            int title_y = 20;
            int title_size = 16;
            AffineTransform transform = new AffineTransform();
            transform.scale(1.0, 1.0);
            mapGraphics.setTransform(transform);
            mapGraphics.setFont(new Font("Ariel", 1, 16));
            mapGraphics.setColor(title_color);
            mapGraphics.drawString(data.getGameName() + "    Round " + round, title_x, 20);
            try {
                ImageIO.write((RenderedImage)mapImage, "png", file);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(this, e2.getMessage(), "Error saving Screenshot", 0);
                retval = false;
            }
        }
        finally {
            mapImage.flush();
            mapGraphics.dispose();
        }
        return retval;
    }

    public void refreshTerritories(Collection<Territory> territories) {
        if (this.m_mapPanel != null) {
            this.m_mapPanel.refreshTerritories(territories);
        }
    }

    public void updateAllImages() {
        if (this.m_mapPanel != null) {
            this.m_mapPanel.updateAllImages();
        }
    }

    public void showGridPlayDataMove(IGridPlayData move) {
        this.m_mapPanel.showGridPlayDataMove(move);
    }

    public void showGridEndTurnData(IGridEndTurnData endTurnData) {
        this.m_mapPanel.showGridEndTurnData(endTurnData);
    }

    public void initializeGridMapData(GameMap map) {
        this.m_mapData.initializeGridMapData(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge) {
        IGridPlayData play = null;
        try {
            while (play == null) {
                if (this.m_mapPanel == null) {
                    IGridPlayData iGridPlayData = null;
                    return iGridPlayData;
                }
                this.m_mapPanel.removeShutdownLatch(this.m_waiting);
                this.m_waiting = new CountDownLatch(1);
                this.m_mapPanel.addShutdownLatch(this.m_waiting);
                play = this.m_mapPanel.waitForPlay(player, bridge, this.m_waiting);
            }
        }
        catch (InterruptedException e) {
            IGridPlayData iGridPlayData = null;
            return iGridPlayData;
        }
        finally {
            if (this.m_mapPanel != null) {
                this.m_mapPanel.removeShutdownLatch(this.m_waiting);
            }
        }
        return play;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGridEndTurnData waitForEndTurn(PlayerID player, IPlayerBridge bridge) {
        IGridEndTurnData endTurn = null;
        try {
            while (endTurn == null) {
                if (this.m_mapPanel == null) {
                    IGridEndTurnData iGridEndTurnData = null;
                    return iGridEndTurnData;
                }
                this.m_mapPanel.removeShutdownLatch(this.m_waiting);
                this.m_waiting = new CountDownLatch(1);
                this.m_mapPanel.addShutdownLatch(this.m_waiting);
                endTurn = this.m_mapPanel.waitForEndTurn(player, bridge, this.m_waiting);
            }
        }
        catch (InterruptedException e) {
            IGridEndTurnData iGridEndTurnData = null;
            return iGridEndTurnData;
        }
        finally {
            if (this.m_mapPanel != null) {
                this.m_mapPanel.removeShutdownLatch(this.m_waiting);
            }
        }
        return endTurn;
    }

    public void changeActivePlayer(PlayerID player) {
        this.m_currentPlayer = player == null ? PlayerID.NULL_PLAYERID : player;
    }

    public PlayerID getActivePlayer() {
        return this.m_currentPlayer;
    }

    @Override
    public IGame getGame() {
        return this.m_game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveGame() {
        int rVal;
        if (!this.m_gameOver && (rVal = JOptionPane.showConfirmDialog(this, "Are you sure you want to leave?\nUnsaved game data will be lost.", "Exit", 0)) != 0) {
            return;
        }
        if (this.m_waiting != null) {
            CountDownLatch countDownLatch = this.m_waiting;
            synchronized (countDownLatch) {
                while (this.m_waiting.getCount() > 0L) {
                    this.m_waiting.countDown();
                }
            }
        }
        if (this.m_game instanceof ServerGame) {
            ((ServerGame)this.m_game).stopGame();
        } else {
            this.m_game.getMessenger().shutDown();
            ((ClientGame)this.m_game).shutDown();
            MainFrame.getInstance().clientLeftGame();
        }
    }

    public void stopGame() {
        if (GameRunner.isMac()) {
            MacWrapper.unregisterShutdownHandler();
        }
        this.setVisible(false);
        this.dispose();
        this.m_game = null;
        if (this.m_data != null) {
            this.m_data.clearAllListeners();
        }
        this.m_data = null;
        this.m_mapPanel.shutDown();
        this.m_mapPanel = null;
        this.m_status = null;
        this.m_gameSouthPanel = null;
        if (this.m_chatPanel != null) {
            this.m_chatPanel.setPlayerRenderer(null);
            this.m_chatPanel.setChat(null);
        }
        this.m_chatPanel = null;
        this.m_chatSplit = null;
        this.m_gameMainPanel = null;
        this.m_mapPanel = null;
        this.m_mapAndChatPanel = null;
        this.m_status = null;
        this.m_rightHandSidePanel = null;
        for (WindowListener l : this.getWindowListeners()) {
            this.removeWindowListener(l);
        }
        this.m_localPlayers = null;
    }

    @Override
    public void shutdown() {
        int rVal;
        if (!this.m_gameOver && (rVal = JOptionPane.showConfirmDialog(this, "Are you sure you want to exit?\nUnsaved game data will be lost.", "Exit", 0)) != 0) {
            return;
        }
        this.stopGame();
        System.exit(0);
    }

    public void setGameOver() {
        this.m_gameOver = true;
    }

    public boolean isGameOver() {
        return this.m_gameOver;
    }

    @Override
    public void notifyError(String error) {
        this.m_error.setText(error == null ? " " : error);
    }

    public void setStatus(String status) {
        this.m_error.setText(" ");
        this.m_status.setText(status == null ? " " : status);
    }

    @Override
    public JComponent getMainPanel() {
        return this.m_mapPanel;
    }

    public GridMapPanel getMapPanel() {
        return this.m_mapPanel;
    }

    @Override
    public void setShowChatTime(boolean showTime) {
        this.m_chatPanel.setShowChatTime(showTime);
    }

    public void showRightHandSidePanel() {
        this.m_rightHandSidePanel.setVisible(true);
    }

    public void hideRightHandSidePanel() {
        this.m_rightHandSidePanel.setVisible(false);
    }

    public UnitType selectUnit(final Unit startUnit, final Collection<UnitType> options, final Territory territory, final PlayerID player, final GameData data, String message) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        if (options.size() == 1) {
            return options.iterator().next();
        }
        AtomicReference<UnitType> selected = new AtomicReference<UnitType>();
        Tuple<JPanel, JList> comps = Util.runInSwingEventThread(new Util.Task<Tuple<JPanel, JList>>(){

            @Override
            public Tuple<JPanel, JList> run() {
                JList<Object> list = new JList<Object>(new Vector(options));
                list.setSelectionMode(0);
                list.setSelectedIndex(0);
                list.setCellRenderer(new UnitCellRenderer(GridGameFrame.this.m_mapPanel.getUnitImageFactory(), player, data));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                if (startUnit != null) {
                    panel.add((Component)new JLabel("Promoting: " + startUnit.getType().getName() + (territory == null ? "" : " in " + territory.getName())), "North");
                }
                JScrollPane scroll = new JScrollPane(list);
                panel.add((Component)scroll, "Center");
                return new Tuple<JPanel, JList>(panel, list);
            }
        });
        JPanel panel = comps.getFirst();
        JList list = comps.getSecond();
        Object[] selectionOptions = new String[]{"OK", "Cancel"};
        int selection = EventThreadJOptionPane.showOptionDialog(this, panel, message, 2, -1, null, selectionOptions, null, this.m_mapPanel.getCountDownLatchHandler());
        if (selection == 0) {
            selected.set((UnitType)list.getSelectedValue());
        }
        return (UnitType)selected.get();
    }

    protected void showEditMode() {
        if (this.m_editDelegate != null) {
            this.m_editModeButtonModel.setSelected(true);
            this.getGlassPane().setVisible(true);
            this.m_menuBar.enableEditOptionsMenu();
        }
    }

    protected void hideEditMode() {
        this.m_editModeButtonModel.setSelected(false);
        this.getGlassPane().setVisible(false);
        this.m_menuBar.disableEditOptionsMenu();
    }

    protected void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GridGameFrame.this.setWidgetActivation();
                }
            });
            return;
        }
        if (this.m_editModeButtonModel != null) {
            if (this.m_editDelegate == null) {
                this.m_editModeButtonModel.setEnabled(false);
            } else {
                this.m_editModeButtonModel.setEnabled(true);
            }
        }
    }

    public void setEditDelegate(IGridEditDelegate editDelegate) {
        this.m_editDelegate = editDelegate;
        this.m_dataChangeListener.gameDataChanged(ChangeFactory.EMPTY_CHANGE);
        this.setWidgetActivation();
    }

    public IGridEditDelegate getEditDelegate() {
        return this.m_editDelegate;
    }

    public ButtonModel getEditModeButtonModel() {
        return this.m_editModeButtonModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEditMode() {
        boolean isEditMode = false;
        if (this.m_mapPanel == null) {
            return false;
        }
        this.m_mapPanel.getData().acquireReadLock();
        try {
            isEditMode = BaseEditDelegate.getEditMode(this.m_mapPanel.getData());
        }
        finally {
            this.m_mapPanel.getData().releaseReadLock();
        }
        return isEditMode;
    }
}

