/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.common.ui.BasicGameMenuBar;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.sound.SoundOptions;
import games.strategy.sound.SoundPath;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.PlayerChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridGameMenu<CustomGridGameFrame extends GridGameFrame>
extends BasicGameMenuBar<GridGameFrame> {
    private static final long serialVersionUID = -8512774312859744827L;
    protected CurrentEditAction m_currentEditAction = CurrentEditAction.None;
    protected JMenu m_editOptionsMenu;

    public GridGameMenu(CustomGridGameFrame frame) {
        super(frame);
    }

    @Override
    protected void createGameSpecificMenus(JMenuBar menuBar) {
        this.createViewMenu(menuBar);
        this.createGameMenu(menuBar);
        this.createExportMenu(menuBar);
    }

    @Override
    protected void addGameSpecificHelpMenus(JMenu helpMenu) {
        this.addHowToPlayHelpMenu(helpMenu);
    }

    protected void createGameMenu(JMenuBar menuBar) {
        JMenu menuGame = new JMenu("Game");
        menuGame.setMnemonic(71);
        menuBar.add(menuGame);
        this.addEditMode(menuGame);
        menuGame.add(((GridGameFrame)this.m_frame).getShowGameAction()).setMnemonic(71);
        menuGame.add(((GridGameFrame)this.m_frame).getShowHistoryAction()).setMnemonic(72);
        this.addSoundsToMenu(menuGame);
        menuGame.addSeparator();
        this.addGameOptionsMenu(menuGame);
        this.addAISleepDuration(menuGame);
    }

    protected void addEditMode(JMenu parentMenu) {
        JCheckBoxMenuItem editMode = new JCheckBoxMenuItem("Enable Edit Mode");
        editMode.setModel(((GridGameFrame)this.m_frame).getEditModeButtonModel());
        parentMenu.add(editMode).setMnemonic(69);
        ((GridGameFrame)this.m_frame).getMapPanel().addMapSelectionListener(this.getMapSelectionListener());
        this.m_editOptionsMenu = new JMenu();
        this.m_editOptionsMenu.setText("Edit...");
        this.addEditAddUnitsMode(this.m_editOptionsMenu);
        this.addEditRemoveUnitsMode(this.m_editOptionsMenu);
        parentMenu.add(this.m_editOptionsMenu);
    }

    public void enableEditOptionsMenu() {
        this.m_editOptionsMenu.setEnabled(true);
        for (Component item : this.m_editOptionsMenu.getComponents()) {
            item.setEnabled(true);
        }
    }

    public void disableEditOptionsMenu() {
        this.m_editOptionsMenu.setEnabled(false);
        for (Component item : this.m_editOptionsMenu.getComponents()) {
            item.setEnabled(false);
        }
    }

    protected void addEditAddUnitsMode(JMenu parentMenu) {
        JMenuItem addUnitsItem = new JMenuItem("Add Units...");
        addUnitsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((GridGameFrame)GridGameMenu.this.m_frame).getEditModeButtonModel().isSelected()) {
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.AddUnits;
                }
            }
        });
        addUnitsItem.setMnemonic(65);
        parentMenu.add(addUnitsItem);
    }

    protected void addEditRemoveUnitsMode(JMenu parentMenu) {
        JMenuItem removeUnitsItem = new JMenuItem("Remove Units...");
        removeUnitsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((GridGameFrame)GridGameMenu.this.m_frame).getEditModeButtonModel().isSelected()) {
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.RemoveUnits;
                }
            }
        });
        removeUnitsItem.setMnemonic(82);
        parentMenu.add(removeUnitsItem);
    }

    protected void addEditChangeTerritoryOwnershipMode(JMenu parentMenu) {
        JMenuItem changeTerritoryOwnerItem = new JMenuItem("Change Territory Owner...");
        changeTerritoryOwnerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((GridGameFrame)GridGameMenu.this.m_frame).getEditModeButtonModel().isSelected()) {
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.ChangeTerritoryOwnership;
                }
            }
        });
        changeTerritoryOwnerItem.setMnemonic(84);
        parentMenu.add(changeTerritoryOwnerItem);
    }

    protected final MapSelectionListener getMapSelectionListener() {
        return new DefaultMapSelectionListener(){

            public void territorySelected(Territory territory, MouseDetails md) {
                if (territory == null) {
                    return;
                }
                if (GridGameMenu.this.m_currentEditAction == CurrentEditAction.AddUnits) {
                    PlayerChooser playerChooser = new PlayerChooser(GridGameMenu.this.getData().getPlayerList(), territory.getOwner(), null, false);
                    JDialog dialog = playerChooser.createDialog(GridGameMenu.this.getTopLevelAncestor(), "Select owner for new units");
                    dialog.setVisible(true);
                    PlayerID player = playerChooser.getSelected();
                    if (player != null) {
                        UnitType ut = ((GridGameFrame)GridGameMenu.this.m_frame).selectUnit(null, GridGameMenu.this.getData().getUnitTypeList().getAllUnitTypes(), territory, player, GridGameMenu.this.getData(), "Select Unit to Add");
                        ArrayList<Unit> units = new ArrayList<Unit>();
                        units.addAll(ut.create(1, player));
                        String result = ((GridGameFrame)GridGameMenu.this.m_frame).getEditDelegate().addUnits(territory, units);
                        if (result != null) {
                            JOptionPane.showMessageDialog(GridGameMenu.this.getTopLevelAncestor(), result, "Could not perform edit", 0);
                        }
                    }
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.None;
                } else if (GridGameMenu.this.m_currentEditAction == CurrentEditAction.RemoveUnits) {
                    Collection<Unit> selectedUnits = territory.getUnits().getUnits();
                    String result = ((GridGameFrame)GridGameMenu.this.m_frame).getEditDelegate().removeUnits(territory, selectedUnits);
                    if (result != null) {
                        JOptionPane.showMessageDialog(GridGameMenu.this.getTopLevelAncestor(), result, MyFormatter.pluralize("Could not remove unit", selectedUnits.size()), 0);
                    }
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.None;
                } else if (GridGameMenu.this.m_currentEditAction == CurrentEditAction.ChangeTerritoryOwnership) {
                    String result;
                    TerritoryAttachment ta = TerritoryAttachment.get(territory, true);
                    if (ta == null) {
                        JOptionPane.showMessageDialog(GridGameMenu.this.getTopLevelAncestor(), "No TerritoryAttachment for " + territory + ".", "Could not perform edit", 0);
                        return;
                    }
                    PlayerID defaultPlayer = ta.getOriginalOwner();
                    PlayerChooser playerChooser = new PlayerChooser(GridGameMenu.this.getData().getPlayerList(), defaultPlayer, null, true);
                    JDialog dialog = playerChooser.createDialog(GridGameMenu.this.getTopLevelAncestor(), "Select new owner for territory for " + territory.getName());
                    dialog.setVisible(true);
                    PlayerID player = playerChooser.getSelected();
                    if (player != null && (result = ((GridGameFrame)GridGameMenu.this.m_frame).getEditDelegate().changeTerritoryOwner(territory, player)) != null) {
                        JOptionPane.showMessageDialog(GridGameMenu.this.getTopLevelAncestor(), result, "Could not perform edit", 0);
                    }
                    GridGameMenu.this.m_currentEditAction = CurrentEditAction.None;
                }
            }
        };
    }

    protected void addSoundsToMenu(JMenu parentMenu) {
        SoundOptions.addGlobalSoundSwitchMenu(parentMenu);
        SoundOptions.addToMenu(parentMenu, SoundPath.SoundType.GENERAL);
    }

    protected void createExportMenu(JMenuBar menuBar) {
        JMenu menuGame = new JMenu("Export");
        menuGame.setMnemonic(69);
        menuBar.add(menuGame);
        this.addExportXML(menuGame);
        this.addSaveScreenshot(menuGame);
    }

    protected void createViewMenu(JMenuBar menuBar) {
        JMenu menuView = new JMenu("View");
        menuView.setMnemonic(86);
        menuBar.add(menuView);
        this.addChatTimeMenu(menuView);
        this.addShowGameUuid(menuView);
        this.addSetLookAndFeel(menuView);
    }

    protected void addSaveScreenshot(JMenu parentMenu) {
        parentMenu.add(((GridGameFrame)this.m_frame).getSaveScreenshotAction()).setMnemonic(69);
    }

    protected abstract void addHowToPlayHelpMenu(JMenu var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CurrentEditAction {
        None,
        AddUnits,
        RemoveUnits,
        ChangeTerritoryOwnership;

    }
}

