/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Renderable;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.triplea.ui.history.IHistoryDetailsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridHistoryDetailsPanel
extends JPanel
implements IHistoryDetailsPanel {
    private static final long serialVersionUID = 7703367732080472172L;
    protected final GameData m_data;
    protected final JTextArea m_title = new JTextArea();
    protected final JScrollPane m_scroll = new JScrollPane(this.m_title);
    protected final GridMapPanel m_mapPanel;

    public GridHistoryDetailsPanel(GameData data, GridMapPanel mapPanel) {
        this.m_data = data;
        this.setLayout(new GridBagLayout());
        this.m_title.setWrapStyleWord(true);
        this.m_title.setBackground(this.getBackground());
        this.m_title.setLineWrap(true);
        this.m_title.setBorder(null);
        this.m_title.setEditable(false);
        this.m_scroll.setBorder(null);
        this.m_mapPanel = mapPanel;
    }

    @Override
    public void render(HistoryNode node) {
        Object obj;
        Collection objects;
        Iterator objIter;
        Object details;
        this.removeAll();
        Insets insets = new Insets(5, 0, 0, 0);
        this.m_title.setText(node.getTitle());
        this.add((Component)this.m_scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 1, insets, 0, 0));
        GridBagConstraints mainConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.9, 11, 1, insets, 0, 0);
        if (node instanceof Renderable && (details = ((Renderable)((Object)node)).getRenderingData()) instanceof Collection && (objIter = (objects = (Collection)details).iterator()).hasNext() && (obj = objIter.next()) instanceof Unit) {
            Collection units = (Collection)details;
            this.renderUnits(mainConstraints, units);
        }
        this.add(Box.createGlue());
        this.validate();
        this.repaint();
    }

    private void renderUnits(GridBagConstraints mainConstraints, Collection<Unit> units) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (Unit u : units) {
            JLabel label = new JLabel(new ImageIcon(this.m_mapPanel.getUnitImageFactory().getImage(u.getType(), u.getOwner(), this.m_data)));
            label.setToolTipText(u.getType().getName());
            panel.add(label);
        }
        this.add((Component)panel, mainConstraints);
    }
}

