/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import java.awt.Dimension;
import java.awt.Polygon;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridMapData {
    protected Map<String, Polygon> m_polys;
    protected int m_gridWidth;
    protected int m_gridHeight;
    protected int m_squareWidth;
    protected int m_squareHeight;
    protected int m_bevelWidth;
    protected int m_bevelHeight;

    public GridMapData(GameMap map, int x_dim, int y_dim, int squareWidth, int squareHeight, int topLeftOffsetWidth, int topLeftOffsetHeight) {
        this.setMapData(map, x_dim, y_dim, squareWidth, squareHeight, topLeftOffsetWidth, topLeftOffsetHeight);
    }

    public synchronized void setMapData(GameMap map, int x_dim, int y_dim, int squareWidth, int squareHeight, int topLeftOffsetWidth, int topLeftOffsetHeight) {
        this.m_gridWidth = x_dim;
        this.m_gridHeight = y_dim;
        this.m_squareWidth = squareWidth;
        this.m_squareHeight = squareHeight;
        this.m_bevelWidth = topLeftOffsetWidth;
        this.m_bevelHeight = topLeftOffsetHeight;
        int x_offset = this.m_bevelWidth;
        int y_offset = this.m_bevelHeight;
        this.m_polys = new HashMap<String, Polygon>();
        for (int y = 0; y < y_dim; ++y) {
            int x = 0;
            while (x < x_dim) {
                Territory territory = map.getTerritoryFromCoordinates(x++, y);
                Polygon p = new Polygon(new int[]{x_offset, x_offset + this.m_squareWidth, x_offset + this.m_squareWidth, x_offset}, new int[]{y_offset, y_offset, y_offset + this.m_squareHeight, y_offset + this.m_squareHeight}, 4);
                this.m_polys.put(territory.getName(), p);
                x_offset += this.m_squareWidth;
            }
            x_offset = this.m_bevelWidth;
            y_offset += this.m_squareHeight;
        }
        this.initializeGridMapData(map);
    }

    public int getBevelWidth() {
        return this.m_bevelWidth;
    }

    public int getBevelHeight() {
        return this.m_bevelHeight;
    }

    public int getGridWidthNumber() {
        return this.m_gridWidth;
    }

    public int getGridHeightNumber() {
        return this.m_gridHeight;
    }

    public int getSquareWidth() {
        return this.m_squareWidth;
    }

    public int getSquareHeight() {
        return this.m_squareHeight;
    }

    public void initializeGridMapData(GameMap map) {
    }

    public synchronized Map<String, Polygon> getStringPolygons() {
        return this.m_polys;
    }

    public synchronized Map<Territory, Polygon> getTerritoryPolygons(GameMap map) {
        HashMap<Territory, Polygon> polys = new HashMap<Territory, Polygon>();
        for (Map.Entry<String, Polygon> entry : this.m_polys.entrySet()) {
            polys.put(map.getTerritory(entry.getKey()), entry.getValue());
        }
        return polys;
    }

    public synchronized Polygon getPolygon(Territory at) {
        return this.m_polys.get(at.getName());
    }

    public synchronized Polygon getPolygon(String at) {
        return this.m_polys.get(at);
    }

    public Territory getTerritoryAt(double x, double y, GameMap map) {
        int normal_x = (int)(x - (double)this.m_bevelWidth);
        int normal_y = (int)(y - (double)this.m_bevelHeight);
        if (normal_x < 0 || normal_y < 0 || normal_x > this.m_gridWidth * this.m_squareWidth + this.m_bevelWidth || normal_y > this.m_gridHeight * this.m_squareHeight + this.m_bevelHeight) {
            return null;
        }
        int at_x = normal_x / this.m_squareWidth;
        int at_y = normal_y / this.m_squareHeight;
        if (at_x < 0 || at_x >= this.m_gridWidth || at_y < 0 || at_y >= this.m_gridHeight) {
            return null;
        }
        return map.getTerritoryFromCoordinates(at_x, at_y);
    }

    public Dimension getMapDimensions() {
        return new Dimension(this.m_gridWidth * this.m_squareWidth + this.m_bevelWidth * 2 + 1, this.m_gridHeight * this.m_squareHeight + this.m_bevelHeight * 2 + 1);
    }
}

