/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.common.image.UnitImageFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

class UnitCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 3247984570687473808L;
    private final UnitImageFactory m_imageFactory;
    private final PlayerID m_player;
    private final GameData m_data;
    private final Hashtable<UnitType, ImageIcon> iconTable = new Hashtable();

    public UnitCellRenderer(UnitImageFactory imageFactory, PlayerID player, GameData data) {
        this.m_imageFactory = imageFactory;
        this.m_player = player;
        this.m_data = data;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        PlayerID player;
        UnitType type;
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
        if (value instanceof Unit) {
            type = ((Unit)value).getType();
            player = ((Unit)value).getOwner();
        } else if (value instanceof UnitType) {
            type = (UnitType)value;
            player = this.m_player;
        } else {
            type = null;
            player = this.m_player;
        }
        if (type != null) {
            ImageIcon icon = this.iconTable.get(type);
            if (icon == null) {
                icon = new ImageIcon(this.m_imageFactory.getImage(type, player, this.m_data));
                this.iconTable.put(type, icon);
            }
            label.setIcon(icon);
            label.setText(type.getName());
            label.setToolTipText(type.getName());
        } else {
            label.setIcon(null);
        }
        return label;
    }
}

