/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui.display;

import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.engine.display.IDisplayBridge;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridGameDisplay
implements IGridGameDisplay {
    private IDisplayBridge m_displayBridge;
    private final GridGameFrame m_ui;

    public GridGameDisplay(GridGameFrame ui) {
        this.m_ui = ui;
    }

    @Override
    public GridGameFrame getGridGameFrame() {
        return this.m_ui;
    }

    @Override
    public void initialize(IDisplayBridge bridge) {
        this.m_displayBridge = bridge;
    }

    @Override
    public void shutDown() {
        this.m_ui.stopGame();
    }

    @Override
    public void setStatus(String status) {
        this.m_ui.setStatus(status);
    }

    @Override
    public void setGameOver() {
        this.m_ui.setGameOver();
    }

    @Override
    public void refreshTerritories(Collection<Territory> territories) {
        this.m_ui.refreshTerritories(territories);
    }

    @Override
    public void showGridPlayDataMove(IGridPlayData move) {
        this.m_ui.showGridPlayDataMove(move);
    }

    @Override
    public void showGridEndTurnData(IGridEndTurnData endTurnData) {
        this.m_ui.showGridEndTurnData(endTurnData);
    }

    @Override
    public void initializeGridMapData(GameMap map) {
        this.m_ui.initializeGridMapData(map);
    }
}

