/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class DesktopUtilityBrowserLauncher {
    static final String[] browsers = new String[]{"firefox", "google-chrome", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla", "netscape"};
    static final String errMsg = "Error attempting to launch web browser";

    public static void openFile(File file) {
        URI uri = file.toURI();
        try {
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), uri);
        }
        catch (Exception ignore) {
            String url = uri.toString();
            String osName = System.getProperty("os.name");
            try {
                if (osName != null && osName.startsWith("Mac OS")) {
                    try {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("open", String.class).invoke(null, url);
                    }
                    catch (Exception e) {
                        Runtime.getRuntime().exec("open " + url);
                    }
                }
                if (osName != null && osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                }
                try {
                    String[] cmd = new String[]{"xdg-open", url};
                    Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e) {
                    try {
                        String[] cmdGnome = new String[]{"gnome-open", url};
                        Runtime.getRuntime().exec(cmdGnome);
                    }
                    catch (Exception e2) {
                        String[] cmdKDE = new String[]{"kfmclient", url};
                        Runtime.getRuntime().exec(cmdKDE);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
            }
        }
    }

    public static void openURL(String url) {
        block13: {
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
            }
            catch (Exception ignore) {
                String osName = System.getProperty("os.name");
                try {
                    if (osName != null && osName.startsWith("Mac OS")) {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                    }
                    if (osName != null && osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    }
                    String browser = null;
                    for (String b : browsers) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{browser = b, url});
                    }
                    if (browser != null) break block13;
                    String cmd = "firefox -remote openURL(" + url + ")";
                    try {
                        Process p = Runtime.getRuntime().exec(cmd);
                        int exitCode = p.waitFor();
                        if (exitCode != 0) {
                            cmd = "firefox " + url;
                            p = Runtime.getRuntime().exec(cmd);
                        }
                    }
                    catch (Exception x) {
                        cmd = "netscape -remote openURL(" + url + ")";
                        try {
                            Process p = Runtime.getRuntime().exec(cmd);
                            int exitCode = p.waitFor();
                            if (exitCode != 0) {
                                cmd = "netscape " + url;
                                p = Runtime.getRuntime().exec(cmd);
                            }
                        }
                        catch (Exception x2) {
                            throw new Exception(Arrays.toString(browsers));
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
                }
            }
        }
    }
}

