/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class IPFinder {
    public static InetAddress findInetAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> enum1 = NetworkInterface.getNetworkInterfaces();
        if (enum1 == null) {
            InetAddress ip1 = InetAddress.getLocalHost();
            return ip1;
        }
        ArrayList<InetAddress> allButLoopback = new ArrayList<InetAddress>();
        while (enum1.hasMoreElements()) {
            NetworkInterface netface = enum1.nextElement();
            Enumeration<InetAddress> enum2 = netface.getInetAddresses();
            while (enum2.hasMoreElements()) {
                InetAddress ip2 = enum2.nextElement();
                if (ip2.isLoopbackAddress()) continue;
                allButLoopback.add(ip2);
            }
        }
        for (InetAddress address : allButLoopback) {
            if (address.getAddress().length != 4 || IPFinder.isPrivateNetworkAddress(address)) continue;
            return address;
        }
        for (InetAddress address : allButLoopback) {
            if (IPFinder.isPrivateNetworkAddress(address)) continue;
            return address;
        }
        for (InetAddress address : allButLoopback) {
            if (address.isLinkLocalAddress()) continue;
            return address;
        }
        return InetAddress.getLocalHost();
    }

    private static boolean isPrivateNetworkAddress(InetAddress address) {
        int _192 = -64;
        int _172 = -84;
        int _168 = -88;
        int _169 = -87;
        int _252 = -4;
        int _254 = -2;
        byte[] bytes = address.getAddress();
        return bytes.length == 4 ? bytes[0] == 10 || bytes[0] == -84 && bytes[1] >= 16 && bytes[1] <= 31 || bytes[0] == -64 && bytes[1] == -88 || bytes[0] == -87 && bytes[1] == -2 : bytes[0] == -4 && bytes[1] == 0 || bytes[0] == -2;
    }

    public static void main(String[] args) throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> enum1 = NetworkInterface.getNetworkInterfaces();
        while (enum1.hasMoreElements()) {
            NetworkInterface netface = enum1.nextElement();
            System.out.println("interface:" + netface);
            Enumeration<InetAddress> enum2 = netface.getInetAddresses();
            while (enum2.hasMoreElements()) {
                InetAddress ip2 = enum2.nextElement();
                System.out.println(" address:" + ip2 + " is private:" + IPFinder.isPrivateNetworkAddress(ip2) + " is loopback:" + ip2.isLoopbackAddress());
            }
            System.out.println("----------------------");
        }
        System.out.println();
        System.out.println("Found:" + IPFinder.findInetAddress());
    }
}

