/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.engine.chat.ChatController;
import games.strategy.engine.chat.IChatChannel;
import games.strategy.engine.lobby.server.login.LobbyLoginValidator;
import games.strategy.engine.lobby.server.userDB.MutedIpController;
import games.strategy.engine.lobby.server.userDB.MutedMacController;
import games.strategy.engine.lobby.server.userDB.MutedUsernameController;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.SpokeInvoke;
import games.strategy.net.DefaultObjectStreamFactory;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.ILoginValidator;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.IPFinder;
import games.strategy.net.IServerMessenger;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.NIOSocketListener;
import games.strategy.net.nio.QuarantineConversation;
import games.strategy.net.nio.ServerQuarantineConversation;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMessenger
implements IServerMessenger,
NIOSocketListener {
    private static Logger s_logger = Logger.getLogger(ServerMessenger.class.getName());
    private final Selector m_acceptorSelector;
    private final ServerSocketChannel m_socketChannel;
    private final Node m_node;
    private boolean m_shutdown = false;
    private final NIOSocket m_nioSocket;
    private final CopyOnWriteArrayList<IMessageListener> m_listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IMessengerErrorListener> m_errorListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IConnectionChangeListener> m_connectionListeners = new CopyOnWriteArrayList();
    private boolean m_acceptNewConnection = false;
    private ILoginValidator m_loginValidator;
    private final ConcurrentHashMap<INode, SocketChannel> m_nodeToChannel = new ConcurrentHashMap();
    private final ConcurrentHashMap<SocketChannel, INode> m_channelToNode = new ConcurrentHashMap();
    private final Object m_cachedListLock = new Object();
    private final HashMap<String, String> m_cachedMacAddresses = new HashMap();
    private final List<String> m_liveMutedUsernames = new ArrayList<String>();
    private final List<String> m_liveMutedIpAddresses = new ArrayList<String>();
    private final List<String> m_liveMutedMacAddresses = new ArrayList<String>();
    private final HashMap<String, String> m_playersThatLeftMacs_Last10 = new HashMap();
    public static final String YOU_HAVE_BEEN_MUTED_LOBBY = "?YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER";
    public static final String YOU_HAVE_BEEN_MUTED_GAME = "?YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST";
    private final List<String> m_miniBannedUsernames = new ArrayList<String>();
    private final List<String> m_miniBannedIpAddresses = new ArrayList<String>();
    private final List<String> m_miniBannedMacAddresses = new ArrayList<String>();

    public ServerMessenger(String name, int portNumber, IObjectStreamFactory streamFactory) throws IOException {
        this.m_socketChannel = ServerSocketChannel.open();
        this.m_socketChannel.configureBlocking(false);
        this.m_socketChannel.socket().setReuseAddress(true);
        this.m_socketChannel.socket().bind(new InetSocketAddress(portNumber), 10);
        this.m_nioSocket = new NIOSocket(streamFactory, this, "Server");
        this.m_acceptorSelector = Selector.open();
        this.m_node = IPFinder.findInetAddress() != null ? new Node(name, IPFinder.findInetAddress(), portNumber) : new Node(name, InetAddress.getLocalHost(), portNumber);
        Thread t = new Thread((Runnable)new ConnectionHandler(), "Server Messenger Connection Handler");
        t.start();
    }

    @Override
    public void setLoginValidator(ILoginValidator loginValidator) {
        this.m_loginValidator = loginValidator;
    }

    @Override
    public ILoginValidator getLoginValidator() {
        return this.m_loginValidator;
    }

    public ServerMessenger(String name, int portNumber) throws IOException {
        this(name, portNumber, new DefaultObjectStreamFactory());
    }

    @Override
    public void addMessageListener(IMessageListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeMessageListener(IMessageListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public Set<INode> getNodes() {
        HashSet<INode> rVal = new HashSet<INode>(this.m_nodeToChannel.keySet());
        rVal.add(this.m_node);
        return rVal;
    }

    @Override
    public synchronized void shutDown() {
        if (!this.m_shutdown) {
            this.m_shutdown = true;
            this.m_nioSocket.shutDown();
            try {
                this.m_socketChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_acceptorSelector != null) {
                this.m_acceptorSelector.wakeup();
            }
        }
    }

    public synchronized boolean isShutDown() {
        return this.m_shutdown;
    }

    @Override
    public boolean isConnected() {
        return !this.m_shutdown;
    }

    @Override
    public void send(Serializable msg, INode to) {
        if (this.m_shutdown) {
            return;
        }
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "Sending" + msg + " to:" + to);
        }
        MessageHeader header = new MessageHeader(to, this.m_node, msg);
        SocketChannel socketChannel = this.m_nodeToChannel.get(to);
        if (socketChannel == null) {
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.log(Level.FINER, "no channel for node:" + to + " dropping message:" + msg);
            }
            return;
        }
        this.m_nioSocket.send(socketChannel, header);
    }

    @Override
    public void broadcast(Serializable msg) {
        MessageHeader header = new MessageHeader(this.m_node, msg);
        this.forwardBroadcast(header);
    }

    private boolean isLobby() {
        return this.m_loginValidator instanceof LobbyLoginValidator;
    }

    private boolean isGame() {
        return !this.isLobby();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String GetPlayerMac(String name) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            String mac = this.m_cachedMacAddresses.get(name);
            if (mac == null) {
                mac = this.m_playersThatLeftMacs_Last10.get(name);
            }
            return mac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsUsernameMuted(String username) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_liveMutedUsernames.contains(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyUsernameMutingOfPlayer(String username, Date muteExpires) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_liveMutedUsernames.contains(username)) {
                this.m_liveMutedUsernames.add(username);
            }
            if (this.isLobby() && muteExpires != null) {
                this.ScheduleUsernameUnmuteAt(username, muteExpires.getTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsIpMuted(String ip) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_liveMutedIpAddresses.contains(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyIPMutingOfPlayer(String ip, Date muteExpires) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_liveMutedIpAddresses.contains(ip)) {
                this.m_liveMutedIpAddresses.add(ip);
            }
            if (this.isLobby() && muteExpires != null) {
                this.ScheduleIpUnmuteAt(ip, muteExpires.getTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsMacMuted(String mac) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_liveMutedMacAddresses.contains(mac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyMacMutingOfPlayer(String mac, Date muteExpires) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_liveMutedMacAddresses.contains(mac)) {
                this.m_liveMutedMacAddresses.add(mac);
            }
            if (this.isLobby() && muteExpires != null) {
                this.ScheduleMacUnmuteAt(mac, muteExpires.getTime());
            }
        }
    }

    private void ScheduleUsernameUnmuteAt(String username, long checkTime) {
        Timer unmuteUsernameTimer = new Timer("Username unmute timer");
        unmuteUsernameTimer.schedule(this.GetUsernameUnmuteTask(username), new Date(checkTime));
    }

    private void ScheduleIpUnmuteAt(String ip, long checkTime) {
        Timer unmuteIpTimer = new Timer("IP unmute timer");
        unmuteIpTimer.schedule(this.GetIpUnmuteTask(ip), new Date(checkTime));
    }

    private void ScheduleMacUnmuteAt(String mac, long checkTime) {
        Timer unmuteMacTimer = new Timer("Mac unmute timer");
        unmuteMacTimer.schedule(this.GetMacUnmuteTask(mac), new Date(checkTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NotifyPlayerLogin(String uniquePlayerName, String ip, String mac) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            this.m_cachedMacAddresses.put(uniquePlayerName, mac);
            if (this.isLobby()) {
                long muteTill;
                String realName = uniquePlayerName.split(" ")[0];
                if (!this.m_liveMutedUsernames.contains(realName) && (muteTill = new MutedUsernameController().getUsernameUnmuteTime(realName)) != -1L && muteTill <= System.currentTimeMillis()) {
                    this.m_liveMutedUsernames.add(realName);
                    this.ScheduleUsernameUnmuteAt(realName, muteTill);
                }
                if (!this.m_liveMutedIpAddresses.contains(ip) && (muteTill = new MutedIpController().getIpUnmuteTime(ip)) != -1L && muteTill <= System.currentTimeMillis()) {
                    this.m_liveMutedIpAddresses.add(ip);
                    this.ScheduleIpUnmuteAt(ip, muteTill);
                }
                if (!this.m_liveMutedMacAddresses.contains(mac) && (muteTill = new MutedMacController().getMacUnmuteTime(mac)) != -1L && muteTill <= System.currentTimeMillis()) {
                    this.m_liveMutedMacAddresses.add(mac);
                    this.ScheduleMacUnmuteAt(mac, muteTill);
                }
            }
        }
    }

    public HashMap<String, String> GetPlayersThatLeftMacs_Last10() {
        return this.m_playersThatLeftMacs_Last10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NotifyPlayerRemoval(INode node) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            this.m_playersThatLeftMacs_Last10.put(node.getName(), this.m_cachedMacAddresses.get(node.getName()));
            if (this.m_playersThatLeftMacs_Last10.size() > 10) {
                this.m_playersThatLeftMacs_Last10.remove(this.m_playersThatLeftMacs_Last10.entrySet().iterator().next().toString());
            }
            this.m_cachedMacAddresses.remove(node.getName());
        }
    }

    @Override
    public void messageReceived(MessageHeader msg, SocketChannel channel) {
        INode expectedReceive = this.m_channelToNode.get(channel);
        if (!expectedReceive.equals(msg.getFrom())) {
            throw new IllegalStateException("Expected: " + expectedReceive + " not: " + msg.getFrom());
        }
        if (msg.getMessage() instanceof HubInvoke) {
            if (this.isLobby() && ((HubInvoke)msg.getMessage()).call.getRemoteName().equals("_ChatCtrl_LOBBY_CHAT")) {
                String realName = msg.getFrom().getName().split(" ")[0];
                if (this.IsUsernameMuted(realName)) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_LOBBY, msg.getFrom());
                    return;
                }
                if (this.IsIpMuted(msg.getFrom().getAddress().getHostAddress())) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_LOBBY, msg.getFrom());
                    return;
                }
                if (this.IsMacMuted(this.GetPlayerMac(msg.getFrom().getName()))) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_LOBBY, msg.getFrom());
                    return;
                }
            } else if (this.isGame() && ((HubInvoke)msg.getMessage()).call.getRemoteName().equals("_ChatCtrlgames.strategy.engine.framework.ui.ServerStartup.CHAT_NAME")) {
                String realName = msg.getFrom().getName().split(" ")[0];
                if (this.IsUsernameMuted(realName)) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_GAME, msg.getFrom());
                    return;
                }
                if (this.IsIpMuted(msg.getFrom().getAddress().getHostAddress())) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_GAME, msg.getFrom());
                    return;
                }
                if (this.IsMacMuted(this.GetPlayerMac(msg.getFrom().getName()))) {
                    this.bareBonesSendChatMessage(YOU_HAVE_BEEN_MUTED_GAME, msg.getFrom());
                    return;
                }
            }
        }
        if (msg.getFor() == null) {
            this.forwardBroadcast(msg);
            this.notifyListeners(msg);
        } else if (msg.getFor().equals(this.m_node)) {
            this.notifyListeners(msg);
        } else {
            this.forward(msg);
        }
    }

    private void bareBonesSendChatMessage(String message, INode to) {
        ArrayList<String> args = new ArrayList<String>();
        Class[] argTypes = new Class[1];
        args.add(message);
        argTypes[0] = args.get(0).getClass();
        RemoteName rn = this.isLobby() ? new RemoteName(ChatController.getChatChannelName("_LOBBY_CHAT"), IChatChannel.class) : new RemoteName(ChatController.getChatChannelName("games.strategy.engine.framework.ui.ServerStartup.CHAT_NAME"), IChatChannel.class);
        RemoteMethodCall call = new RemoteMethodCall(rn.getName(), "chatOccured", args.toArray(), argTypes, rn.getClazz());
        SpokeInvoke spokeInvoke = new SpokeInvoke(null, false, call, this.getServerNode());
        this.send(spokeInvoke, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsUsernameMiniBanned(String username) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_miniBannedUsernames.contains(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyUsernameMiniBanningOfPlayer(String username) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_miniBannedUsernames.contains(username)) {
                this.m_miniBannedUsernames.add(username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsIpMiniBanned(String ip) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_miniBannedIpAddresses.contains(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyIPMiniBanningOfPlayer(String ip) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_miniBannedIpAddresses.contains(ip)) {
                this.m_miniBannedIpAddresses.add(ip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsMacMiniBanned(String mac) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            return this.m_miniBannedMacAddresses.contains(mac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void NotifyMacMiniBanningOfPlayer(String mac) {
        Object object = this.m_cachedListLock;
        synchronized (object) {
            if (!this.m_miniBannedMacAddresses.contains(mac)) {
                this.m_miniBannedMacAddresses.add(mac);
            }
        }
    }

    private void forward(MessageHeader msg) {
        if (this.m_shutdown) {
            return;
        }
        SocketChannel socketChannel = this.m_nodeToChannel.get(msg.getFor());
        if (socketChannel == null) {
            throw new IllegalStateException("No channel for:" + msg.getFor() + " all channels:" + socketChannel);
        }
        this.m_nioSocket.send(socketChannel, msg);
    }

    private void forwardBroadcast(MessageHeader msg) {
        if (this.m_shutdown) {
            return;
        }
        SocketChannel fromChannel = this.m_nodeToChannel.get(msg.getFrom());
        ArrayList<SocketChannel> nodes = new ArrayList<SocketChannel>(this.m_nodeToChannel.values());
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "broadcasting to" + nodes);
        }
        for (SocketChannel channel : nodes) {
            if (channel == fromChannel) continue;
            this.m_nioSocket.send(channel, msg);
        }
    }

    private boolean isNameTaken(String nodeName) {
        for (INode node : this.getNodes()) {
            if (!node.getName().equalsIgnoreCase(nodeName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueName(String currentName) {
        if (currentName.length() > 50) {
            currentName = currentName.substring(0, 50);
        }
        if (currentName.length() < 2) {
            currentName = "aa" + currentName;
        }
        Node node = this.m_node;
        synchronized (node) {
            if (this.isNameTaken(currentName)) {
                int i = 1;
                while (true) {
                    String newName;
                    if (!this.isNameTaken(newName = currentName + " (" + i + ")")) {
                        currentName = newName;
                        break;
                    }
                    ++i;
                }
            }
        }
        return currentName;
    }

    private void notifyListeners(MessageHeader msg) {
        for (IMessageListener listener : this.m_listeners) {
            listener.messageReceived(msg.getMessage(), msg.getFrom());
        }
    }

    @Override
    public void addErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.add(listener);
    }

    @Override
    public void removeErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.remove(listener);
    }

    @Override
    public void addConnectionChangeListener(IConnectionChangeListener listener) {
        this.m_connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionChangeListener(IConnectionChangeListener listener) {
        this.m_connectionListeners.remove(listener);
    }

    private void notifyConnectionsChanged(boolean added, INode node) {
        Iterator<IConnectionChangeListener> iter = this.m_connectionListeners.iterator();
        while (iter.hasNext()) {
            if (added) {
                iter.next().connectionAdded(node);
                continue;
            }
            iter.next().connectionRemoved(node);
        }
    }

    @Override
    public void setAcceptNewConnections(boolean accept) {
        this.m_acceptNewConnection = accept;
    }

    @Override
    public boolean isAcceptNewConnections() {
        return this.m_acceptNewConnection;
    }

    @Override
    public INode getLocalNode() {
        return this.m_node;
    }

    private TimerTask GetUsernameUnmuteTask(final String username) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (new MutedUsernameController().getUsernameUnmuteTime(username) == -1L) {
                    Object object = ServerMessenger.this.m_cachedListLock;
                    synchronized (object) {
                        ServerMessenger.this.m_liveMutedUsernames.remove(username);
                    }
                }
            }
        };
    }

    private TimerTask GetIpUnmuteTask(final String ip) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (new MutedIpController().getIpUnmuteTime(ip) == -1L) {
                    Object object = ServerMessenger.this.m_cachedListLock;
                    synchronized (object) {
                        ServerMessenger.this.m_liveMutedIpAddresses.remove(ip);
                    }
                }
            }
        };
    }

    private TimerTask GetMacUnmuteTask(final String mac) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (new MutedMacController().getMacUnmuteTime(mac) == -1L) {
                    Object object = ServerMessenger.this.m_cachedListLock;
                    synchronized (object) {
                        ServerMessenger.this.m_liveMutedMacAddresses.remove(mac);
                    }
                }
            }
        };
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void removeConnection(INode node) {
        if (node.equals(this.m_node)) {
            throw new IllegalArgumentException("Cant remove ourself!");
        }
        this.NotifyPlayerRemoval(node);
        SocketChannel channel = this.m_nodeToChannel.remove(node);
        if (channel == null) {
            channel = this.m_nodeToChannel.remove(node);
        }
        if (channel == null) {
            s_logger.info("Could not remove connection to node:" + node);
            return;
        }
        this.m_channelToNode.remove(channel);
        this.m_nioSocket.close(channel);
        this.notifyConnectionsChanged(false, node);
        s_logger.info("Connection removed:" + node);
    }

    @Override
    public INode getServerNode() {
        return this.m_node;
    }

    @Override
    public void socketError(SocketChannel channel, Exception error) {
        if (channel == null) {
            throw new IllegalArgumentException("Null channel");
        }
        INode node = this.m_channelToNode.get(channel);
        if (node != null) {
            this.removeConnection(node);
        }
    }

    @Override
    public void socketUnqaurantined(SocketChannel channel, QuarantineConversation conversation) {
        ServerQuarantineConversation con = (ServerQuarantineConversation)conversation;
        Node remote = new Node(con.getRemoteName(), (InetSocketAddress)channel.socket().getRemoteSocketAddress());
        if (s_logger.isLoggable(Level.FINER)) {
            s_logger.log(Level.FINER, "Unquarntined node:" + remote);
        }
        this.m_nodeToChannel.put(remote, channel);
        this.m_channelToNode.put(channel, remote);
        this.notifyConnectionsChanged(true, remote);
        s_logger.info("Connection added to:" + remote);
    }

    @Override
    public INode getRemoteNode(SocketChannel channel) {
        return this.m_channelToNode.get(channel);
    }

    @Override
    public InetSocketAddress getRemoteServerSocketAddress() {
        return this.m_node.getSocketAddress();
    }

    private class ConnectionHandler
    implements Runnable {
        private ConnectionHandler() {
        }

        public void run() {
            try {
                ServerMessenger.this.m_socketChannel.register(ServerMessenger.this.m_acceptorSelector, 16);
            }
            catch (ClosedChannelException e) {
                s_logger.log(Level.SEVERE, "socket closed", e);
                ServerMessenger.this.shutDown();
            }
            while (!ServerMessenger.this.m_shutdown) {
                try {
                    ServerMessenger.this.m_acceptorSelector.select();
                }
                catch (IOException e) {
                    s_logger.log(Level.SEVERE, "Could not accept on server", e);
                    ServerMessenger.this.shutDown();
                }
                if (ServerMessenger.this.m_shutdown) continue;
                Set<SelectionKey> keys = ServerMessenger.this.m_acceptorSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable() && key.isValid()) {
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                        SocketChannel socketChannel = null;
                        try {
                            socketChannel = serverSocketChannel.accept();
                            if (socketChannel == null) continue;
                            socketChannel.configureBlocking(false);
                            socketChannel.socket().setKeepAlive(true);
                        }
                        catch (IOException e) {
                            s_logger.log(Level.FINE, "Could not accept channel", e);
                            try {
                                if (socketChannel == null) continue;
                                socketChannel.close();
                            }
                            catch (IOException e2) {
                                s_logger.log(Level.FINE, "Could not close channel", e2);
                            }
                            continue;
                        }
                        if (!ServerMessenger.this.m_acceptNewConnection) {
                            try {
                                socketChannel.close();
                            }
                            catch (IOException e) {
                                s_logger.log(Level.FINE, "Could not close channel", e);
                            }
                            continue;
                        }
                        ServerQuarantineConversation conversation = new ServerQuarantineConversation(ServerMessenger.this.m_loginValidator, socketChannel, ServerMessenger.this.m_nioSocket, ServerMessenger.this);
                        ServerMessenger.this.m_nioSocket.add(socketChannel, conversation);
                        continue;
                    }
                    if (key.isValid()) continue;
                    key.cancel();
                }
            }
        }
    }
}

