/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.display.IDisplayBridge;
import games.strategy.engine.framework.AbstractGameLoader;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.ui.HeadlessGameServerUI;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.net.GUID;
import games.strategy.sound.DefaultSoundChannel;
import games.strategy.sound.ISound;
import games.strategy.triplea.TripleAPlayer;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.strongAI.StrongAI;
import games.strategy.triplea.ai.weakAI.DoesNothingAI;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.HeadlessUIContext;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import games.strategy.triplea.ui.display.TripleaDisplay;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleA
extends AbstractGameLoader
implements IGameLoader {
    private static final long serialVersionUID = -8374315848374732436L;
    public static final String HUMAN_PLAYER_TYPE = "Human";
    public static final String WEAK_COMPUTER_PLAYER_TYPE = "E.Z. Fodder (AI)";
    public static final String STRONG_COMPUTER_PLAYER_TYPE = "Moore N. Able (AI)";
    public static final String DYNAMIX_COMPUTER_PLAYER_TYPE = "Dynamix Land-Only (AI)";
    public static final String DOESNOTHINGAI_COMPUTER_PLAYER_TYPE = "Does Nothing (AI)";
    protected transient ITripleaDisplay m_display;

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            String type = playerNames.get(name);
            if (type.equals(WEAK_COMPUTER_PLAYER_TYPE)) {
                players.add(new WeakAI(name, type));
                continue;
            }
            if (type.equals(STRONG_COMPUTER_PLAYER_TYPE)) {
                players.add(new StrongAI(name, type));
                continue;
            }
            if (type.equals(DYNAMIX_COMPUTER_PLAYER_TYPE)) {
                players.add(new Dynamix_AI(name, type));
                continue;
            }
            if (type.equals(DOESNOTHINGAI_COMPUTER_PLAYER_TYPE)) {
                players.add(new DoesNothingAI(name, type));
                continue;
            }
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                TripleAPlayer player = new TripleAPlayer(name, type);
                players.add(player);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.m_display != null) {
            this.m_game.removeDisplay(this.m_display);
            this.m_display.shutDown();
            this.m_display = null;
        }
    }

    protected void initializeGame() {
    }

    @Override
    public void startGame(final IGame game, final Set<IGamePlayer> players, boolean headless) throws Exception {
        try {
            this.m_game = game;
            if (game.getData().getDelegateList().getDelegate("edit") == null) {
                EditDelegate delegate = new EditDelegate();
                delegate.initialize("edit", "edit");
                this.m_game.getData().getDelegateList().addDelegate(delegate);
                if (game instanceof ServerGame) {
                    ((ServerGame)game).addDelegateMessenger(delegate);
                }
            }
            final LocalPlayers localPlayers = new LocalPlayers(players);
            if (headless) {
                HeadlessUIContext uiContext = new HeadlessUIContext();
                uiContext.setDefaultMapDir(game.getData());
                uiContext.setLocalPlayers(localPlayers);
                boolean useServerUI = HeadlessGameServer.getUseGameServerUI();
                final HeadlessGameServerUI headlessFrameUI = useServerUI ? new HeadlessGameServerUI(game, localPlayers, uiContext) : null;
                this.m_display = new ITripleaDisplay(){

                    @Override
                    public void initialize(IDisplayBridge bridge) {
                    }

                    @Override
                    public void shutDown() {
                        if (headlessFrameUI != null) {
                            headlessFrameUI.stopGame();
                        }
                    }

                    @Override
                    public void reportMessageToAll(String message, String title, boolean doNotIncludeHost, boolean doNotIncludeClients, boolean doNotIncludeObservers) {
                    }

                    @Override
                    public void reportMessageToPlayers(Collection<PlayerID> playersToSendTo, Collection<PlayerID> butNotThesePlayers, String message, String title) {
                    }

                    @Override
                    public void showBattle(GUID battleID, Territory location, String battleTitle, Collection<Unit> attackingUnits, Collection<Unit> defendingUnits, Collection<Unit> killedUnits, Collection<Unit> attackingWaitingToDie, Collection<Unit> defendingWaitingToDie, Map<Unit, Collection<Unit>> dependentUnits, PlayerID attacker, PlayerID defender, boolean isAmphibious, IBattle.BattleType battleType, Collection<Unit> amphibiousLandAttackers) {
                    }

                    @Override
                    public void listBattleSteps(GUID battleID, List<String> steps) {
                    }

                    @Override
                    public void battleEnd(GUID battleID, String message) {
                    }

                    @Override
                    public void casualtyNotification(GUID battleID, String step, DiceRoll dice, PlayerID player, Collection<Unit> killed, Collection<Unit> damaged, Map<Unit, Collection<Unit>> dependents) {
                    }

                    @Override
                    public void deadUnitNotification(GUID battleID, PlayerID player, Collection<Unit> dead, Map<Unit, Collection<Unit>> dependents) {
                    }

                    @Override
                    public void changedUnitsNotification(GUID battleID, PlayerID player, Collection<Unit> removedUnits, Collection<Unit> addedUnits, Map<Unit, Collection<Unit>> dependents) {
                    }

                    @Override
                    public void bombingResults(GUID battleID, List<Die> dice, int cost) {
                    }

                    @Override
                    public void notifyRetreat(String shortMessage, String message, String step, PlayerID retreatingPlayer) {
                    }

                    @Override
                    public void notifyRetreat(GUID battleId, Collection<Unit> retreating) {
                    }

                    @Override
                    public void notifyDice(GUID battleId, DiceRoll dice, String stepName) {
                    }

                    @Override
                    public void gotoBattleStep(GUID battleId, String step) {
                    }
                };
                this.m_soundChannel = new ISound(){

                    @Override
                    public void initialize() {
                    }

                    @Override
                    public void shutDown() {
                    }

                    @Override
                    public void playSoundForAll(String clipName, String subFolder) {
                    }

                    @Override
                    public void playSoundForAll(String clipName, String subFolder, boolean doNotIncludeHost, boolean doNotIncludeClients, boolean doNotIncludeObservers) {
                    }

                    @Override
                    public void playSoundToPlayers(String clipName, String subFolder, Collection<PlayerID> playersToSendTo, Collection<PlayerID> butNotThesePlayers) {
                    }

                    @Override
                    public void playSoundToPlayer(String clipName, String subFolder, PlayerID playerToSendTo) {
                    }
                };
                game.addDisplay(this.m_display);
                game.addSoundChannel(this.m_soundChannel);
                this.initializeGame();
                this.connectPlayers(players, null);
                if (headlessFrameUI != null) {
                    headlessFrameUI.setLocationRelativeTo(null);
                    headlessFrameUI.setSize(700, 400);
                    headlessFrameUI.setVisible(true);
                    headlessFrameUI.toFront();
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TripleAFrame frame;
                        try {
                            frame = new TripleAFrame(game, localPlayers);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(-1);
                            return;
                        }
                        TripleA.this.m_display = new TripleaDisplay(frame);
                        game.addDisplay(TripleA.this.m_display);
                        TripleA.this.m_soundChannel = new DefaultSoundChannel(localPlayers);
                        game.addSoundChannel(TripleA.this.m_soundChannel);
                        frame.setSize(700, 400);
                        frame.setVisible(true);
                        DefaultSoundChannel.playSoundOnLocalMachine("game_start", null);
                        TripleA.this.connectPlayers(players, frame);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                frame.setExtendedState(6);
                                frame.toFront();
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            e.printStackTrace();
            throw new IllegalStateException(e.getCause().getMessage());
        }
    }

    private void connectPlayers(Set<IGamePlayer> players, TripleAFrame frame) {
        for (IGamePlayer player : players) {
            if (!(player instanceof TripleAPlayer)) continue;
            ((TripleAPlayer)player).setFrame(frame);
        }
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, WEAK_COMPUTER_PLAYER_TYPE, STRONG_COMPUTER_PLAYER_TYPE, DYNAMIX_COMPUTER_PLAYER_TYPE, DOESNOTHINGAI_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public Class<? extends IChannelSubscribor> getDisplayType() {
        return ITripleaDisplay.class;
    }

    @Override
    public Class<? extends IChannelSubscribor> getSoundType() {
        return ISound.class;
    }

    @Override
    public Class<? extends IRemote> getRemotePlayerType() {
        return ITripleaPlayer.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new IUnitFactory(){
            private static final long serialVersionUID = 5684926837825766505L;

            public Unit createUnit(UnitType type, PlayerID owner, GameData data) {
                return new TripleAUnit(type, owner, data);
            }
        };
    }
}

