/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.delegate.AbstractEndTurnDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPoliticalAI {
    public static List<PoliticalActionAttachment> getPoliticalActionsTowardsWar(PlayerID id, HashMap<ICondition, Boolean> testedConditions, GameData data) {
        ArrayList<PoliticalActionAttachment> acceptableActions = new ArrayList<PoliticalActionAttachment>();
        for (PoliticalActionAttachment nextAction : PoliticalActionAttachment.getValidActions(id, testedConditions, data)) {
            if (!BasicPoliticalAI.wantToPerFormActionTowardsWar(nextAction, id, data)) continue;
            acceptableActions.add(nextAction);
        }
        return acceptableActions;
    }

    public static List<PoliticalActionAttachment> getPoliticalActionsOther(PlayerID id, HashMap<ICondition, Boolean> testedConditions, GameData data) {
        List<PoliticalActionAttachment> warActions = BasicPoliticalAI.getPoliticalActionsTowardsWar(id, testedConditions, data);
        ArrayList<PoliticalActionAttachment> acceptableActions = new ArrayList<PoliticalActionAttachment>();
        Collection<PoliticalActionAttachment> validActions = PoliticalActionAttachment.getValidActions(id, testedConditions, data);
        validActions.removeAll(warActions);
        for (PoliticalActionAttachment nextAction : validActions) {
            if (warActions.contains(nextAction) || BasicPoliticalAI.goesTowardsWar(nextAction, id, data) && Math.random() < 0.5 || BasicPoliticalAI.awayFromAlly(nextAction, id, data) && Math.random() < 0.9) continue;
            if (BasicPoliticalAI.isFree(nextAction)) {
                acceptableActions.add(nextAction);
                continue;
            }
            if (Match.countMatches(validActions, Matches.PoliticalActionHasCostBetween(0, 0)) > 1) {
                if (!(Math.random() < 0.9) || !BasicPoliticalAI.isAcceptableCost(nextAction, id, data)) continue;
                acceptableActions.add(nextAction);
                continue;
            }
            if (!(Math.random() < 0.4) || !BasicPoliticalAI.isAcceptableCost(nextAction, id, data)) continue;
            acceptableActions.add(nextAction);
        }
        return acceptableActions;
    }

    private static boolean wantToPerFormActionTowardsWar(PoliticalActionAttachment nextAction, PlayerID id, GameData data) {
        return BasicPoliticalAI.isFree(nextAction) && BasicPoliticalAI.goesTowardsWar(nextAction, id, data);
    }

    private static boolean goesTowardsWar(PoliticalActionAttachment nextAction, PlayerID p0, GameData data) {
        for (String relationshipChangeString : nextAction.getRelationshipChange()) {
            String[] relationshipChange = relationshipChangeString.split(":");
            PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
            PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
            if (!p0.equals(p1) && !p0.equals(p2)) continue;
            RelationshipType currentType = data.getRelationshipTracker().getRelationshipType(p1, p2);
            RelationshipType newType = data.getRelationshipTypeList().getRelationshipType(relationshipChange[2]);
            if (!currentType.getRelationshipTypeAttachment().isNeutral() || !newType.getRelationshipTypeAttachment().isWar()) continue;
            return true;
        }
        return false;
    }

    private static boolean awayFromAlly(PoliticalActionAttachment nextAction, PlayerID p0, GameData data) {
        for (String relationshipChangeString : nextAction.getRelationshipChange()) {
            String[] relationshipChange = relationshipChangeString.split(":");
            PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
            PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
            if (!p0.equals(p1) && !p0.equals(p2)) continue;
            RelationshipType currentType = data.getRelationshipTracker().getRelationshipType(p1, p2);
            RelationshipType newType = data.getRelationshipTypeList().getRelationshipType(relationshipChange[2]);
            if (!currentType.getRelationshipTypeAttachment().isAllied() || !newType.getRelationshipTypeAttachment().isNeutral() && !newType.getRelationshipTypeAttachment().isWar()) continue;
            return true;
        }
        return false;
    }

    private static boolean isFree(PoliticalActionAttachment nextAction) {
        return nextAction.getCostPU() <= 0;
    }

    private static boolean isAcceptableCost(PoliticalActionAttachment nextAction, PlayerID player, GameData data) {
        float production = AbstractEndTurnDelegate.getProduction(data.getMap().getTerritoriesOwnedBy(player), data);
        return production >= 21.0f && (float)nextAction.getCostPU() <= production / 10.0f;
    }
}

