/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Code;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.FactoryCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.PurchaseGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.Purchase_UnitPlacementLocationSorter;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.util.Match;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Place {
    public static void place(Dynamix_AI ai, boolean bid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        int PUChange;
        List<Unit> units;
        Territory factoryTer;
        PurchaseGroup pg;
        if (DSettings.LoadSettings().AIC_disableAllUnitPurchasesAndPlacements) {
            final String message = ai.getName() + " is skipping it's placement phase and destroying its " + player.getResources().getQuantity(GlobalCenter.GetPUResource()) + " PU's, as instructed.";
            DUtils.Log(Level.FINE, message, new Object[0]);
            Runnable runner = new Runnable(){

                public void run() {
                    CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            Change change = ChangeFactory.changeResourcesChange(player, GlobalCenter.GetPUResource(), -player.getResources().getQuantity(GlobalCenter.GetPUResource()));
            CachedInstanceCenter.CachedDelegateBridge.addChange(change);
            Dynamix_AI.Pause();
            return;
        }
        Unit aa = null;
        for (ProductionRule rule : player.getProductionFrontier().getRules()) {
            if (!Matches.UnitTypeIsAAforAnything.match((UnitType)rule.getResults().keySet().toArray()[0])) continue;
            aa = ((UnitType)rule.getResults().keySet().toArray()[0]).create(player);
            break;
        }
        if (aa != null) {
            for (Territory aaBuildTer : FactoryCenter.get((GameData)data, (PlayerID)player).ChosenAAPlaceTerritories) {
                List<Unit> matchingAA = Place.GetPlayerUnitsMatchingUnitsInList(Collections.singletonList(aa), player);
                if (matchingAA.isEmpty()) {
                    DUtils.Log(Level.FINER, "  AA unit placement on pre-assigned territory " + aaBuildTer.getName() + " failed because the player's units matching Matches.UnitIsAA is null... Player's Units: {0}", player.getUnits().getUnits());
                    continue;
                }
                Unit nextAA = matchingAA.get(0);
                Place.doPlace(ai, aaBuildTer, Collections.singleton(nextAA), data, placeDelegate);
            }
        }
        Iterator<Object> i$ = FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories.iterator();
        while (i$.hasNext() && (pg = FactoryCenter.get((GameData)data, (PlayerID)player).TurnTerritoryPurchaseGroups.get(factoryTer = (Territory)i$.next())) != null) {
            units = Place.GetPlayerUnitsMatchingUnitsInList(pg.GetSampleUnits(), player);
            if (DSettings.LoadSettings().EnableUnitPlacementMultiplier && DSettings.LoadSettings().UnitPlacementMultiplyPercent != 100) {
                float multiplyAmount = DUtils.ToFloat(DSettings.LoadSettings().UnitPlacementMultiplyPercent);
                List<Unit> hackedUnits = DUtils.GetXPercentOfTheUnitsInList_CreateMoreIfNeeded(units, multiplyAmount);
                final String message = ai.getName() + " use a UPM cheat, and place " + hackedUnits.size() + " units on " + factoryTer.getName();
                final List<Unit> fHackedUnits = hackedUnits;
                DUtils.Log(Level.FINE, message, new Object[0]);
                Runnable runner = new Runnable(){

                    public void run() {
                        CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message, fHackedUnits);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runner);
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException ex) {
                    // empty catch block
                }
                Change change = ChangeFactory.addUnits(factoryTer, hackedUnits);
                CachedInstanceCenter.CachedDelegateBridge.addChange(change);
                Change change2 = ChangeFactory.removeUnits(player, units);
                CachedInstanceCenter.CachedDelegateBridge.addChange(change2);
                Dynamix_AI.Pause();
                continue;
            }
            Place.doPlace(ai, factoryTer, units, data, placeDelegate);
        }
        for (PurchaseGroup factory : FactoryCenter.get((GameData)data, (PlayerID)player).FactoryPurchaseGroups) {
            Territory bestFactoryPlaceTer = Place.CalculateBestFactoryBuildTerritory(data, player);
            if (bestFactoryPlaceTer == null) {
                DUtils.Log(Level.FINER, "  No factory build ter found to place factory on!", new Object[0]);
                break;
            }
            units = Place.GetPlayerUnitsMatchingUnitsInList(factory.GetSampleUnits(), player);
            Place.doPlace(ai, bestFactoryPlaceTer, units, data, placeDelegate);
        }
        if (player.getUnits().someMatch(Matches.UnitCanProduceUnitsAndIsConstruction)) {
            DUtils.Log(Level.FINE, "  There are factories leftover from the purchase phase, so looping and placing extra factories.", new Object[0]);
            List leftoverUnits = DUtils.ToList(player.getUnits().getUnits());
            while (Match.someMatch(leftoverUnits, Matches.UnitCanProduceUnitsAndIsConstruction)) {
                Territory bestFactoryPlaceTer = Place.CalculateBestFactoryBuildTerritory(data, player);
                if (bestFactoryPlaceTer == null) {
                    DUtils.Log(Level.FINER, "  No factory build ter found to place factory on!", new Object[0]);
                    break;
                }
                Unit nextFactoryToPlace = null;
                for (Unit unit : leftoverUnits) {
                    if (!Matches.UnitCanProduceUnitsAndIsConstruction.match(unit)) continue;
                    nextFactoryToPlace = unit;
                    break;
                }
                if (nextFactoryToPlace == null) break;
                if (Place.doPlace(ai, bestFactoryPlaceTer, Collections.singletonList(nextFactoryToPlace), data, placeDelegate)) continue;
                leftoverUnits.remove(nextFactoryToPlace);
            }
        }
        if (player.getUnits().size() > 0) {
            DUtils.Log(Level.FINE, "  There are units leftover from the purchase phase, so looping and placing extra units.", new Object[0]);
            List<Territory> sortedPossiblePlaceLocations = Purchase_UnitPlacementLocationSorter.CalculateAndSortUnitPlacementLocations(ai, bid, data, player);
            for (Territory placeLoc : sortedPossiblePlaceLocations) {
                List<Unit> leftoverUnits = DUtils.ToList(player.getUnits().getUnits());
                if (leftoverUnits.isEmpty()) break;
                PlaceableUnits pu = placeDelegate.getPlaceableUnits((Collection<Unit>)leftoverUnits, placeLoc);
                if (pu.getErrorMessage() != null) continue;
                int maxUnitsWeCanPlaceHere = pu.getMaxUnits();
                if (maxUnitsWeCanPlaceHere == -1) {
                    maxUnitsWeCanPlaceHere = Integer.MAX_VALUE;
                }
                List<Unit> unitsToPlace = maxUnitsWeCanPlaceHere >= leftoverUnits.size() ? leftoverUnits : leftoverUnits.subList(0, maxUnitsWeCanPlaceHere);
                if (DSettings.LoadSettings().EnableUnitPlacementMultiplier && DSettings.LoadSettings().UnitPlacementMultiplyPercent != 100) {
                    List<Unit> hackedUnits;
                    float multiplyAmount = DUtils.ToFloat(DSettings.LoadSettings().UnitPlacementMultiplyPercent);
                    final List<Unit> fHackedUnits = hackedUnits = DUtils.GetXPercentOfTheUnitsInList_CreateMoreIfNeeded(unitsToPlace, multiplyAmount);
                    final Territory fPlaceLoc = placeLoc;
                    final Dynamix_AI fAI = ai;
                    Runnable runner = new Runnable(){

                        public void run() {
                            CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(fAI.getName() + " use a UPM cheat, and place " + fHackedUnits.size() + " units on " + fPlaceLoc.getName(), fHackedUnits);
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runner);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.toString());
                    }
                    Change change = ChangeFactory.addUnits(placeLoc, hackedUnits);
                    CachedInstanceCenter.CachedDelegateBridge.addChange(change);
                    Change change2 = ChangeFactory.removeUnits(player, unitsToPlace);
                    CachedInstanceCenter.CachedDelegateBridge.addChange(change2);
                    Dynamix_AI.Pause();
                    continue;
                }
                Place.doPlace(ai, placeLoc, unitsToPlace, data, placeDelegate);
            }
        }
        if (DSettings.LoadSettings().EnableResourceCollectionIncreaser && DSettings.LoadSettings().ResourceCollectionIncreaseAmount != 0 && (PUChange = DSettings.LoadSettings().ResourceCollectionIncreaseAmount) > 0) {
            int newPUs = player.getResources().getQuantity(GlobalCenter.GetPUResource()) + PUChange;
            final String message = ai.getName() + " use an RCI cheat, and increase their PUs from " + player.getResources().getQuantity(GlobalCenter.GetPUResource()) + " to " + newPUs;
            DUtils.Log(Level.FINE, message, new Object[0]);
            Runnable runner = new Runnable(){

                public void run() {
                    CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            Change change = ChangeFactory.changeResourcesChange(player, GlobalCenter.GetPUResource(), PUChange);
            CachedInstanceCenter.CachedDelegateBridge.addChange(change);
            Dynamix_AI.Pause();
        }
        GlobalCenter.PUsAtEndOfLastTurn = player.getResources().getQuantity(GlobalCenter.GetPUResource());
    }

    private static boolean doPlace(Dynamix_AI ai, Territory ter, Collection<Unit> units, GameData data, IAbstractPlaceDelegate placer) {
        String message;
        DUtils.Log(Level.FINER, "    Placing units. Territory: {0} Units: {1}", ter, DUtils.UnitList_ToString(units));
        if (units.size() > 0 && UnitAttachment.get(units.iterator().next().getUnitType()).getIsSea() && data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).size() > 0) {
            Set<Territory> openPorts = ter.getData().getMap().getNeighbors(ter, DUtils.CompMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasUnitsThatMatch(Matches.unitIsEnemyOf(ter.getData(), ter.getOwner())).invert()));
            ter = openPorts.size() > 0 ? openPorts.iterator().next() : data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).iterator().next();
        }
        if ((message = placer.placeUnits(new ArrayList<Unit>(units), ter)) != null) {
            DUtils.Log(Level.FINER, "      Error occured: {0}", message);
            return false;
        }
        ai.pause();
        return true;
    }

    private static List<Unit> GetPlayerUnitsMatchingUnitsInList(List<Unit> units, PlayerID player) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        ArrayList<Unit> pUnits = new ArrayList<Unit>(player.getUnits().getUnits());
        for (Unit unit : units) {
            for (Unit pUnit : pUnits) {
                if (!pUnit.getUnitType().equals(unit.getUnitType())) continue;
                result.add(pUnit);
                break;
            }
            pUnits.removeAll(result);
        }
        return result;
    }

    private static Territory CalculateBestFactoryBuildTerritory(GameData data, PlayerID player) {
        List<Territory> ourCapitals = TerritoryAttachment.getAllCapitals(player, data);
        ArrayList<Territory> possibles = new ArrayList<Territory>(data.getMap().getTerritoriesOwnedBy(player));
        Territory highestScoringTer = null;
        int highestTerScore = Integer.MIN_VALUE;
        for (Territory ter : possibles) {
            if (ter.getUnits().someMatch(Matches.UnitCanProduceUnitsAndIsConstruction) || StatusCenter.get(data, player).GetStatusOfTerritory(ter).WasAttacked()) continue;
            int score = 0;
            score = (int)((float)score - DUtils.GetVulnerabilityOfArmy(data, player, ter, DUtils.ToList(ter.getUnits().getUnits()), 250) * 1000.0f);
            score += TerritoryAttachment.get(ter).getProduction() * 10;
            if (!ourCapitals.isEmpty()) {
                score -= DUtils.GetJumpsFromXToY_NoCond(data, ter, ourCapitals.iterator().next());
            }
            if (DMatches.territoryIsOnSmallIsland(data).match(ter)) {
                score -= 100000;
            }
            if (score <= highestTerScore) continue;
            highestScoringTer = ter;
            highestTerScore = score;
        }
        return highestScoringTer;
    }
}

