/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Code;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCasualties {
    private static boolean useDefaultSelectionThisTime = false;

    public static void NotifyCasualtySelectionError(String error) {
        if (error.equals("Wrong number of casualties selected")) {
            DUtils.Log(Level.FINER, "  Wrong number of casualties selected for current battle, so attempting to use default casualties", new Object[0]);
            useDefaultSelectionThisTime = true;
        }
    }

    public static CasualtyDetails selectCasualties(Dynamix_AI ai, GameData data, Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID, boolean allowMultipleHitsPerUnit) {
        ai.pause();
        HashSet<Unit> damaged = new HashSet<Unit>();
        HashSet<Unit> destroyed = new HashSet<Unit>();
        if (useDefaultSelectionThisTime) {
            useDefaultSelectionThisTime = false;
            damaged.addAll(defaultCasualties.getDamaged());
            destroyed.addAll(defaultCasualties.getKilled());
        } else {
            while (damaged.size() + destroyed.size() < count) {
                Unit untouchedTwoHitUnit = null;
                for (Unit unit : selectFrom) {
                    UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                    if (!allowMultipleHitsPerUnit || !ua.getIsTwoHit() || unit.getHits() != 0 || damaged.contains(unit)) continue;
                    untouchedTwoHitUnit = unit;
                    break;
                }
                if (untouchedTwoHitUnit != null) {
                    damaged.add(untouchedTwoHitUnit);
                    continue;
                }
                Unit highestScoringUnit = null;
                float highestScore = -2.1474836E9f;
                for (Unit unit : selectFrom) {
                    UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                    if (destroyed.contains(unit)) continue;
                    float score = 0.0f;
                    score -= (float)DUtils.GetTUVOfUnit(unit, GlobalCenter.GetPUResource());
                    score -= DUtils.GetValueOfUnits(Collections.singleton(unit));
                    if (dependents.containsKey(unit)) {
                        score -= 1000.0f;
                    }
                    if (ua.getIsTwoHit() && (unit.getHits() > 0 || damaged.contains(unit))) {
                        score -= 100.0f;
                    }
                    if (!(score > highestScore)) continue;
                    highestScore = score;
                    highestScoringUnit = unit;
                }
                if (highestScoringUnit == null) continue;
                destroyed.add(highestScoringUnit);
            }
        }
        DUtils.Log(Level.FINER, "  Casualties selected. Damaged: {0}, Destroyed {1}", damaged, destroyed);
        CasualtyDetails m2 = new CasualtyDetails(DUtils.ToList(destroyed), DUtils.ToList(damaged), false);
        return m2;
    }
}

