/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Others.ThreatInvalidationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreatInvalidationCenter {
    private static HashMap<PlayerID, ThreatInvalidationCenter> s_TICInstances = new HashMap();
    private GameData m_data = null;
    private PlayerID m_player = null;
    private boolean ThreatInvalidationSuspended = false;
    private final HashMap<Territory, List<Unit>> InvalidatedEnemyUnits = new HashMap();

    public static ThreatInvalidationCenter get(GameData data, PlayerID player) {
        if (!s_TICInstances.containsKey(player)) {
            s_TICInstances.put(player, ThreatInvalidationCenter.create(data, player));
        }
        return s_TICInstances.get(player);
    }

    private static ThreatInvalidationCenter create(GameData data, PlayerID player) {
        return new ThreatInvalidationCenter(data, player);
    }

    public static void ClearStaticInstances() {
        s_TICInstances.clear();
    }

    public static void NotifyStartOfRound() {
        s_TICInstances.clear();
    }

    public ThreatInvalidationCenter(GameData data, PlayerID player) {
        this.m_data = data;
        this.m_player = player;
    }

    public void SuspendThreatInvalidation() {
        this.ThreatInvalidationSuspended = true;
    }

    public void ResumeThreatInvalidation() {
        this.ThreatInvalidationSuspended = false;
    }

    public void InvalidateThreats(List<Unit> threats, Territory hotspot) {
        if (DSettings.LoadSettings().AA_threatInvalidationType.equals((Object)ThreatInvalidationType.None)) {
            return;
        }
        if (DSettings.LoadSettings().AA_percentageOfResistedThreatThatTasksInvalidate != 100) {
            DUtils.Log(Level.FINER, "            Threats we would invalidate if we invalidated all: {0}", DUtils.UnitList_ToString(threats));
            threats = DUtils.GetXPercentOfTheItemsInList(threats, DUtils.ToFloat(DSettings.LoadSettings().AA_percentageOfResistedThreatThatTasksInvalidate));
        }
        List<Object> tersWereInvalidatingThreatsFor = new ArrayList();
        tersWereInvalidatingThreatsFor = DSettings.LoadSettings().AA_threatInvalidationType.equals((Object)ThreatInvalidationType.Global) ? DUtils.ToList(this.m_data.getMap().getTerritories()) : DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, hotspot, DSettings.LoadSettings().AA_threatInvalidationAroundHotspotRadius);
        tersWereInvalidatingThreatsFor.remove(hotspot);
        for (Territory territory : tersWereInvalidatingThreatsFor) {
            DUtils.AddObjectsToListValueForKeyInMap(this.InvalidatedEnemyUnits, territory, threats);
        }
        DUtils.Log(Level.FINER, "          Invalidating threats. Units: {0} Hotspot: {1} Ters: {2}", DUtils.UnitList_ToString(threats), hotspot.getName(), tersWereInvalidatingThreatsFor);
    }

    public boolean IsUnitInvalidatedForTer(Unit unit, Territory ter) {
        if (this.ThreatInvalidationSuspended) {
            return false;
        }
        if (!this.InvalidatedEnemyUnits.containsKey(ter)) {
            return false;
        }
        return this.InvalidatedEnemyUnits.get(ter).contains(unit);
    }

    public void ClearInvalidatedThreats() {
        DUtils.Log(Level.FINE, "    Clearing invalidated threats.", new Object[0]);
        this.InvalidatedEnemyUnits.clear();
    }
}

