/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DConstants;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSorting {
    public static List SortListByX(Collection list, Comparator comparator) {
        ArrayList result = new ArrayList(list);
        Collections.sort(result, comparator);
        return result;
    }

    public static List SortListByScores_HashMap_A(Collection list, final HashMap<?, ? extends Number> scores) {
        ArrayList result = new ArrayList(list);
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                double v2;
                double v1 = this.safeGet(scores, o1);
                if (v1 > (v2 = this.safeGet(scores, o2))) {
                    return 1;
                }
                if (v1 == v2) {
                    return 0;
                }
                return -1;
            }

            private double safeGet(HashMap<?, ? extends Number> map, Object key) {
                if (!map.containsKey(key)) {
                    return DConstants.Integer_HalfMin;
                }
                return map.get(key).doubleValue();
            }
        });
        return result;
    }

    public static List SortListByScores_HashMap_D(Collection list, HashMap<?, ? extends Number> scores) {
        return DUtils.InvertList(DSorting.SortListByScores_HashMap_A(list, scores));
    }

    public static List SortListByScores_List_A(Collection list, Collection scoreList) {
        HashMap scores = DUtils.ToHashMap(list, scoreList);
        return DSorting.SortListByScores_HashMap_A(list, scores);
    }

    public static List SortListByScores_List_D(Collection list, Collection scoreList) {
        return DUtils.InvertList(DSorting.SortListByScores_List_A(list, scoreList));
    }

    public static List<Territory> SortTerritoriesByDistance_A(List<Territory> ters, final GameData data, final Territory target, final Match<Territory> routeMatch) {
        return DSorting.SortListByX(ters, new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                Route route1 = data.getMap().getRoute(t1, target, routeMatch);
                Route route2 = data.getMap().getRoute(t2, target, routeMatch);
                int distance1 = 0;
                int distance2 = 0;
                distance1 = route1 == null ? DConstants.Integer_HalfMax : route1.getLength();
                distance2 = route2 == null ? DConstants.Integer_HalfMax : route2.getLength();
                return Integer.valueOf(distance1).compareTo(distance2);
            }
        });
    }

    public static List<Territory> SortTerritoriesByDistance_D(List<Territory> ters, GameData data, Territory target, Match<Territory> routeMatch) {
        return DUtils.InvertList(DSorting.SortTerritoriesByDistance_A(ters, data, target, routeMatch));
    }

    public static List<Territory> SortTerritoriesByLandDistance_A(List<Territory> ters, final GameData data, final Territory target) {
        return DSorting.SortListByX(ters, new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                Route route1 = CachedCalculationCenter.GetLandRoute(data, t1, target);
                Route route2 = CachedCalculationCenter.GetLandRoute(data, t2, target);
                int distance1 = 0;
                int distance2 = 0;
                distance1 = route1 == null ? DConstants.Integer_HalfMax : route1.getLength();
                distance2 = route2 == null ? DConstants.Integer_HalfMax : route2.getLength();
                return Integer.valueOf(distance1).compareTo(distance2);
            }
        });
    }

    public static List<Territory> SortTerritoriesByLandDistance_D(List<Territory> ters, GameData data, Territory target) {
        return DUtils.InvertList(DSorting.SortTerritoriesByLandDistance_A(ters, data, target));
    }

    public static List<Territory> SortTerritoriesBySeaDistance_A(List<Territory> ters, final GameData data, final Territory target) {
        return DSorting.SortListByX(ters, new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                Route route1 = CachedCalculationCenter.GetSeaRoute(data, t1, target);
                Route route2 = CachedCalculationCenter.GetSeaRoute(data, t2, target);
                int distance1 = 0;
                int distance2 = 0;
                distance1 = route1 == null ? DConstants.Integer_HalfMax : route1.getLength();
                distance2 = route2 == null ? DConstants.Integer_HalfMax : route2.getLength();
                return Integer.valueOf(distance1).compareTo(distance2);
            }
        });
    }

    public static List<Territory> SortTerritoriesBySeaDistance_D(List<Territory> ters, GameData data, Territory target) {
        return DUtils.InvertList(DSorting.SortTerritoriesBySeaDistance_A(ters, data, target));
    }

    public static List<Territory> SortTerritoriesByNoCondDistance_A(List<Territory> ters, final GameData data, final Territory target) {
        return DSorting.SortListByX(ters, new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                Route route1 = CachedCalculationCenter.GetRoute(data, t1, target);
                Route route2 = CachedCalculationCenter.GetRoute(data, t2, target);
                int distance1 = 0;
                int distance2 = 0;
                distance1 = route1 == null ? DConstants.Integer_HalfMax : route1.getLength();
                distance2 = route2 == null ? DConstants.Integer_HalfMax : route2.getLength();
                return Integer.valueOf(distance1).compareTo(distance2);
            }
        });
    }

    public static List<Territory> SortTerritoriesByNoCondDistance_D(List<Territory> ters, GameData data, Territory target) {
        return DUtils.InvertList(DSorting.SortTerritoriesByNoCondDistance_A(ters, data, target));
    }

    public static List<Territory> SortTerritoriesByLandThenNoCondDistance_A(List<Territory> ters, final GameData data, final Territory target) {
        return DSorting.SortListByX(ters, new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                Route route1 = CachedCalculationCenter.GetLandRoute(data, t1, target);
                Route route2 = CachedCalculationCenter.GetLandRoute(data, t2, target);
                Route route1_nc = CachedCalculationCenter.GetRoute(data, t1, target);
                Route route2_nc = CachedCalculationCenter.GetRoute(data, t2, target);
                if (route1_nc == null && route2_nc == null) {
                    return 0;
                }
                if (route1_nc == null) {
                    return 1;
                }
                if (route2_nc == null) {
                    return -1;
                }
                int distance1 = route1_nc.getLength() * 100;
                int distance2 = route2_nc.getLength() * 100;
                if (route1 != null) {
                    distance1 = route1.getLength();
                }
                if (route2 != null) {
                    distance2 = route2.getLength();
                }
                return Integer.valueOf(distance1).compareTo(distance2);
            }
        });
    }

    public static List<Territory> SortTerritoriesByLandThenNoCondDistance_D(List<Territory> ters, GameData data, Territory target) {
        return DUtils.InvertList(DSorting.SortTerritoriesByLandThenNoCondDistance_A(ters, data, target));
    }

    public static List<Unit> SortUnitsByCost_A(List<Unit> units, final Resource resource) {
        return DSorting.SortListByX(units, new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int cost1 = DUtils.GetTUVOfUnits(Collections.singletonList(o1), resource);
                int cost2 = DUtils.GetTUVOfUnits(Collections.singletonList(o2), resource);
                return Integer.valueOf(cost1).compareTo(cost2);
            }
        });
    }
}

