/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StrategyCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.StrategyType;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCM_TargetCalculator {
    public static Territory CalculateNCMTargetForTerritory(GameData data, PlayerID player, Territory ter, Collection<Unit> terUnits, List<NCM_Task> tasks) {
        float highestScore = -2.1474836E9f;
        Territory highestScoringTer = null;
        for (Territory enemyTer : data.getMap().getTerritories()) {
            if (enemyTer.isWater() || !DMatches.territoryIsOwnedByEnemy(data, player).match(enemyTer) || !DUtils.CanWeGetFromXToY_ByPassableLand(data, ter, enemyTer)) continue;
            float score = DUtils.GetValueOfLandTer(enemyTer, data, player);
            score -= (float)(DUtils.GetJumpsFromXToY_PassableLand(data, ter, enemyTer) * 3) * GlobalCenter.MapTerCountScale;
            if (StrategyCenter.get(data, player).GetCalculatedStrategyAssignments().get(enemyTer.getOwner()) == StrategyType.Enemy_Offensive) {
                score += 1.0E7f;
            }
            if (enemyTer.getOwner().isNull()) {
                score -= 1000000.0f;
            }
            if (!(score > highestScore)) continue;
            highestScore = score;
            highestScoringTer = enemyTer;
        }
        return highestScoringTer;
    }
}

