/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.weakAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.AIUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static List<Territory> getNeighboringEnemyLandTerritories(GameData data, PlayerID player) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (Territory t : data.getMap()) {
            if (!Matches.isTerritoryEnemy(player, data).match(t) || t.getOwner().isNull() || data.getMap().getNeighbors(t, Matches.isTerritoryOwnedBy(player)).isEmpty()) continue;
            rVal.add(t);
        }
        return rVal;
    }

    public static List<Unit> getUnitsUpToStrength(double maxStrength, Collection<Unit> units, boolean attacking, boolean sea) {
        if ((double)AIUtils.strength(units, attacking, sea) < maxStrength) {
            return new ArrayList<Unit>(units);
        }
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit u : units) {
            rVal.add(u);
            if (!((double)AIUtils.strength(rVal, attacking, sea) > maxStrength)) continue;
            return rVal;
        }
        return rVal;
    }

    public static float getStrengthOfPotentialAttackers(Territory location, GameData data) {
        float strength = 0.0f;
        for (Territory t : data.getMap().getNeighbors(location, location.isWater() ? Matches.TerritoryIsWater : Matches.TerritoryIsLand)) {
            List<Unit> enemies = t.getUnits().getMatches(Matches.enemyUnit(location.getOwner(), data));
            strength += AIUtils.strength(enemies, true, location.isWater());
        }
        return strength;
    }

    public static Route findNearest(Territory start, Match<Territory> endCondition, Match<Territory> routeCondition, GameData data) {
        Route shortestRoute = null;
        for (Territory t : data.getMap().getTerritories()) {
            if (!endCondition.match(t)) continue;
            CompositeMatchOr<Territory> routeOrEnd = new CompositeMatchOr<Territory>(routeCondition, Matches.territoryIs(t));
            Route r = data.getMap().getRoute(start, t, routeOrEnd);
            if (r == null || shortestRoute != null && r.getLength() >= shortestRoute.getLength()) continue;
            shortestRoute = r;
        }
        return shortestRoute;
    }

    public static boolean hasLandRouteToEnemyOwnedCapitol(Territory t, PlayerID us, GameData data) {
        for (PlayerID player : Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWar(us, data))) {
            for (Territory capital : TerritoryAttachment.getAllCurrentlyOwnedCapitals(player, data)) {
                if (data.getMap().getDistance(t, capital, Matches.TerritoryIsLand) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Territory> onlyWaterTerr(GameData data, List<Territory> allTerr) {
        ArrayList<Territory> water = new ArrayList<Territory>(allTerr);
        Iterator wFIter = water.iterator();
        while (wFIter.hasNext()) {
            Territory waterFact = (Territory)wFIter.next();
            if (Matches.TerritoryIsWater.match(waterFact)) continue;
            wFIter.remove();
        }
        return water;
    }

    public static List<Territory> findUnitTerr(GameData data, PlayerID player, Match<Unit> unitCondition) {
        CompositeMatchAnd<Unit> limitShips = new CompositeMatchAnd<Unit>(unitCondition);
        ArrayList<Territory> shipTerr = new ArrayList<Territory>();
        List<Territory> tNeighbors = data.getMap().getTerritories();
        for (Territory t2 : tNeighbors) {
            if (!t2.getUnits().someMatch(limitShips)) continue;
            shipTerr.add(t2);
        }
        return shipTerr;
    }
}

