/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRulesAttachment
extends AbstractConditionsAttachment
implements ICondition {
    private static final long serialVersionUID = -6977650137928964759L;
    @InternalDoNotExport
    protected boolean m_countEach = false;
    @InternalDoNotExport
    protected int m_eachMultiple = 1;
    @InternalDoNotExport
    protected int m_territoryCount = -1;
    protected ArrayList<PlayerID> m_players = new ArrayList();
    protected int m_objectiveValue = 0;
    protected int m_uses = -1;
    protected HashMap<Integer, Integer> m_turns = null;
    protected boolean m_switch = true;
    protected String m_gameProperty = null;

    public AbstractRulesAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlayers(String names) throws GameParseException {
        PlayerList pl = this.getData().getPlayerList();
        for (String p : names.split(":")) {
            PlayerID player = pl.getPlayerID(p);
            if (player == null) {
                throw new GameParseException("Could not find player. name:" + p + this.thisErrorMsg());
            }
            this.m_players.add(player);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayers(ArrayList<PlayerID> value) {
        this.m_players = value;
    }

    public ArrayList<PlayerID> getPlayers() {
        if (this.m_players.isEmpty()) {
            return new ArrayList<PlayerID>(Collections.singletonList((PlayerID)this.getAttachedTo()));
        }
        return this.m_players;
    }

    public void clearPlayers() {
        this.m_players.clear();
    }

    public void resetPlayers() {
        this.m_players = new ArrayList();
    }

    @Override
    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChance(String chance) throws GameParseException {
        throw new GameParseException("chance not allowed for use with RulesAttachments, instead use it with Triggers or PoliticalActions" + this.thisErrorMsg());
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setObjectiveValue(String value) {
        this.m_objectiveValue = AbstractRulesAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setObjectiveValue(Integer value) {
        this.m_objectiveValue = value;
    }

    public int getObjectiveValue() {
        return this.m_objectiveValue;
    }

    public void resetObjectiveValue() {
        this.m_objectiveValue = 0;
    }

    @InternalDoNotExport
    protected void setTerritoryCount(String value) {
        if (value.equals("each")) {
            this.m_territoryCount = 1;
            this.m_countEach = true;
        } else {
            this.m_territoryCount = AbstractRulesAttachment.getInt(value);
        }
    }

    public int getTerritoryCount() {
        return this.m_territoryCount;
    }

    public int getEachMultiple() {
        if (!this.getCountEach()) {
            return 1;
        }
        return this.m_eachMultiple;
    }

    protected boolean getCountEach() {
        return this.m_countEach;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUses(String s) {
        this.m_uses = AbstractRulesAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUses(Integer u) {
        this.m_uses = u;
    }

    public int getUses() {
        return this.m_uses;
    }

    public void resetUses() {
        this.m_uses = -1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSwitch(String value) {
        this.m_switch = AbstractRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSwitch(Boolean value) {
        this.m_switch = value;
    }

    public boolean getSwitch() {
        return this.m_switch;
    }

    public void resetSwitch() {
        this.m_switch = true;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setGameProperty(String value) {
        this.m_gameProperty = value;
    }

    public String getGameProperty() {
        return this.m_gameProperty;
    }

    public boolean getGamePropertyState(GameData data) {
        if (this.m_gameProperty == null) {
            return false;
        }
        return data.getProperties().get(this.m_gameProperty, false);
    }

    public void resetGameProperty() {
        this.m_gameProperty = null;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTurns(String turns) throws GameParseException {
        if (turns == null) {
            this.m_turns = null;
            return;
        }
        this.m_turns = new HashMap();
        String[] s = turns.split(":");
        if (s.length < 1) {
            throw new GameParseException("Empty turn list" + this.thisErrorMsg());
        }
        for (String subString : s) {
            int end;
            int start;
            try {
                end = start = AbstractRulesAttachment.getInt(subString);
            }
            catch (Exception e) {
                String[] s2 = subString.split("-");
                if (s2.length != 2) {
                    throw new GameParseException("Invalid syntax for turn range, must be 'int-int'" + this.thisErrorMsg());
                }
                start = AbstractRulesAttachment.getInt(s2[0]);
                end = s2[1].equals("+") ? Integer.MAX_VALUE : AbstractRulesAttachment.getInt(s2[1]);
            }
            Integer t = start;
            Integer u = end;
            this.m_turns.put(t, u);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTurns(HashMap<Integer, Integer> value) {
        this.m_turns = value;
    }

    public HashMap<Integer, Integer> getTurns() {
        return this.m_turns;
    }

    public void resetTurns() {
        this.m_turns = null;
    }

    protected boolean checkTurns(GameData data) {
        int turn = data.getSequence().getRound();
        for (Integer t : this.m_turns.keySet()) {
            if (turn < t || turn > this.m_turns.get(t)) continue;
            return true;
        }
        return false;
    }

    protected Set<Territory> getTerritoriesBasedOnStringName(String name, Collection<PlayerID> players, GameData data) {
        GameMap gameMap = data.getMap();
        if (name.equals("original") || name.equals("enemy")) {
            HashSet<Territory> originalTerrs = new HashSet<Territory>();
            for (PlayerID player : players) {
                originalTerrs.addAll(OriginalOwnerTracker.getOriginallyOwned(data, player));
            }
            this.setTerritoryCount(String.valueOf(originalTerrs.size()));
            return originalTerrs;
        }
        if (name.equals("originalNoWater")) {
            HashSet<Territory> originalTerrs = new HashSet<Territory>();
            for (PlayerID player : players) {
                originalTerrs.addAll(Match.getMatches(OriginalOwnerTracker.getOriginallyOwned(data, player), Matches.TerritoryIsNotImpassableToLandUnits(player, data)));
            }
            this.setTerritoryCount(String.valueOf(originalTerrs.size()));
            return originalTerrs;
        }
        if (name.equals("controlled")) {
            HashSet<Territory> ownedTerrs = new HashSet<Territory>();
            for (PlayerID player : players) {
                ownedTerrs.addAll(gameMap.getTerritoriesOwnedBy(player));
            }
            this.setTerritoryCount(String.valueOf(ownedTerrs.size()));
            return ownedTerrs;
        }
        if (name.equals("controlledNoWater")) {
            HashSet<Territory> ownedTerrsNoWater = new HashSet<Territory>();
            for (PlayerID player : players) {
                ownedTerrsNoWater.addAll(Match.getMatches(gameMap.getTerritoriesOwnedBy(player), Matches.TerritoryIsNotImpassableToLandUnits(player, data)));
            }
            this.setTerritoryCount(String.valueOf(ownedTerrsNoWater.size()));
            return ownedTerrsNoWater;
        }
        if (name.equals("all")) {
            HashSet<Territory> allTerrs = new HashSet<Territory>();
            for (PlayerID player : players) {
                allTerrs.addAll(gameMap.getTerritoriesOwnedBy(player));
                allTerrs.addAll(OriginalOwnerTracker.getOriginallyOwned(data, player));
            }
            this.setTerritoryCount(String.valueOf(allTerrs.size()));
            return allTerrs;
        }
        if (name.equals("map")) {
            HashSet<Territory> allTerrs = new HashSet<Territory>(gameMap.getTerritories());
            this.setTerritoryCount(String.valueOf(allTerrs.size()));
            return allTerrs;
        }
        HashSet<Territory> terr = new HashSet<Territory>();
        Territory t = data.getMap().getTerritory(name);
        if (t == null) {
            throw new IllegalStateException("No territory called:" + name + this.thisErrorMsg());
        }
        terr.add(t);
        this.setTerritoryCount(String.valueOf(1));
        return terr;
    }

    protected Set<Territory> getTerritoryListBasedOnInputFromXML(String[] terrs, Collection<PlayerID> players, GameData data) {
        if (terrs.length == 1) {
            return this.getTerritoriesBasedOnStringName(terrs[0], players, data);
        }
        if (terrs.length == 2) {
            if (!(terrs[1].equals("controlled") || terrs[1].equals("controlledNoWater") || terrs[1].equals("original") || terrs[1].equals("originalNoWater") || terrs[1].equals("all") || terrs[1].equals("map") || terrs[1].equals("enemy"))) {
                return this.getListedTerritories(terrs, true, true);
            }
            Set<Territory> rVal = this.getTerritoriesBasedOnStringName(terrs[1], players, data);
            this.setTerritoryCount(String.valueOf(terrs[0]));
            return rVal;
        }
        return this.getListedTerritories(terrs, true, true);
    }

    protected void validateNames(String[] terrList) throws GameParseException {
        if (terrList != null && terrList.length > 0) {
            this.getListedTerritories(terrList, true, true);
        }
    }

    public Set<Territory> getListedTerritories(String[] list, boolean testFirstItemForCount, boolean mustSetTerritoryCount) {
        HashSet<Territory> rVal = new HashSet<Territory>();
        if (list == null || list.length == 0 || list.length == 1 && (list[0] == null || list[0].length() == 0)) {
            return rVal;
        }
        boolean haveSetCount = false;
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (testFirstItemForCount && i == 0) {
                try {
                    AbstractRulesAttachment.getInt(name);
                    if (!mustSetTerritoryCount) continue;
                    haveSetCount = true;
                    this.setTerritoryCount(name);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (name.equals("each")) {
                this.m_countEach = true;
                if (!mustSetTerritoryCount) continue;
                haveSetCount = true;
                this.setTerritoryCount(String.valueOf(1));
                continue;
            }
            if (name.equals("controlled") || name.equals("controlledNoWater") || name.equals("original") || name.equals("originalNoWater") || name.equals("all") || name.equals("map") || name.equals("enemy")) break;
            Territory territory = this.getData().getMap().getTerritory(name);
            if (territory == null) {
                throw new IllegalStateException("No territory called:" + name + this.thisErrorMsg());
            }
            rVal.add(territory);
        }
        if (mustSetTerritoryCount && !haveSetCount) {
            this.setTerritoryCount(String.valueOf(rVal.size()));
        }
        return rVal;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
    }
}

