/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserActionAttachment
extends AbstractConditionsAttachment
implements ICondition {
    private static final long serialVersionUID = 3569461523853104614L;
    public static final String ATTEMPTS_LEFT_THIS_TURN = "attemptsLeftThisTurn";
    protected String m_text = "";
    protected int m_costPU = 0;
    protected int m_attemptsPerTurn = 1;
    @InternalDoNotExport
    protected int m_attemptsLeftThisTurn = 1;
    protected ArrayList<PlayerID> m_actionAccept = new ArrayList();

    public AbstractUserActionAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Match<AbstractUserActionAttachment> isSatisfiedMatch(final HashMap<ICondition, Boolean> testedConditions) {
        return new Match<AbstractUserActionAttachment>(){

            @Override
            public boolean match(AbstractUserActionAttachment value) {
                return value.isSatisfied(testedConditions);
            }
        };
    }

    public boolean canPerform(HashMap<ICondition, Boolean> testedConditions) {
        return this.m_conditions == null || this.isSatisfied(testedConditions);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setText(String text) {
        this.m_text = text;
    }

    public String getText() {
        return this.m_text;
    }

    public void resetText() {
        this.m_text = "";
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCostPU(String s) {
        this.m_costPU = AbstractUserActionAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCostPU(Integer s) {
        this.m_costPU = s;
    }

    public int getCostPU() {
        return this.m_costPU;
    }

    public void resetCostPU() {
        this.m_costPU = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setActionAccept(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_actionAccept.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setActionAccept(ArrayList<PlayerID> value) {
        this.m_actionAccept = value;
    }

    public ArrayList<PlayerID> getActionAccept() {
        return this.m_actionAccept;
    }

    public void clearActionAccept() {
        this.m_actionAccept.clear();
    }

    public void resetActionAccept() {
        this.m_actionAccept = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttemptsPerTurn(String s) {
        this.m_attemptsPerTurn = AbstractUserActionAttachment.getInt(s);
        this.setAttemptsLeftThisTurn(this.m_attemptsPerTurn);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttemptsPerTurn(Integer s) {
        this.m_attemptsPerTurn = s;
        this.setAttemptsLeftThisTurn(this.m_attemptsPerTurn);
    }

    public int getAttemptsPerTurn() {
        return this.m_attemptsPerTurn;
    }

    public void resetAttemptsPerTurn() {
        this.m_attemptsPerTurn = 1;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAttemptsLeftThisTurn(int attempts) {
        this.m_attemptsLeftThisTurn = attempts;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAttemptsLeftThisTurn(Integer attempts) {
        this.m_attemptsLeftThisTurn = attempts;
    }

    public int getAttemptsLeftThisTurn() {
        return this.m_attemptsLeftThisTurn;
    }

    public void resetAttemptsLeftThisTurn() {
        this.m_attemptsLeftThisTurn = 1;
    }

    public void resetAttempts(IDelegateBridge aBridge) {
        if (this.m_attemptsLeftThisTurn != this.m_attemptsPerTurn) {
            aBridge.addChange(ChangeFactory.attachmentPropertyChange(this, this.m_attemptsPerTurn, ATTEMPTS_LEFT_THIS_TURN));
        }
    }

    public void useAttempt(IDelegateBridge aBridge) {
        aBridge.addChange(ChangeFactory.attachmentPropertyChange(this, this.m_attemptsLeftThisTurn - 1, ATTEMPTS_LEFT_THIS_TURN));
    }

    public boolean hasAttemptsLeft() {
        return this.m_attemptsLeftThisTurn > 0;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        if (this.m_text.trim().length() <= 0) {
            throw new GameParseException("value: text can't be empty" + this.thisErrorMsg());
        }
    }
}

