/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.AbstractUserActionAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliticalActionAttachment
extends AbstractUserActionAttachment
implements ICondition {
    private static final long serialVersionUID = 4392770599777282477L;
    private ArrayList<String> m_relationshipChange = new ArrayList();

    public PoliticalActionAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Collection<PoliticalActionAttachment> getPoliticalActionAttachments(PlayerID player) {
        ArrayList<PoliticalActionAttachment> returnList = new ArrayList<PoliticalActionAttachment>();
        Map<String, IAttachment> map = player.getAttachments();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IAttachment a = map.get(iter.next());
            if (!a.getName().startsWith("politicalActionAttachment") || !(a instanceof PoliticalActionAttachment)) continue;
            returnList.add((PoliticalActionAttachment)a);
        }
        return returnList;
    }

    public static PoliticalActionAttachment get(PlayerID player, String nameOfAttachment) {
        return PoliticalActionAttachment.get(player, nameOfAttachment, null);
    }

    public static PoliticalActionAttachment get(PlayerID player, String nameOfAttachment, Collection<PlayerID> playersToSearch) {
        PoliticalActionAttachment rVal = (PoliticalActionAttachment)player.getAttachment(nameOfAttachment);
        if (rVal == null) {
            if (playersToSearch == null) {
                throw new IllegalStateException("PoliticalActionAttachment: No attachment for:" + player.getName() + " with name: " + nameOfAttachment);
            }
            for (PlayerID otherPlayer : playersToSearch) {
                if (otherPlayer == player || (rVal = (PoliticalActionAttachment)otherPlayer.getAttachment(nameOfAttachment)) == null) continue;
                return rVal;
            }
            throw new IllegalStateException("PoliticalActionAttachment: No attachment for:" + player.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationshipChange(String relChange) throws GameParseException {
        String[] s = relChange.split(":");
        if (s.length != 3) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n Use: player1:player2:newRelation\n" + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[0]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[0] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[1]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[1] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        if (!Matches.isValidRelationshipName(this.getData()).match(s[2])) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n relationshipType: " + s[2] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        this.m_relationshipChange.add(relChange);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipChange(ArrayList<String> value) {
        this.m_relationshipChange = value;
    }

    public ArrayList<String> getRelationshipChange() {
        return this.m_relationshipChange;
    }

    public void clearRelationshipChange() {
        this.m_relationshipChange.clear();
    }

    public void resetRelationshipChange() {
        this.m_relationshipChange = new ArrayList();
    }

    public Set<PlayerID> getOtherPlayers() {
        HashSet<PlayerID> otherPlayers = new HashSet<PlayerID>();
        for (String relationshipChange : this.m_relationshipChange) {
            String[] s = relationshipChange.split(":");
            otherPlayers.add(this.getData().getPlayerList().getPlayerID(s[0]));
            otherPlayers.add(this.getData().getPlayerList().getPlayerID(s[1]));
        }
        otherPlayers.remove(this.getAttachedTo());
        return otherPlayers;
    }

    public static Collection<PoliticalActionAttachment> getValidActions(PlayerID player, HashMap<ICondition, Boolean> testedConditions, GameData data) {
        if (!Properties.getUsePolitics(data) || !player.amNotDeadYet(data)) {
            return new ArrayList<PoliticalActionAttachment>();
        }
        return Match.getMatches(PoliticalActionAttachment.getPoliticalActionAttachments(player), new CompositeMatchAnd(Matches.AbstractUserActionAttachmentCanBeAttempted(testedConditions), Matches.politicalActionAffectsAtLeastOneAlivePlayer(player, data)));
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        if (this.m_relationshipChange.isEmpty()) {
            throw new GameParseException("value: relationshipChange can't be empty" + this.thisErrorMsg());
        }
    }
}

