/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AAInMoveUtil
implements Serializable {
    private static final long serialVersionUID = 1787497998642717678L;
    private transient boolean m_nonCombat;
    private transient IDelegateBridge m_bridge;
    private transient PlayerID m_player;
    private Collection<Unit> m_casualties = new ArrayList<Unit>();
    private final ExecutionStack m_executionStack = new ExecutionStack();

    AAInMoveUtil() {
    }

    public AAInMoveUtil initialize(IDelegateBridge bridge) {
        this.m_nonCombat = MoveDelegate.isNonCombat(bridge);
        this.m_bridge = bridge;
        this.m_player = bridge.getPlayerID();
        return this;
    }

    private GameData getData() {
        return this.m_bridge.getData();
    }

    private boolean isAlwaysONAAEnabled() {
        return Properties.getAlwaysOnAA(this.getData());
    }

    private boolean isAATerritoryRestricted() {
        return Properties.getAATerritoryRestricted(this.getData());
    }

    private ITripleaPlayer getRemotePlayer(PlayerID id) {
        return (ITripleaPlayer)this.m_bridge.getRemotePlayer(id);
    }

    private ITripleaPlayer getRemotePlayer() {
        return this.getRemotePlayer(this.m_player);
    }

    Collection<Unit> fireAA(Route route, Collection<Unit> units, Comparator<Unit> decreasingMovement, UndoableMove currentMove) {
        if (this.m_executionStack.isEmpty()) {
            this.populateExecutionStack(route, units, decreasingMovement, currentMove);
        }
        this.m_executionStack.execute(this.m_bridge);
        return this.m_casualties;
    }

    private void populateExecutionStack(Route route, Collection<Unit> units, Comparator<Unit> decreasingMovement, final UndoableMove currentMove) {
        final ArrayList<Unit> targets = new ArrayList<Unit>(units);
        Collections.sort(targets, decreasingMovement);
        ArrayList<IExecutable> executables = new ArrayList<IExecutable>();
        for (final Territory location : this.getTerritoriesWhereAAWillFire(route, units)) {
            executables.add(new IExecutable(){
                private static final long serialVersionUID = -1545771595683434276L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AAInMoveUtil.this.fireAA(location, targets, currentMove);
                }
            });
        }
        Collections.reverse(executables);
        this.m_executionStack.push(executables);
    }

    Collection<Territory> getTerritoriesWhereAAWillFire(Route route, Collection<Unit> units) {
        boolean alwaysOnAA = this.isAlwaysONAAEnabled();
        if (!alwaysOnAA && this.isAATerritoryRestricted()) {
            return Collections.emptyList();
        }
        if (this.m_nonCombat && !alwaysOnAA) {
            return Collections.emptyList();
        }
        PlayerID movingPlayer = this.movingPlayer(units);
        HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed = TechAbilityAttachment.getAirborneTargettedByAA(movingPlayer, this.getData());
        Match<Unit> hasAA = Matches.UnitIsAAthatCanFire(units, airborneTechTargetsAllowed, movingPlayer, Matches.UnitIsAAforFlyOverOnly, 1, true, this.getData());
        ArrayList<Territory> territoriesWhereAAWillFire = new ArrayList<Territory>();
        for (Territory current : route.getMiddleSteps()) {
            if (!current.getUnits().someMatch(hasAA)) continue;
            territoriesWhereAAWillFire.add(current);
        }
        if (route.getStart().getUnits().someMatch(hasAA) && !this.getBattleTracker().wasBattleFought(route.getStart())) {
            territoriesWhereAAWillFire.add(route.getStart());
        }
        if (Properties.getForceAAattacksForLastStepOfFlyOver(this.getData()) && route.getEnd().getUnits().someMatch(hasAA)) {
            territoriesWhereAAWillFire.add(route.getEnd());
        }
        return territoriesWhereAAWillFire;
    }

    private BattleTracker getBattleTracker() {
        return DelegateFinder.battleDelegate(this.getData()).getBattleTracker();
    }

    private PlayerID movingPlayer(Collection<Unit> units) {
        if (Match.someMatch(units, Matches.unitIsOwnedBy(this.m_player))) {
            return this.m_player;
        }
        return units.iterator().next().getOwner();
    }

    private void fireAA(final Territory territory, final Collection<Unit> units, UndoableMove currentMove) {
        if (units.isEmpty()) {
            return;
        }
        PlayerID movingPlayer = this.movingPlayer(units);
        HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed = TechAbilityAttachment.getAirborneTargettedByAA(movingPlayer, this.getData());
        List<Unit> defendingAA = territory.getUnits().getMatches(Matches.UnitIsAAthatCanFire(units, airborneTechTargetsAllowed, movingPlayer, Matches.UnitIsAAforFlyOverOnly, 1, true, this.getData()));
        List<String> AAtypes = UnitAttachment.getAllOfTypeAAs(defendingAA);
        Collections.reverse(AAtypes);
        for (final String currentTypeAA : AAtypes) {
            final List<Unit> currentPossibleAA = Match.getMatches(defendingAA, Matches.UnitIsAAofTypeAA(currentTypeAA));
            HashSet<UnitType> targetUnitTypesForThisTypeAA = UnitAttachment.get(((Unit)currentPossibleAA.iterator().next()).getType()).getTargetsAA(this.getData());
            Set airborneTypesTargettedToo = airborneTechTargetsAllowed.get(currentTypeAA);
            final List<Unit> validAttackingUnitsForThisRoll = Match.getMatches(units, new CompositeMatchOr(Matches.unitIsOfTypes(targetUnitTypesForThisTypeAA), new CompositeMatchAnd(Matches.UnitIsAirborne, Matches.unitIsOfTypes(airborneTypesTargettedToo))));
            currentMove.setCantUndo("Move cannot be undone after " + currentTypeAA + " has fired.");
            final DiceRoll[] dice = new DiceRoll[1];
            IExecutable rollDice = new IExecutable(){
                private static final long serialVersionUID = 4714364489659654758L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    validAttackingUnitsForThisRoll.removeAll(AAInMoveUtil.this.m_casualties);
                    if (!validAttackingUnitsForThisRoll.isEmpty()) {
                        dice[0] = DiceRoll.rollAA(validAttackingUnitsForThisRoll, currentPossibleAA, AAInMoveUtil.this.m_bridge, territory, true);
                    }
                }
            };
            IExecutable selectCasualties = new IExecutable(){
                private static final long serialVersionUID = -8633263235214834617L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    if (!validAttackingUnitsForThisRoll.isEmpty()) {
                        int hitCount = dice[0].getHits();
                        if (hitCount == 0) {
                            if (currentTypeAA.equals("AA")) {
                                AAInMoveUtil.this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("battle_aa_miss", AAInMoveUtil.this.findDefender(currentPossibleAA).getName());
                            } else {
                                AAInMoveUtil.this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("battle_" + currentTypeAA.toLowerCase() + "_miss", AAInMoveUtil.this.findDefender(currentPossibleAA).getName());
                            }
                            AAInMoveUtil.this.getRemotePlayer().reportMessage("No " + currentTypeAA + " hits in " + territory.getName(), "No " + currentTypeAA + " hits in " + territory.getName());
                        } else {
                            if (currentTypeAA.equals("AA")) {
                                AAInMoveUtil.this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("battle_aa_hit", AAInMoveUtil.this.findDefender(currentPossibleAA).getName());
                            } else {
                                AAInMoveUtil.this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("battle_" + currentTypeAA.toLowerCase() + "_hit", AAInMoveUtil.this.findDefender(currentPossibleAA).getName());
                            }
                            AAInMoveUtil.this.selectCasualties(dice[0], units, validAttackingUnitsForThisRoll, currentPossibleAA, territory, null, currentTypeAA);
                        }
                    }
                }
            };
            this.m_executionStack.push(selectCasualties);
            this.m_executionStack.push(rollDice);
        }
    }

    private PlayerID findDefender(Collection<Unit> defendingUnits) {
        if (defendingUnits == null || defendingUnits.isEmpty()) {
            return PlayerID.NULL_PLAYERID;
        }
        return defendingUnits.iterator().next().getOwner();
    }

    private void selectCasualties(DiceRoll dice, Collection<Unit> allAttackingUnits, Collection<Unit> validAttackingUnitsForThisRoll, Collection<Unit> defendingAA, Territory territory, GUID battleID, String currentTypeAA) {
        CasualtyDetails casualties = BattleCalculator.getAACasualties(false, validAttackingUnitsForThisRoll, defendingAA, dice, this.m_bridge, territory.getOwner(), this.m_player, battleID, territory, TerritoryEffectHelper.getEffects(territory));
        this.getRemotePlayer().reportMessage(casualties.size() + " " + currentTypeAA + " hits in " + territory.getName(), casualties.size() + " " + currentTypeAA + " hits in " + territory.getName());
        BattleDelegate.markDamaged(new ArrayList<Unit>(casualties.getDamaged()), this.m_bridge);
        this.m_bridge.getHistoryWriter().addChildToEvent(MyFormatter.unitsToTextNoOwner(casualties.getKilled()) + " lost in " + territory.getName(), new ArrayList<Unit>(casualties.getKilled()));
        allAttackingUnits.removeAll(casualties.getKilled());
        if (this.m_casualties == null) {
            this.m_casualties = new ArrayList<Unit>(casualties.getKilled());
        } else {
            this.m_casualties.addAll(casualties.getKilled());
        }
    }
}

